/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweaks.carry.transforms;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.charset.module.tweaks.carry.ICarryTransformer;

public class CarryTransformerEntityMinecart
implements ICarryTransformer<Entity> {
    protected Entity transform(Entity object, Class<? extends Entity> target, boolean simulate) {
        return this.transform(object, target, null, simulate);
    }

    protected Entity transform(Entity object, Class<? extends Entity> target, NBTTagCompound patchTag, boolean simulate) {
        Entity targetEntity = null;
        if (!object.field_70170_p.field_72995_K && !simulate) {
            World world = object.field_70170_p;
            NBTTagCompound compound = new NBTTagCompound();
            compound = object.func_189511_e(compound);
            compound.func_82580_o("UUIDLeast");
            compound.func_82580_o("UUIDMost");
            if (patchTag != null) {
                for (String tag : patchTag.func_150296_c()) {
                    compound.func_74782_a(tag, patchTag.func_74781_a(tag));
                }
            }
            object.func_184174_b(false);
            object.func_70106_y();
            try {
                targetEntity = target.getConstructor(World.class).newInstance(world);
                targetEntity.func_70020_e(compound);
                world.func_72838_d(targetEntity);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            World world = object.field_70170_p;
            targetEntity = target.getConstructor(World.class).newInstance(world);
        }
        catch (Exception e) {
            return null;
        }
        return targetEntity;
    }

    protected Entity copyEntityToTile(TileEntity target, Entity container, String ... tags) {
        NBTTagCompound compound = container.func_189511_e(new NBTTagCompound());
        NBTTagCompound targetCompound = new NBTTagCompound();
        for (String tag : tags) {
            targetCompound.func_74782_a(tag, compound.func_74781_a(tag));
        }
        target.func_145839_a(targetCompound);
        return container;
    }

    protected NBTTagCompound filter(NBTTagCompound compound, String ... tags) {
        NBTTagCompound out = new NBTTagCompound();
        for (String tag : tags) {
            if (!compound.func_74764_b(tag)) continue;
            out.func_74782_a(tag, compound.func_74781_a(tag));
        }
        return out;
    }

    protected Pair<IBlockState, TileEntity> getExtractedPair(@Nonnull Entity object, boolean simulate) {
        if (object instanceof EntityMinecartTNT) {
            return Pair.of((Object)Blocks.field_150335_W.func_176223_P(), null);
        }
        if (object instanceof EntityMinecartCommandBlock) {
            TileEntityCommandBlock tile = new TileEntityCommandBlock();
            NBTTagCompound compound = ((EntityMinecartCommandBlock)object).func_145822_e().func_189510_a(new NBTTagCompound());
            tile.func_145839_a(compound);
            return Pair.of((Object)Blocks.field_150483_bI.func_176223_P(), (Object)tile);
        }
        if (object instanceof EntityMinecartChest) {
            TileEntityChest tile = new TileEntityChest();
            this.copyEntityToTile((TileEntity)tile, object, "Items");
            return Pair.of((Object)Blocks.field_150486_ae.func_176223_P(), (Object)tile);
        }
        if (object instanceof EntityMinecartHopper) {
            TileEntityHopper tile = new TileEntityHopper();
            this.copyEntityToTile((TileEntity)tile, object, "Items");
            return Pair.of((Object)Blocks.field_150438_bZ.func_176223_P(), (Object)tile);
        }
        return null;
    }

    @Override
    @Nullable
    public final Pair<IBlockState, TileEntity> extract(@Nonnull Entity object, boolean simulate) {
        Pair<IBlockState, TileEntity> result = this.getExtractedPair(object, simulate);
        if (result != null && this.transform(object, EntityMinecartEmpty.class, simulate) != null) {
            return result;
        }
        return null;
    }

    @Override
    public boolean insert(@Nonnull Entity object, @Nonnull IBlockState state, @Nullable TileEntity tile, boolean simulate) {
        if (state.func_177230_c() == Blocks.field_150335_W) {
            return this.transform(object, EntityMinecartTNT.class, simulate) != null;
        }
        if (state.func_177230_c() == Blocks.field_150483_bI) {
            return this.transform(object, EntityMinecartCommandBlock.class, ((TileEntityCommandBlock)tile).func_145993_a().func_189510_a(new NBTTagCompound()), simulate) != null;
        }
        if (state.func_177230_c() == Blocks.field_150486_ae) {
            return this.transform(object, EntityMinecartChest.class, this.filter(tile.func_189515_b(new NBTTagCompound()), "Items"), simulate) != null;
        }
        if (state.func_177230_c() == Blocks.field_150438_bZ) {
            return this.transform(object, EntityMinecartHopper.class, this.filter(tile.func_189515_b(new NBTTagCompound()), "Items"), simulate) != null;
        }
        return false;
    }
}

