/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweaks.dynlights;

import com.elytradev.mirage.event.GatherLightsEvent;
import com.elytradev.mirage.lighting.Light;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.utils.ItemUtils;

@CharsetModule(name="tweak.dynamicLights", description="Dynamic lights, based on Albedo!", dependencies={"mod:albedo"}, isClientOnly=true, profile=ModuleProfile.TESTING)
public class CharsetTweakDynamicLights {
    @CharsetModule.Configuration
    public static Configuration config;
    private static Map<LightKey, float[]> lightData;
    public static boolean enablePlayerLights;
    public static boolean enableEntityLights;
    public static boolean enableFireLights;
    public static boolean enableExplosionLights;
    public static boolean enableItemLights;
    public static float blockBrightnessDivider;

    @Mod.EventHandler
    public void loadConfig(CharsetLoadConfigEvent event) {
        enableExplosionLights = ConfigUtils.getBoolean(config, "sources", "explosion", true, "Light sources based on being ready for an explosion.", false);
        enableFireLights = ConfigUtils.getBoolean(config, "sources", "fire", true, "Light sources based on being lit on fire.", false);
        enableItemLights = ConfigUtils.getBoolean(config, "sources", "items", true, "Light sources based on items.", false);
        enableEntityLights = ConfigUtils.getBoolean(config, "holders", "entities", true, "Light sources held by non-player entities.", false);
        enablePlayerLights = ConfigUtils.getBoolean(config, "holders", "players", true, "Light sources held by players.", false);
        blockBrightnessDivider = 1.0f / ConfigUtils.getFloat(config, "general", "blockBrightnessMultiplier", 0.4f, 0.0f, 1.0f, "The multiplier for block-derived light brightness.", false);
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
    }

    private Light getLight(double x, double y, double z, ItemStack s) {
        LightKey key = new LightKey(s.func_77973_b(), s.func_77960_j());
        float[] data = lightData.computeIfAbsent(key, lightKey -> {
            try {
                IBlockState b;
                if (key.item instanceof ItemBlock && (b = ItemUtils.getBlockState(s)).func_185906_d() > 0) {
                    return new float[]{1.0f, 1.0f, 1.0f, (float)b.func_185906_d() / (16.0f * blockBrightnessDivider), (float)b.func_185906_d() / blockBrightnessDivider};
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        });
        if (data != null) {
            return Light.builder().pos(x, y, z).color(data[0], data[1], data[2], data[3]).radius(data[4]).build();
        }
        return null;
    }

    private void addLight(List<Light> lights, Entity e) {
        if (enableExplosionLights) {
            if (e instanceof EntityCreeper) {
                float brightness = ((EntityCreeper)e).func_70831_j(Minecraft.func_71410_x().func_184121_ak());
                if (brightness > 0.001f) {
                    lights.add(Light.builder().pos(e).color(1.0f, 1.0f, 1.0f, brightness).radius(10.0f / blockBrightnessDivider).build());
                }
            } else if (e instanceof EntityTNTPrimed) {
                lights.add(Light.builder().pos(e).color(1.0f, 1.0f, 1.0f, 0.5f).radius(10.0f / blockBrightnessDivider).build());
            }
        }
        if (enableFireLights && e.func_70027_ad()) {
            float lv = Blocks.field_150480_ab.func_176223_P().func_185906_d();
            lights.add(Light.builder().pos(e).color(1.0f, 1.0f, 1.0f, lv / (16.0f * blockBrightnessDivider)).radius(lv / blockBrightnessDivider).build());
        }
        for (ItemStack s : e.func_184214_aD()) {
            Light light = this.getLight(e.field_70165_t, e.field_70163_u, e.field_70161_v, s);
            if (light == null) continue;
            lights.add(light);
        }
    }

    @SubscribeEvent
    public void onGatherLights(GatherLightsEvent event) {
        ArrayList lights = event.getLightList();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (enableEntityLights) {
            player.func_130014_f_().field_72996_f.forEach(e -> {
                if (!enablePlayerLights && e instanceof EntityPlayer) {
                    return;
                }
                this.addLight(lights, (Entity)e);
            });
        } else if (enablePlayerLights) {
            player.func_130014_f_().field_73010_i.forEach(e -> this.addLight(lights, (Entity)e));
        }
    }

    static {
        lightData = new HashMap<LightKey, float[]>();
    }

    public static class LightKey {
        public final Item item;
        public final int meta;

        public LightKey(Item item, int meta) {
            this.item = item;
            this.meta = meta;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LightKey)) {
                return false;
            }
            LightKey other = (LightKey)o;
            return other.item == this.item && other.meta == this.meta;
        }

        public int hashCode() {
            return 31 * this.item.hashCode() + this.meta;
        }
    }
}

