/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweaks.remove;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.recipe.RecipeDummy;

@CharsetModule(name="tweak.remove.vanillaStyleTools", profile=ModuleProfile.STABLE, isDefault=false)
public class CharsetTweakRemoveVanillaTools {
    @CharsetModule.Configuration
    public static Configuration config;
    private boolean neutralize;
    private boolean disableRecipes;
    private Set<String> disabledClasses = new HashSet<String>();

    @Mod.EventHandler
    public void loadConfig(CharsetLoadConfigEvent event) {
        this.neutralize = config.getBoolean("neutralizeItems", "features", true, "Set to true to enable neutralizing tool items (setting maximum damage to 1).");
        this.disableRecipes = config.getBoolean("disableRecipes", "features", true, "Set to true to enable disabling recipes for tool items.");
        for (String s : new String[]{"pickaxe", "axe", "hoe", "sword", "spade"}) {
            if (!config.getBoolean(s, "disabledClasses", true, "")) continue;
            this.disabledClasses.add(s);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        HashSet<Item> itemSet = new HashSet<Item>();
        for (ResourceLocation l : Item.field_150901_e.func_148742_b()) {
            Item i = (Item)Item.field_150901_e.func_82594_a((Object)l);
            if (!(i instanceof ItemPickaxe && this.disabledClasses.contains("pickaxe") || i instanceof ItemAxe && this.disabledClasses.contains("axe") || i instanceof ItemHoe && this.disabledClasses.contains("hoe") || i instanceof ItemSpade && this.disabledClasses.contains("spade")) && (!(i instanceof ItemSword) || !this.disabledClasses.contains("sword"))) continue;
            if (this.neutralize) {
                i.func_77656_e(1);
            }
            itemSet.add(i);
        }
        if (this.disableRecipes) {
            for (IRecipe recipe : CraftingManager.field_193380_a) {
                ItemStack output = recipe.func_77571_b();
                if (output.func_190926_b() || !itemSet.contains(output.func_77973_b())) continue;
                ForgeRegistries.RECIPES.register(new RecipeDummy(recipe.func_193358_e()).setRegistryName(recipe.getRegistryName()));
                itemSet.remove(output.func_77973_b());
                ModCharset.logger.info("Disabled " + ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)output.func_77973_b())).toString() + " (removed recipe)");
            }
        }
        for (Item i : itemSet) {
            ModCharset.logger.info("Disabled " + ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)i)).toString());
        }
    }
}

