/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.block.enums.CompressedVariant;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.client.ModelUtils;
import twilightforest.item.TFItems;

public class BlockTFCompressed
extends Block
implements ModelRegisterCallback {
    public static final PropertyEnum<CompressedVariant> VARIANT = PropertyEnum.func_177709_a((String)"variant", CompressedVariant.class);

    public BlockTFCompressed() {
        super(Material.field_151573_f, MapColor.field_151668_h);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)CompressedVariant.IRONWOOD)));
        this.func_149647_a(TFItems.creativeTab);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public int func_176201_c(IBlockState state) {
        return ((CompressedVariant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)CompressedVariant.values()[meta]));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (CompressedVariant variation : CompressedVariant.values()) {
            list.add((Object)new ItemStack((Block)this, 1, variation.ordinal()));
        }
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        switch ((CompressedVariant)((Object)state.func_177229_b(VARIANT))) {
            default: {
                return SoundType.field_185852_e;
            }
            case IRONWOOD: {
                return SoundType.field_185848_a;
            }
            case STEELLEAF: {
                return SoundType.field_185850_c;
            }
            case ARCTIC_FUR: {
                return SoundType.field_185854_g;
            }
            case CARMINITE: 
        }
        return SoundType.field_185859_l;
    }

    public Material func_149688_o(IBlockState state) {
        switch ((CompressedVariant)((Object)state.func_177229_b(VARIANT))) {
            default: {
                return super.func_149688_o(state);
            }
            case IRONWOOD: {
                return Material.field_151575_d;
            }
            case STEELLEAF: {
                return Material.field_151584_j;
            }
            case ARCTIC_FUR: {
                return Material.field_151580_n;
            }
            case CARMINITE: 
        }
        return Material.field_151571_B;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        switch ((CompressedVariant)((Object)blockState.func_177229_b(VARIANT))) {
            default: {
                super.func_176195_g(blockState, worldIn, pos);
            }
            case ARCTIC_FUR: {
                return 0.8f;
            }
            case CARMINITE: 
        }
        return 0.0f;
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return true;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ArrayList variants = new ArrayList(VARIANT.func_177700_c());
        for (int i = 0; i < variants.size(); ++i) {
            if (i == CompressedVariant.FIERY.ordinal()) continue;
            ModelUtils.registerToState(this, i, this.func_176223_P().func_177226_a(VARIANT, (Comparable)variants.get(i)));
        }
        ModelResourceLocation mrl = new ModelResourceLocation(this.getRegistryName(), "inventory_fiery");
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)CompressedVariant.FIERY.ordinal(), (ModelResourceLocation)mrl);
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.func_70045_F() && entityIn instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entityIn)) && worldIn.func_180495_p(pos).func_177229_b(VARIANT) == CompressedVariant.FIERY) {
            entityIn.func_70097_a(DamageSource.field_190095_e, 1.0f);
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        switch ((CompressedVariant)((Object)worldIn.func_180495_p(pos).func_177229_b(VARIANT))) {
            case STEELLEAF: {
                entityIn.func_180430_e(fallDistance, 0.75f);
                break;
            }
            case ARCTIC_FUR: {
                entityIn.func_180430_e(fallDistance, 0.1f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing face) {
        return CompressedVariant.FIERY == world.func_180495_p(pos).func_177229_b(VARIANT);
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (blockState.func_177229_b(VARIANT) == CompressedVariant.FIERY) {
            IBlockState state = blockAccess.func_180495_p(pos.func_177972_a(side));
            return state.func_177230_c() != this || state.func_177229_b(VARIANT) != CompressedVariant.FIERY;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }
}

