/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.client.ModelRegisterCallback;

public abstract class BlockTFGiantBlock
extends Block
implements ModelRegisterCallback {
    private boolean isSelfDestructing;

    public BlockTFGiantBlock(IBlockState state) {
        super(state.func_185904_a());
        this.func_149672_a(state.func_177230_c().func_185467_w());
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        pos = BlockTFGiantBlock.roundCoords(pos);
        for (int dx = 0; dx < 4; ++dx) {
            for (int dy = 0; dy < 4; ++dy) {
                for (int dz = 0; dz < 4; ++dz) {
                    IBlockState state = world.func_180495_p(pos.func_177982_a(dx, dy, dz));
                    if (state.func_177230_c().func_176200_f((IBlockAccess)world, pos)) continue;
                    return false;
                }
            }
        }
        return super.func_176196_c(world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack itemStack) {
        if (!world.field_72995_K) {
            pos = BlockTFGiantBlock.roundCoords(pos);
            for (int dx = 0; dx < 4; ++dx) {
                for (int dy = 0; dy < 4; ++dy) {
                    for (int dz = 0; dz < 4; ++dz) {
                        world.func_180501_a(pos.func_177982_a(dx, dy, dz), this.func_176223_P(), 2);
                    }
                }
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        if (!this.isSelfDestructing && !this.canBlockStay(world, pos)) {
            this.setGiantBlockToAir(world, pos);
        }
    }

    private void setGiantBlockToAir(World world, BlockPos pos) {
        this.isSelfDestructing = true;
        BlockPos bPos = BlockTFGiantBlock.roundCoords(pos);
        for (int dx = 0; dx < 4; ++dx) {
            for (int dy = 0; dy < 4; ++dy) {
                for (int dz = 0; dz < 4; ++dz) {
                    BlockPos iterPos = bPos.func_177982_a(dx, dy, dz);
                    if (pos.equals((Object)iterPos) || world.func_180495_p(iterPos).func_177230_c() != this) continue;
                    world.func_175655_b(iterPos, false);
                }
            }
        }
        this.isSelfDestructing = false;
    }

    private boolean canBlockStay(World world, BlockPos pos) {
        pos = BlockTFGiantBlock.roundCoords(pos);
        for (int dx = 0; dx < 4; ++dx) {
            for (int dy = 0; dy < 4; ++dy) {
                for (int dz = 0; dz < 4; ++dz) {
                    if (world.func_180495_p(pos.func_177982_a(dx, dy, dz)).func_177230_c() == this) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Deprecated
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public static BlockPos roundCoords(BlockPos pos) {
        return new BlockPos(pos.func_177958_n() & 0xFFFFFFFC, pos.func_177956_o() & 0xFFFFFFFC, pos.func_177952_p() & 0xFFFFFFFC);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

