/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.block.TFBlocks;
import twilightforest.block.enums.HedgeVariant;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.client.ModelUtils;
import twilightforest.item.TFItems;

public class BlockTFHedge
extends Block
implements ModelRegisterCallback {
    public static final PropertyEnum<HedgeVariant> VARIANT = PropertyEnum.func_177709_a((String)"variant", HedgeVariant.class);
    private static final AxisAlignedBB HEDGE_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
    private final int damageDone;

    protected BlockTFHedge() {
        super(Material.field_151570_A);
        this.damageDone = 3;
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149647_a(TFItems.creativeTab);
    }

    @Deprecated
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Deprecated
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177229_b(VARIANT) == HedgeVariant.HEDGE) {
            return HEDGE_BB;
        }
        return field_185505_j;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public int func_180651_a(IBlockState state) {
        if (state.func_177229_b(VARIANT) == HedgeVariant.DARKWOOD_LEAVES) {
            return 3;
        }
        return this.func_176201_c(state);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (state.func_177229_b(VARIANT) == HedgeVariant.HEDGE && this.shouldDamage(entity)) {
            entity.func_70097_a(DamageSource.field_76367_g, (float)this.damageDone);
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (world.func_180495_p(pos).func_177229_b(VARIANT) == HedgeVariant.HEDGE && this.shouldDamage(entity)) {
            entity.func_70097_a(DamageSource.field_76367_g, (float)this.damageDone);
        }
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer entityplayer) {
        if (!world.field_72995_K && world.func_180495_p(pos).func_177229_b(VARIANT) == HedgeVariant.HEDGE) {
            world.func_175684_a(pos, (Block)this, 10);
        }
    }

    public void func_180657_a(World world, EntityPlayer entityplayer, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, entityplayer, pos, state, te, stack);
        if (state.func_177229_b(VARIANT) == HedgeVariant.HEDGE) {
            entityplayer.func_70097_a(DamageSource.field_76367_g, (float)this.damageDone);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        double range = 4.0;
        List nearbyPlayers = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_72314_b(range, range, range));
        for (EntityPlayer player : nearbyPlayers) {
            RayTraceResult mop;
            if (!player.field_82175_bq || (mop = this.getPlayerPointVec(world, player, range)) == null || mop.func_178782_a() == null || world.func_180495_p(mop.func_178782_a()).func_177230_c() != this) continue;
            player.func_70097_a(DamageSource.field_76367_g, (float)this.damageDone);
            world.func_175684_a(pos, (Block)this, 10);
        }
    }

    private RayTraceResult getPlayerPointVec(World world, EntityPlayer player, double range) {
        Vec3d position = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d look = player.func_70676_i(1.0f);
        Vec3d dest = position.func_72441_c(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range);
        return world.func_72933_a(position, dest);
    }

    private boolean shouldDamage(Entity entity) {
        return !(entity instanceof EntitySpider) && !(entity instanceof EntityItem) && !entity.func_145773_az();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177229_b(VARIANT) == HedgeVariant.DARKWOOD_LEAVES ? 1 : 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return 0;
    }

    public int func_149745_a(Random par1Random) {
        return par1Random.nextInt(40) == 0 ? 1 : 0;
    }

    public Item func_180660_a(IBlockState state, Random par2Random, int par3) {
        if (state.func_177229_b(VARIANT) == HedgeVariant.DARKWOOD_LEAVES) {
            return Item.func_150898_a((Block)TFBlocks.sapling);
        }
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public void func_180653_a(World par1World, BlockPos pos, IBlockState state, float par6, int fortune) {
        if (!par1World.field_72995_K && state.func_177229_b(VARIANT) == HedgeVariant.DARKWOOD_LEAVES && par1World.field_73012_v.nextInt(40) == 0) {
            this.func_176226_b(par1World, pos, state, fortune);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)HedgeVariant.values()[meta % HedgeVariant.values().length]));
    }

    public int func_176201_c(IBlockState state) {
        return ((HedgeVariant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelUtils.registerToStateSingleVariant(this, VARIANT);
    }
}

