/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.client.ModelUtils;
import twilightforest.entity.EntityTFSlideBlock;
import twilightforest.item.TFItems;

public class BlockTFSlider
extends BlockRotatedPillar
implements ModelRegisterCallback {
    public static final PropertyInteger DELAY = PropertyInteger.func_177719_a((String)"delay", (int)0, (int)3);
    private static final int TICK_TIME = 80;
    private static final int OFFSET_TIME = 20;
    private static final int PLAYER_RANGE = 32;
    private static final float BLOCK_DAMAGE = 5.0f;
    private static final AxisAlignedBB Y_BB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875);
    private static final AxisAlignedBB Z_BB = new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 1.0);
    private static final AxisAlignedBB X_BB = new AxisAlignedBB(0.0, 0.3125, 0.3125, 1.0, 0.6875, 0.6875);

    protected BlockTFSlider() {
        super(Material.field_151573_f);
        this.func_149647_a(TFItems.creativeTab);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176298_M, (Comparable)EnumFacing.Axis.Y).func_177226_a((IProperty)DELAY, (Comparable)Integer.valueOf(0)));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176298_M, DELAY});
    }

    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) | (Integer)state.func_177229_b((IProperty)DELAY);
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)DELAY, (Comparable)Integer.valueOf(meta & 3));
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b((IProperty)field_176298_M)) {
            default: {
                return Y_BB;
            }
            case X: {
                return X_BB;
            }
            case Z: 
        }
        return Z_BB;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random par5Random) {
        if (!world.field_72995_K && this.isConnectedInRange(world, pos)) {
            EntityTFSlideBlock slideBlock = new EntityTFSlideBlock(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, state);
            world.func_72838_d((Entity)slideBlock);
        }
        this.scheduleBlockUpdate(world, pos);
    }

    public boolean isConnectedInRange(World world, BlockPos pos) {
        EnumFacing.Axis axis = (EnumFacing.Axis)world.func_180495_p(pos).func_177229_b((IProperty)field_176298_M);
        switch (axis) {
            case Y: {
                return this.anyPlayerInRange(world, pos) || this.isConnectedInRangeRecursive(world, pos, EnumFacing.UP) || this.isConnectedInRangeRecursive(world, pos, EnumFacing.DOWN);
            }
            case X: {
                return this.anyPlayerInRange(world, pos) || this.isConnectedInRangeRecursive(world, pos, EnumFacing.WEST) || this.isConnectedInRangeRecursive(world, pos, EnumFacing.EAST);
            }
            case Z: {
                return this.anyPlayerInRange(world, pos) || this.isConnectedInRangeRecursive(world, pos, EnumFacing.NORTH) || this.isConnectedInRangeRecursive(world, pos, EnumFacing.SOUTH);
            }
        }
        return this.anyPlayerInRange(world, pos);
    }

    private boolean isConnectedInRangeRecursive(World world, BlockPos pos, EnumFacing dir) {
        BlockPos dPos = pos.func_177972_a(dir);
        if (world.func_180495_p(pos) == world.func_180495_p(dPos)) {
            return this.anyPlayerInRange(world, dPos) || this.isConnectedInRangeRecursive(world, dPos, dir);
        }
        return false;
    }

    private boolean anyPlayerInRange(World world, BlockPos pos) {
        return world.func_184137_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 32.0, false) != null;
    }

    public void scheduleBlockUpdate(World world, BlockPos pos) {
        int offset = (Integer)world.func_180495_p(pos).func_177229_b((IProperty)DELAY);
        int update = 80 - (int)(world.func_72820_D() - (long)(offset * 20)) % 80;
        world.func_175684_a(pos, (Block)this, update);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.scheduleBlockUpdate(world, pos);
    }

    public void func_149666_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        par3List.add((Object)new ItemStack((Block)this, 1, 0));
        par3List.add((Object)new ItemStack((Block)this, 1, 1));
        par3List.add((Object)new ItemStack((Block)this, 1, 2));
        par3List.add((Object)new ItemStack((Block)this, 1, 3));
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        entity.func_70097_a(DamageSource.field_76377_j, 5.0f);
        if (entity instanceof EntityLivingBase) {
            double kx = ((double)pos.func_177958_n() + 0.5 - entity.field_70165_t) * 2.0;
            double kz = ((double)pos.func_177952_p() + 0.5 - entity.field_70161_v) * 2.0;
            ((EntityLivingBase)entity).func_70653_a(null, 2.0f, kx, kz);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{DELAY}).func_178441_a());
        for (int i = 0; i < 4; ++i) {
            ModelUtils.registerToState((Block)this, i, this.func_176223_P());
        }
    }
}

