/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.client.ModelUtils;

public class BlockTFSpiralBrick
extends Block
implements ModelRegisterCallback {
    public static final PropertyEnum<Diagonals> DIAGONAL = PropertyEnum.func_177709_a((String)"diagonal", Diagonals.class);
    public static final PropertyEnum<EnumFacing.Axis> AXIS_FACING = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);

    public BlockTFSpiralBrick() {
        super(Material.field_151576_e, MapColor.field_151665_m);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(DIAGONAL, (Comparable)((Object)Diagonals.TOP_RIGHT)).func_177226_a(AXIS_FACING, (Comparable)EnumFacing.Axis.X));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS_FACING, DIAGONAL});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing.Axis)state.func_177229_b(AXIS_FACING)).ordinal() << 2 | ((Diagonals)((Object)state.func_177229_b(DIAGONAL))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(DIAGONAL, (Comparable)((Object)Diagonals.values()[meta & 3])).func_177226_a(AXIS_FACING, (Comparable)EnumFacing.Axis.values()[(meta & 0xC) >> 2]);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing playerFacing = placer.func_174811_aO();
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(AXIS_FACING, (Comparable)playerFacing.func_176740_k()).func_177226_a(DIAGONAL, (Comparable)((Object)BlockTFSpiralBrick.getDiagonalFromPlacement(facing, playerFacing, playerFacing.func_176740_k() == EnumFacing.Axis.X ? hitZ : hitX, hitY)));
    }

    private static Diagonals getDiagonalFromPlacement(EnumFacing blockFace, EnumFacing playerHorizontalFace, float hitXorZ, float hitY) {
        float correctedHitXorZ;
        float f = correctedHitXorZ = playerHorizontalFace.func_176740_k() == EnumFacing.Axis.X ? hitXorZ : (hitXorZ - 1.0f) * -1.0f;
        if (blockFace.func_176740_k() == EnumFacing.Axis.Y) {
            return BlockTFSpiralBrick.getDiagonalFromDirectionals(correctedHitXorZ < 0.5f, blockFace == EnumFacing.UP);
        }
        return BlockTFSpiralBrick.getDiagonalFromDirectionals(correctedHitXorZ < 0.5f, hitY < 0.5f);
    }

    private static Diagonals getDiagonalFromDirectionals(boolean isRight, boolean isBottom) {
        if (isRight) {
            return isBottom ? Diagonals.BOTTOM_RIGHT : Diagonals.TOP_RIGHT;
        }
        return isBottom ? Diagonals.BOTTOM_LEFT : Diagonals.TOP_LEFT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178440_a(AXIS_FACING).func_178439_a("_spiral_bricks").func_178441_a());
        ModelUtils.registerToState(this, 0, this.func_176223_P().func_177226_a(DIAGONAL, (Comparable)((Object)Diagonals.BOTTOM_LEFT)));
    }

    private static enum Diagonals implements IStringSerializable
    {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        BOTTOM_LEFT,
        TOP_LEFT;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

