/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.vecmath.Matrix4f;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.tuple.Pair;
import twilightforest.TFConfig;
import twilightforest.block.enums.BossVariant;
import twilightforest.client.TFClientEvents;
import twilightforest.client.model.ModelTFHydraHead;
import twilightforest.client.model.ModelTFKnightPhantom2;
import twilightforest.client.model.ModelTFLich;
import twilightforest.client.model.ModelTFMinoshroom;
import twilightforest.client.model.ModelTFNaga;
import twilightforest.client.model.ModelTFPhantomArmor;
import twilightforest.client.model.ModelTFQuestRam;
import twilightforest.client.model.ModelTFSnowQueen;
import twilightforest.client.model.ModelTFTowerBoss;
import twilightforest.tileentity.TileEntityTFTrophy;

public class TileEntityTFTrophyRenderer
extends TileEntitySpecialRenderer<TileEntityTFTrophy> {
    private ModelTFHydraHead hydraHeadModel;
    private static final ResourceLocation textureLocHydra = new ResourceLocation("twilightforest:textures/model/hydra4.png");
    private ModelTFNaga nagaHeadModel;
    private static final ResourceLocation textureLocNaga = new ResourceLocation("twilightforest:textures/model/nagahead.png");
    private ModelTFLich lichModel;
    private static final ResourceLocation textureLocLich = new ResourceLocation("twilightforest:textures/model/twilightlich64.png");
    private ModelTFTowerBoss urGhastModel;
    private static final ResourceLocation textureLocUrGhast = new ResourceLocation("twilightforest:textures/model/towerboss.png");
    private ModelTFSnowQueen snowQueenModel;
    private static final ResourceLocation textureLocSnowQueen = new ResourceLocation("twilightforest:textures/model/snowqueen.png");
    private ModelTFMinoshroom minoshroomModel;
    private static final ResourceLocation textureLocMinoshroom = new ResourceLocation("twilightforest:textures/model/minoshroomtaur.png");
    private ModelTFKnightPhantom2 knightPhantomModel;
    private static final ResourceLocation textureLocKnightPhantom = new ResourceLocation("twilightforest:textures/model/phantomskeleton.png");
    private ModelTFPhantomArmor knightPhantomArmorModel;
    private static final ResourceLocation textureLocKnightPhantomArmor = new ResourceLocation("twilightforest:textures/armor/phantom_1.png");
    private ModelTFQuestRam questRamModel;
    private static final ResourceLocation textureLocQuestRam = new ResourceLocation("twilightforest:textures/model/questram.png");
    private static final ResourceLocation textureLocQuestRamLines = new ResourceLocation("twilightforest:textures/model/questram_lines.png");
    public final BakedModel baked = new BakedModel();
    private ItemStack stack;
    private ItemCameraTransforms.TransformType transform;
    private IBakedModel model;
    private final IBakedModel[] trophyModels = new IBakedModel[BossVariant.TrophyType.values().length];

    public TileEntityTFTrophyRenderer() {
        this.hydraHeadModel = new ModelTFHydraHead();
        this.nagaHeadModel = new ModelTFNaga();
        this.lichModel = new ModelTFLich();
        this.urGhastModel = new ModelTFTowerBoss();
        this.snowQueenModel = new ModelTFSnowQueen();
        this.minoshroomModel = new ModelTFMinoshroom();
        this.knightPhantomModel = new ModelTFKnightPhantom2();
        this.knightPhantomArmorModel = new ModelTFPhantomArmor(EntityEquipmentSlot.HEAD, 0.5f);
        this.questRamModel = new ModelTFQuestRam();
    }

    public void render(@Nullable TileEntityTFTrophy trophy, double x, double y, double z, float partialTime, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        if (trophy == null) {
            if (this.transform == ItemCameraTransforms.TransformType.GUI) {
                BossVariant variant = BossVariant.values()[this.stack.func_77960_j() % BossVariant.values().length];
                BossVariant.TrophyType trophyType = variant.getTrophyType();
                int trophyVariant = trophyType.ordinal();
                this.model = this.trophyModels[trophyVariant] != null ? this.trophyModels[trophyVariant] : Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("twilightforest:" + trophyType.getModelName(), "inventory"));
                GlStateManager.func_179140_f();
                GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)-1.5f);
                IBakedModel bakedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)this.model, (ItemCameraTransforms.TransformType)this.transform, (this.transform == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND ? 1 : 0) != 0);
                Minecraft.func_71410_x().func_175599_af().func_180454_a(this.stack, bakedModel);
                GlStateManager.func_179145_e();
                GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)1.5f);
                GlStateManager.func_179114_b((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (this.transform == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || this.transform == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179114_b((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.40625f, (float)1.171875f, (float)0.0f);
            }
            if (this.transform == ItemCameraTransforms.TransformType.GROUND) {
                GlStateManager.func_179109_b((float)0.25f, (float)0.3f, (float)0.25f);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            }
            if (this.transform == ItemCameraTransforms.TransformType.HEAD) {
                if (BossVariant.values()[this.stack.func_77960_j() % BossVariant.values().length] == BossVariant.QUEST_RAM) {
                    GlStateManager.func_179152_a((float)3.0f, (float)3.0f, (float)3.0f);
                    GlStateManager.func_179109_b((float)-0.33f, (float)-0.13f, (float)-0.33f);
                } else {
                    GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                    GlStateManager.func_179109_b((float)-0.25f, (float)0.0f, (float)-0.25f);
                }
            }
        }
        float rotation = trophy != null ? (float)(trophy.func_145906_b() * 360) / 16.0f : 0.0f;
        boolean onGround = true;
        if (trophy != null && trophy.func_145832_p() != 1) {
            switch (trophy.func_145832_p() & 7) {
                case 2: {
                    onGround = false;
                    break;
                }
                case 3: {
                    onGround = false;
                    rotation = 180.0f;
                    break;
                }
                case 4: {
                    onGround = false;
                    rotation = 270.0f;
                    break;
                }
                default: {
                    onGround = false;
                    rotation = 90.0f;
                    break;
                }
            }
        } else if (trophy == null && this.transform == ItemCameraTransforms.TransformType.GUI) {
            rotation = TFConfig.rotateTrophyHeadsGui ? TFClientEvents.rotationTicker : 135.0f;
        }
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        switch (trophy != null ? BossVariant.values()[trophy.func_145904_a()] : BossVariant.values()[this.stack.func_77960_j() % BossVariant.values().length]) {
            case HYDRA: {
                if (trophy == null) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)(this.transform == ItemCameraTransforms.TransformType.HEAD ? -0.125f : 0.0f));
                }
                this.renderHydraHead(rotation, onGround && trophy != null);
                break;
            }
            case NAGA: {
                this.renderNagaHead(rotation, onGround);
                break;
            }
            case LICH: {
                this.renderLichHead(rotation, onGround);
                break;
            }
            case UR_GHAST: {
                if (trophy == null) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)0.0f);
                }
                this.renderUrGhastHead(trophy, rotation, onGround, partialTime);
                break;
            }
            case SNOW_QUEEN: {
                this.renderSnowQueenHead(rotation, onGround);
                break;
            }
            case MINOSHROOM: {
                this.renderMinoshroomHead(rotation, onGround);
                break;
            }
            case KNIGHT_PHANTOM: {
                this.renderKnightPhantomHead(rotation, onGround);
                break;
            }
            case QUEST_RAM: {
                this.renderQuestRamHead(rotation, onGround);
                break;
            }
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    private void renderHydraHead(float rotation, boolean onGround) {
        GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
        this.func_147499_a(textureLocHydra);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.0f : -0.0f), (float)1.5f);
        this.hydraHeadModel.openMouthForTrophy(onGround ? 0.0f : 0.25f);
        this.hydraHeadModel.func_78088_a(null, 0.0f, 0.0f, 0.0f, rotation, 0.0f, 0.0625f);
    }

    private void renderNagaHead(float rotation, boolean onGround) {
        GlStateManager.func_179109_b((float)0.0f, (float)-0.125f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
        this.func_147499_a(textureLocNaga);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.0f : -0.0f), (float)(onGround ? 0.0f : 1.0f));
        this.nagaHeadModel.func_78088_a(null, 0.0f, 0.0f, 0.0f, rotation, 0.0f, 0.0625f);
    }

    private void renderLichHead(float rotation, boolean onGround) {
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(textureLocLich);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.75f : 1.5f), (float)(onGround ? 0.0f : 0.24f));
        this.lichModel.field_78116_c.func_78785_a(0.0625f);
        this.lichModel.field_178720_f.func_78785_a(0.0625f);
    }

    private void renderUrGhastHead(TileEntityTFTrophy trophy, float rotation, boolean onGround, float partialTime) {
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        this.func_147499_a(textureLocUrGhast);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.0f : 1.0f), (float)(onGround ? 0.0f : 0.0f));
        this.urGhastModel.func_78088_a(null, 0.0f, 0.0f, trophy != null ? (float)trophy.ticksExisted + partialTime : TFClientEvents.sineTicker + partialTime, 0.0f, 0.0f, 0.0625f);
    }

    private void renderSnowQueenHead(float rotation, boolean onGround) {
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(textureLocSnowQueen);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.5f : 1.25f), (float)(onGround ? 0.0f : 0.24f));
        this.snowQueenModel.field_78116_c.func_78785_a(0.0625f);
        this.snowQueenModel.field_178720_f.func_78785_a(0.0625f);
    }

    private void renderMinoshroomHead(float rotation, boolean onGround) {
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(textureLocMinoshroom);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.875f : 1.625f), (float)(onGround ? 0.5625f : 0.8125f));
        this.minoshroomModel.field_78116_c.func_78785_a(0.0625f);
    }

    private void renderKnightPhantomHead(float rotation, boolean onGround) {
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.5f : 1.25f), (float)(onGround ? 0.0f : 0.25f));
        GlStateManager.func_179152_a((float)0.9375f, (float)0.9375f, (float)0.9375f);
        this.func_147499_a(textureLocKnightPhantomArmor);
        this.knightPhantomArmorModel.field_78116_c.func_78785_a(0.0625f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        this.func_147499_a(textureLocKnightPhantom);
        this.knightPhantomModel.field_78116_c.func_78785_a(0.0625f);
    }

    private void renderQuestRamHead(float rotation, boolean onGround) {
        if (this.transform == ItemCameraTransforms.TransformType.GUI) {
            GlStateManager.func_179152_a((float)0.55f, (float)0.55f, (float)0.55f);
        } else if (this.stack == null) {
            GlStateManager.func_179152_a((float)0.65f, (float)0.65f, (float)0.65f);
        } else {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        }
        if (this.transform == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || this.transform == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
        }
        this.func_147499_a(textureLocQuestRam);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.3f : 1.03f), (float)(onGround ? 0.765625f : 1.085f));
        this.questRamModel.head.func_78785_a(0.0625f);
        GlStateManager.func_179140_f();
        this.func_147499_a(textureLocQuestRamLines);
        float var4 = 1.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179152_a((float)1.025f, (float)1.025f, (float)1.025f);
        int var5 = 61680;
        int var6 = var5 % 65536;
        int var7 = var5 / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)var6 / 1.0f), (float)((float)var7 / 1.0f));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)var4);
        this.questRamModel.head.func_78785_a(0.0625f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179141_d();
        GlStateManager.func_179145_e();
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    public class BakedModel
    implements IBakedModel {
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return Collections.EMPTY_LIST;
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_188618_c() {
            return true;
        }

        public TextureAtlasSprite func_177554_e() {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/soul_sand");
        }

        public ItemOverrideList func_188617_f() {
            return new Overrides();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            TileEntityTFTrophyRenderer.this.transform = cameraTransformType;
            return Pair.of((Object)this, null);
        }

        private class Overrides
        extends ItemOverrideList {
            public Overrides() {
                super(Collections.EMPTY_LIST);
            }

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                TileEntityTFTrophyRenderer.this.stack = stack;
                return BakedModel.this;
            }
        }
    }

    public static class DummyTile
    extends TileEntityTFTrophy {
    }
}

