/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import twilightforest.TFSounds;
import twilightforest.entity.EntityTFGoblinChain;
import twilightforest.entity.EntityTFSpikeBlock;

public class EntityTFBlockGoblin
extends EntityMob
implements IEntityMultiPart {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("twilightforest", "entities/block_goblin");
    private static final float CHAIN_SPEED = 16.0f;
    private static final DataParameter<Byte> DATA_CHAINLENGTH = EntityDataManager.func_187226_a(EntityTFBlockGoblin.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> DATA_CHAINPOS = EntityDataManager.func_187226_a(EntityTFBlockGoblin.class, (DataSerializer)DataSerializers.field_187191_a);
    private int recoilCounter;
    private float chainAngle;
    public final EntityTFSpikeBlock block = new EntityTFSpikeBlock(this);
    public final EntityTFGoblinChain chain1 = new EntityTFGoblinChain(this);
    public final EntityTFGoblinChain chain2 = new EntityTFGoblinChain(this);
    public final EntityTFGoblinChain chain3 = new EntityTFGoblinChain(this);
    private final Entity[] partsArray = new Entity[]{this.block, this.chain1, this.chain2, this.chain3};

    public EntityTFBlockGoblin(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.4f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityTNTPrimed.class, 2.0f, (double)0.8f, 1.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_CHAINLENGTH, (Object)0);
        this.field_70180_af.func_187214_a(DATA_CHAINPOS, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(11.0);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.78f;
    }

    protected SoundEvent func_184639_G() {
        return TFSounds.REDCAP_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return TFSounds.REDCAP_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TFSounds.REDCAP_AMBIENT;
    }

    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public double getChainYOffset() {
        return 1.5 - (double)this.getChainLength() / 4.0;
    }

    public Vec3d getChainPosition() {
        return this.getChainPosition(this.getChainAngle(), this.getChainLength());
    }

    public Vec3d getChainPosition(float angle, float distance) {
        double var1 = Math.cos((double)angle * Math.PI / 180.0) * (double)distance;
        double var3 = Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
        return new Vec3d(this.field_70165_t + var1, this.field_70163_u + this.getChainYOffset(), this.field_70161_v + var3);
    }

    public boolean isSwingingChain() {
        return this.field_82175_bq || this.func_70638_az() != null && this.recoilCounter == 0;
    }

    public boolean func_70652_k(Entity par1Entity) {
        this.func_184609_a(EnumHand.MAIN_HAND);
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.block.func_70071_h_();
        this.chain1.func_70071_h_();
        this.chain2.func_70071_h_();
        this.chain3.func_70071_h_();
        if (this.recoilCounter > 0) {
            --this.recoilCounter;
        }
        this.chainAngle += 16.0f;
        this.chainAngle %= 360.0f;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(DATA_CHAINLENGTH, (Object)((byte)Math.floor(this.getChainLength() * 127.0f)));
            this.field_70180_af.func_187227_b(DATA_CHAINPOS, (Object)((byte)Math.floor(this.getChainAngle() / 360.0f * 255.0f)));
        } else if (Math.abs(this.chainAngle - this.getChainAngle()) > 32.0f) {
            this.chainAngle = this.getChainAngle();
        }
        Vec3d blockPos = this.getChainPosition();
        this.block.func_70107_b(blockPos.field_72450_a, blockPos.field_72448_b, blockPos.field_72449_c);
        this.block.field_70177_z = this.getChainAngle();
        double sx = this.field_70165_t;
        double sy = this.field_70163_u + (double)this.field_70131_O - 0.1;
        double sz = this.field_70161_v;
        double ox = sx - blockPos.field_72450_a;
        double oy = sy - blockPos.field_72448_b - (double)this.block.field_70131_O / 3.0;
        double oz = sz - blockPos.field_72449_c;
        this.chain1.func_70107_b(sx - ox * 0.4, sy - oy * 0.4, sz - oz * 0.4);
        this.chain2.func_70107_b(sx - ox * 0.5, sy - oy * 0.5, sz - oz * 0.5);
        this.chain3.func_70107_b(sx - ox * 0.6, sy - oy * 0.6, sz - oz * 0.6);
        if (!this.field_70170_p.field_72995_K && this.isSwingingChain()) {
            this.applyBlockCollisions(this.block);
        }
    }

    protected void applyBlockCollisions(Entity collider) {
        List list = this.field_70170_p.func_72839_b(collider, collider.func_174813_aQ().func_72314_b((double)0.2f, 0.0, (double)0.2f));
        for (Entity entity : list) {
            if (!entity.func_70104_M()) continue;
            this.applyBlockCollision(collider, entity);
        }
    }

    protected void applyBlockCollision(Entity collider, Entity collided) {
        if (collided != this) {
            collided.func_70108_f(collider);
            if (collided instanceof EntityLivingBase && super.func_70652_k(collided)) {
                collided.field_70181_x += 0.4;
                this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
                this.recoilCounter = 40;
            }
        }
    }

    private float getChainAngle() {
        if (!this.field_70170_p.field_72995_K) {
            return this.chainAngle;
        }
        return (float)((Byte)this.field_70180_af.func_187225_a(DATA_CHAINPOS) & 0xFF) / 255.0f * 360.0f;
    }

    private float getChainLength() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.isSwingingChain()) {
                return 0.9f;
            }
            return 0.3f;
        }
        return (float)((Byte)this.field_70180_af.func_187225_a(DATA_CHAINLENGTH) & 0xFF) / 127.0f;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(MultiPartEntityPart MultiPartEntityPart2, DamageSource damagesource, float i) {
        return false;
    }

    public Entity[] func_70021_al() {
        return this.partsArray;
    }
}

