/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import twilightforest.TFFeature;
import twilightforest.entity.ai.EntityAITFFindEntityNearestPlayer;
import twilightforest.entity.boss.EntityTFUrGhast;

public class EntityTFTowerGhast
extends EntityGhast {
    private static final DataParameter<Byte> ATTACK_STATUS = EntityDataManager.func_187226_a(EntityTFTowerGhast.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> ATTACK_TIMER = EntityDataManager.func_187226_a(EntityTFTowerGhast.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> ATTACK_PREVTIMER = EntityDataManager.func_187226_a(EntityTFTowerGhast.class, (DataSerializer)DataSerializers.field_187191_a);
    private AIAttack attackAI;
    protected float wanderFactor;
    private int inTrapCounter;
    private BlockPos homePosition = BlockPos.field_177992_a;
    private float maximumHomeDistance = -1.0f;

    public EntityTFTowerGhast(World par1World) {
        super(par1World);
        this.func_70105_a(4.0f, 6.0f);
        this.wanderFactor = 16.0f;
        this.inTrapCounter = 0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_STATUS, (Object)0);
        this.field_70180_af.func_187214_a(ATTACK_TIMER, (Object)0);
        this.field_70180_af.func_187214_a(ATTACK_PREVTIMER, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIHomedFly(this));
        if (!(this instanceof EntityTFUrGhast)) {
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
        }
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityGhast.AILookAround((EntityGhast)this));
        this.attackAI = new AIAttack(this);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.attackAI);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITFFindEntityNearestPlayer((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    public int func_70627_aG() {
        return 160;
    }

    public int func_70641_bl() {
        return 8;
    }

    public void func_70636_d() {
        if (this.func_70013_c() > 0.5f) {
            this.field_70708_bq += 2;
        }
        if (this.field_70146_Z.nextBoolean()) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        this.findHome();
        if (this.inTrapCounter > 0) {
            --this.inTrapCounter;
            this.func_70624_b(null);
        }
        boolean status = this.func_70638_az() != null && this.shouldAttack(this.func_70638_az());
        this.field_70180_af.func_187227_b(ATTACK_STATUS, (Object)((byte)(status ? 1 : 0)));
        this.field_70180_af.func_187227_b(ATTACK_TIMER, (Object)((byte)this.attackAI.attackTimer));
        this.field_70180_af.func_187227_b(ATTACK_PREVTIMER, (Object)((byte)this.attackAI.prevAttackTimer));
    }

    public int getAttackStatus() {
        return ((Byte)this.field_70180_af.func_187225_a(ATTACK_STATUS)).byteValue();
    }

    public int getAttackTimer() {
        return ((Byte)this.field_70180_af.func_187225_a(ATTACK_TIMER)).byteValue();
    }

    public int getPrevAttackTimer() {
        return ((Byte)this.field_70180_af.func_187225_a(ATTACK_PREVTIMER)).byteValue();
    }

    protected boolean shouldAttack(EntityLivingBase living) {
        return true;
    }

    public int func_70646_bf() {
        return 500;
    }

    protected void spitFireball() {
        Vec3d vec3d = this.func_70676_i(1.0f);
        double d2 = this.func_70638_az().field_70165_t - (this.field_70165_t + vec3d.field_72450_a * 4.0);
        double d3 = this.func_70638_az().func_174813_aQ().field_72338_b + (double)(this.func_70638_az().field_70131_O / 2.0f) - (0.5 + this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double d4 = this.func_70638_az().field_70161_v - (this.field_70161_v + vec3d.field_72449_c * 4.0);
        EntityLargeFireball entitylargefireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, d2, d3, d4);
        entitylargefireball.field_92057_e = this.func_175453_cd();
        entitylargefireball.field_70165_t = this.field_70165_t + vec3d.field_72450_a * 4.0;
        entitylargefireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
        entitylargefireball.field_70161_v = this.field_70161_v + vec3d.field_72449_c * 4.0;
        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
        if (this.field_70146_Z.nextInt(6) == 0) {
            this.func_70624_b(null);
        }
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ()) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevel();
    }

    protected boolean isValidLightLevel() {
        return true;
    }

    private void findHome() {
        if (!this.hasHome()) {
            int chunkZ;
            int chunkX = MathHelper.func_76128_c((double)this.field_70165_t) >> 4;
            TFFeature nearFeature = TFFeature.getFeatureForRegion(chunkX, chunkZ = MathHelper.func_76128_c((double)this.field_70161_v) >> 4, this.field_70170_p);
            if (nearFeature != TFFeature.darkTower) {
                this.detachHome();
                this.field_70708_bq += 5;
            } else {
                BlockPos cc = TFFeature.getNearestCenterXYZ(chunkX, chunkZ, this.field_70170_p);
                this.setHomePosAndDistance(cc.func_177981_b(128), 64);
            }
        }
    }

    public void setInTrap() {
        this.inTrapCounter = 10;
    }

    public boolean isWithinHomeDistanceCurrentPosition() {
        return this.isWithinHomeDistanceFromPosition(new BlockPos((Entity)this));
    }

    public boolean isWithinHomeDistanceFromPosition(BlockPos pos) {
        return this.maximumHomeDistance == -1.0f ? true : pos.func_177956_o() > 64 && pos.func_177956_o() < 210 && this.homePosition.func_177951_i((Vec3i)pos) < (double)(this.maximumHomeDistance * this.maximumHomeDistance);
    }

    public void setHomePosAndDistance(BlockPos pos, int distance) {
        this.homePosition = pos;
        this.maximumHomeDistance = distance;
    }

    public BlockPos getHomePosition() {
        return this.homePosition;
    }

    public float getMaximumHomeDistance() {
        return this.maximumHomeDistance;
    }

    public void detachHome() {
        this.maximumHomeDistance = -1.0f;
    }

    public boolean hasHome() {
        return this.maximumHomeDistance != -1.0f;
    }

    public static class AIAttack
    extends EntityAIBase {
        private final EntityTFTowerGhast parentEntity;
        public int attackTimer;
        public int prevAttackTimer;

        public AIAttack(EntityTFTowerGhast ghast) {
            this.parentEntity = ghast;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null && this.parentEntity.shouldAttack(this.parentEntity.func_70638_az());
        }

        public void func_75249_e() {
            this.prevAttackTimer = 0;
            this.attackTimer = 0;
        }

        public void func_75251_c() {
            this.parentEntity.func_175454_a(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0 && this.parentEntity.func_70635_at().func_75522_a((Entity)entitylivingbase)) {
                World world = this.parentEntity.field_70170_p;
                this.prevAttackTimer = this.attackTimer++;
                this.parentEntity.func_70671_ap().func_75651_a((Entity)entitylivingbase, 10.0f, (float)this.parentEntity.func_70646_bf());
                if (this.attackTimer == 10) {
                    this.parentEntity.func_184185_a(SoundEvents.field_187559_bL, 10.0f, this.parentEntity.func_70647_i());
                }
                if (this.attackTimer == 20) {
                    if (this.parentEntity.shouldAttack(entitylivingbase)) {
                        this.parentEntity.func_184185_a(SoundEvents.field_187557_bK, 10.0f, this.parentEntity.func_70647_i());
                        this.parentEntity.spitFireball();
                        this.prevAttackTimer = this.attackTimer;
                    }
                    this.attackTimer = -40;
                }
            } else if (this.attackTimer > 0) {
                this.prevAttackTimer = this.attackTimer--;
            }
            this.parentEntity.func_175454_a(this.attackTimer > 10);
        }
    }

    public static class AIHomedFly
    extends EntityAIBase {
        private final EntityTFTowerGhast parentEntity;

        AIHomedFly(EntityTFTowerGhast ghast) {
            this.parentEntity = ghast;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return !this.parentEntity.isWithinHomeDistanceCurrentPosition();
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return (d3 < 1.0 || d3 > 3600.0) && !this.parentEntity.isWithinHomeDistanceCurrentPosition();
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * this.parentEntity.wanderFactor);
            double d1 = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * this.parentEntity.wanderFactor);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * this.parentEntity.wanderFactor);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
            if (this.parentEntity.func_174818_b(this.parentEntity.getHomePosition()) > 256.0) {
                Vec3d vecToHome = new Vec3d((Vec3i)this.parentEntity.getHomePosition()).func_178788_d(this.parentEntity.func_174791_d()).func_72432_b();
                double targetX = this.parentEntity.field_70165_t + vecToHome.field_72450_a * (double)this.parentEntity.wanderFactor + (double)((this.parentEntity.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.parentEntity.wanderFactor);
                double targetY = this.parentEntity.field_70163_u + vecToHome.field_72448_b * (double)this.parentEntity.wanderFactor + (double)((this.parentEntity.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.parentEntity.wanderFactor);
                double targetZ = this.parentEntity.field_70161_v + vecToHome.field_72449_c * (double)this.parentEntity.wanderFactor + (double)((this.parentEntity.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.parentEntity.wanderFactor);
                this.parentEntity.func_70605_aq().func_75642_a(targetX, targetY, targetZ, 1.0);
            } else {
                this.parentEntity.func_70605_aq().func_75642_a((double)this.parentEntity.getHomePosition().func_177958_n() + 0.5, (double)this.parentEntity.getHomePosition().func_177956_o(), (double)this.parentEntity.getHomePosition().func_177952_p() + 0.5, 1.0);
            }
        }
    }

    public static class AIRandomFly
    extends EntityAIBase {
        private final EntityTFTowerGhast parentEntity;

        public AIRandomFly(EntityTFTowerGhast ghast) {
            this.parentEntity = ghast;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return this.parentEntity.func_70638_az() == null;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u;
            double d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v;
            double d3 = d0 * d0 + d1 * d1 + d2 * d2;
            return this.parentEntity.func_70638_az() == null && (d3 < 1.0 || d3 > 3600.0);
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * this.parentEntity.wanderFactor);
            double d1 = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * this.parentEntity.wanderFactor);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * this.parentEntity.wanderFactor);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }
}

