/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import twilightforest.TwilightForestMod;
import twilightforest.entity.boss.EntityTFHydra;
import twilightforest.entity.boss.EntityTFHydraHead;
import twilightforest.entity.boss.EntityTFHydraPart;
import twilightforest.entity.boss.HydraHeadContainer;

public class EntityTFHydraMortar
extends EntityThrowable {
    private static final int BURN_FACTOR = 5;
    private static final int DIRECT_DAMAGE = 18;
    public int fuse = 80;
    private boolean megaBlast = false;

    public EntityTFHydraMortar(World par1World) {
        super(par1World);
        this.func_70105_a(0.75f, 0.75f);
    }

    public EntityTFHydraMortar(World par1World, EntityTFHydraHead head) {
        super(par1World, (EntityLivingBase)head);
        this.func_70105_a(0.75f, 0.75f);
        Vec3d vector = head.func_70040_Z();
        double dist = 3.5;
        double px = head.field_70165_t + vector.field_72450_a * dist;
        double py = head.field_70163_u + 1.0 + vector.field_72448_b * dist;
        double pz = head.field_70161_v + vector.field_72449_c * dist;
        this.func_70012_b(px, py, pz, 0.0f, 0.0f);
        head.field_70159_w = 0.0;
        head.field_70181_x = 0.0;
        head.field_70179_y = 0.0;
        this.func_184538_a((Entity)head, head.field_70125_A, head.field_70177_z, -20.0f, 0.5f, 1.0f);
        TwilightForestMod.LOGGER.info("Launching mortar! Current head motion is {}, {}", (Object)head.field_70159_w, (Object)head.field_70179_y);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
        if (this.field_70122_E) {
            this.field_70159_w *= 0.9;
            this.field_70181_x *= 0.9;
            this.field_70179_y *= 0.9;
            if (!this.field_70170_p.field_72995_K && this.fuse-- <= 0) {
                this.detonate();
            }
        }
    }

    public void setToBlasting() {
        this.megaBlast = true;
    }

    protected void func_70184_a(RayTraceResult mop) {
        if (mop.field_72308_g == null && !this.megaBlast) {
            this.field_70181_x = 0.0;
            this.field_70122_E = true;
        } else if (!this.field_70170_p.field_72995_K && mop.field_72308_g != this.field_70192_c && !this.isPartOfHydra(mop.field_72308_g)) {
            this.detonate();
        }
    }

    private boolean isPartOfHydra(Entity entity) {
        if (this.field_70192_c instanceof EntityTFHydraPart) {
            EntityTFHydra hydra = ((EntityTFHydraPart)this.field_70192_c).hydraObj;
            if (hydra == null || hydra.func_70021_al() == null) {
                return false;
            }
            if (entity == hydra) {
                return true;
            }
            for (Entity entity2 : hydra.func_70021_al()) {
                if (entity != entity2) continue;
                return true;
            }
            for (HydraHeadContainer hydraHeadContainer : hydra.hc) {
                if (entity != hydraHeadContainer.headEntity) continue;
                return true;
            }
        }
        return false;
    }

    public float func_180428_a(Explosion par1Explosion, World par2World, BlockPos pos, IBlockState state) {
        float var6 = super.func_180428_a(par1Explosion, par2World, pos, state);
        if (this.megaBlast && state.func_177230_c() != Blocks.field_150357_h && state.func_177230_c() != Blocks.field_150384_bq && state.func_177230_c() != Blocks.field_150378_br) {
            var6 = Math.min(0.8f, var6);
        }
        return var6;
    }

    private void detonate() {
        float explosionPower = this.megaBlast ? 4.0f : 0.1f;
        boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
        this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, explosionPower, flag, flag);
        DamageSource src = new EntityDamageSourceIndirect("onFire", (Entity)this, (Entity)this.func_85052_h()).func_76361_j().func_76349_b();
        for (Entity nearby : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0))) {
            if (!nearby.func_70097_a(src, 18.0f) || nearby.func_70045_F()) continue;
            nearby.func_70015_d(5);
        }
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        super.func_70097_a(damagesource, i);
        if (damagesource.func_76346_g() != null && !this.field_70170_p.field_72995_K) {
            Vec3d vec3d = damagesource.func_76346_g().func_70040_Z();
            if (vec3d != null) {
                this.func_70186_c(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.5f, 0.1f);
                this.field_70122_E = false;
                this.fuse += 20;
            }
            if (damagesource.func_76346_g() instanceof EntityLivingBase) {
                this.field_70192_c = (EntityLivingBase)damagesource.func_76346_g();
            }
            return true;
        }
        return false;
    }

    public boolean func_70027_ad() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.5f;
    }

    protected float func_70185_h() {
        return 0.05f;
    }
}

