/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.entity.EntityTFChainBlock;
import twilightforest.item.TFItems;

public class ItemTFChainBlock
extends ItemTool
implements ModelRegisterCallback {
    private static final String THROWN_UUID_KEY = "chainEntity";

    protected ItemTFChainBlock() {
        super(6.0f, 1.6f, TFItems.TOOL_KNIGHTLY, (Set)Sets.newHashSet((Object[])new Block[]{Blocks.field_150348_b}));
        this.field_77777_bU = 1;
        this.func_77656_e(99);
        this.func_77637_a(TFItems.creativeTab);
    }

    public void func_77663_a(ItemStack stack, World world, Entity holder, int slot, boolean isSelected) {
        if (!world.field_72995_K && ItemTFChainBlock.getThrownUuid(stack) != null && ItemTFChainBlock.getThrownEntity(world, stack) == null) {
            stack.func_77978_p().func_82580_o("chainEntityMost");
            stack.func_77978_p().func_82580_o("chainEntityLeast");
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemTFChainBlock.getThrownUuid(stack) != null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        player.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
        if (!world.field_72995_K) {
            EntityTFChainBlock launchedBlock = new EntityTFChainBlock(world, (EntityLivingBase)player);
            world.func_72838_d((Entity)launchedBlock);
            ItemTFChainBlock.setThrownEntity(stack, launchedBlock);
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        player.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Nullable
    private static UUID getThrownUuid(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_186855_b(THROWN_UUID_KEY)) {
            return stack.func_77978_p().func_186857_a(THROWN_UUID_KEY);
        }
        return null;
    }

    @Nullable
    private static EntityTFChainBlock getThrownEntity(World world, ItemStack stack) {
        Entity e;
        UUID id;
        if (world instanceof WorldServer && (id = ItemTFChainBlock.getThrownUuid(stack)) != null && (e = ((WorldServer)world).func_175733_a(id)) instanceof EntityTFChainBlock) {
            return (EntityTFChainBlock)e;
        }
        return null;
    }

    private static void setThrownEntity(ItemStack stack, EntityTFChainBlock cube) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_186854_a(THROWN_UUID_KEY, cube.func_110124_au());
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BLOCK;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState state) {
        if ("pickaxe".equals(toolClass)) {
            return 2;
        }
        return -1;
    }
}

