/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.block.BlockTFMazestone;
import twilightforest.block.TFBlocks;
import twilightforest.block.enums.MazestoneVariant;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;
import twilightforest.util.WorldUtil;

public class ItemTFCrumbleHorn
extends ItemTF {
    private static final int CHANCE_HARVEST = 20;
    private static final int CHANCE_CRUMBLE = 5;

    protected ItemTFCrumbleHorn() {
        this.func_77637_a(TFItems.creativeTab);
        this.field_77777_bU = 1;
        this.func_77656_e(1024);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        player.func_184185_a(SoundEvents.field_187757_eG, 1.0f, 0.8f);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        if (count > 10 && count % 5 == 0 && !living.field_70170_p.field_72995_K) {
            int crumbled = this.doCrumble(living.field_70170_p, living);
            if (crumbled > 0) {
                stack.func_77972_a(crumbled, living);
            }
            living.field_70170_p.func_184148_a(null, living.field_70165_t, living.field_70163_u, living.field_70161_v, SoundEvents.field_187757_eG, living.func_184176_by(), 1.0f, 0.8f);
        }
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    private int doCrumble(World world, EntityLivingBase living) {
        double range = 3.0;
        double radius = 2.0;
        Vec3d srcVec = new Vec3d(living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v);
        Vec3d lookVec = living.func_70040_Z().func_186678_a(range);
        Vec3d destVec = srcVec.func_178787_e(lookVec);
        AxisAlignedBB crumbleBox = new AxisAlignedBB(destVec.field_72450_a - radius, destVec.field_72448_b - radius, destVec.field_72449_c - radius, destVec.field_72450_a + radius, destVec.field_72448_b + radius, destVec.field_72449_c + radius);
        return this.crumbleBlocksInAABB(world, living, crumbleBox);
    }

    private int crumbleBlocksInAABB(World world, EntityLivingBase living, AxisAlignedBB box) {
        int crumbled = 0;
        for (BlockPos pos : WorldUtil.getAllInBB(box)) {
            crumbled += this.crumbleBlock(world, living, pos);
        }
        return crumbled;
    }

    private int crumbleBlock(World world, EntityLivingBase living, BlockPos pos) {
        int cost = 0;
        IBlockState state = world.func_180495_p(pos);
        Block currentID = state.func_177230_c();
        if (!currentID.isAir(state, (IBlockAccess)world, pos)) {
            if (currentID == Blocks.field_150348_b && world.field_73012_v.nextInt(5) == 0) {
                world.func_180501_a(pos, Blocks.field_150347_e.func_176223_P(), 3);
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                ++cost;
            }
            if (currentID == Blocks.field_150417_aV && state.func_177229_b((IProperty)BlockStoneBrick.field_176249_a) == BlockStoneBrick.EnumType.DEFAULT && world.field_73012_v.nextInt(5) == 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED), 3);
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                ++cost;
            }
            if (currentID == TFBlocks.mazestone && state.func_177229_b(BlockTFMazestone.VARIANT) == MazestoneVariant.BRICK && world.field_73012_v.nextInt(5) == 0) {
                world.func_180501_a(pos, TFBlocks.mazestone.func_176223_P().func_177226_a(BlockTFMazestone.VARIANT, (Comparable)((Object)MazestoneVariant.CRACKED)), 3);
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                ++cost;
            }
            if (currentID == Blocks.field_150347_e && world.field_73012_v.nextInt(5) == 0) {
                world.func_180501_a(pos, Blocks.field_150351_n.func_176223_P(), 3);
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                ++cost;
            }
            if (currentID == Blocks.field_150351_n || currentID == Blocks.field_150346_d) {
                if (living instanceof EntityPlayer) {
                    if (currentID.canHarvestBlock((IBlockAccess)world, pos, (EntityPlayer)living) && world.field_73012_v.nextInt(20) == 0) {
                        world.func_175698_g(pos);
                        currentID.func_180657_a(world, (EntityPlayer)living, pos, state, world.func_175625_s(pos), ItemStack.field_190927_a);
                        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                        ++cost;
                    }
                } else if (world.func_82736_K().func_82766_b("mobGriefing") && world.field_73012_v.nextInt(20) == 0) {
                    world.func_175655_b(pos, true);
                    ++cost;
                }
            }
        }
        return cost;
    }
}

