/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketMaps;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import twilightforest.TFMagicMapData;
import twilightforest.item.ItemTFMagicMap;

public class PacketMagicMap
implements IMessage {
    private int mapID;
    private byte[] featureData;
    private SPacketMaps inner;

    public PacketMagicMap() {
    }

    public PacketMagicMap(int mapID, TFMagicMapData mapData, SPacketMaps inner) {
        this.mapID = mapID;
        this.featureData = mapData.serializeFeatures();
        this.inner = inner;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer tmp = new PacketBuffer(buf);
        this.mapID = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.featureData = tmp.func_179251_a();
        this.inner = new SPacketMaps();
        try {
            this.inner.func_148837_a(tmp);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read inner SPacketMaps", e);
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer tmp = new PacketBuffer(buf);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.mapID, (int)5);
        tmp.func_179250_a(this.featureData);
        try {
            this.inner.func_148840_b(tmp);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't write inner SPacketMaps", e);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketMagicMap, IMessage> {
        public IMessage onMessage(final PacketMagicMap message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    TFMagicMapData mapData = ItemTFMagicMap.loadMapData(message.mapID, (World)Minecraft.func_71410_x().field_71441_e);
                    message.inner.func_179734_a((MapData)mapData);
                    mapData.deserializeFeatures(message.featureData);
                    Map saveVanilla = mapData.field_76203_h;
                    mapData.field_76203_h = new LinkedHashMap();
                    for (TFMagicMapData.TFMapDecoration tfDecor : mapData.tfDecorations) {
                        mapData.field_76203_h.put(((Object)((Object)tfDecor)).toString(), tfDecor);
                    }
                    mapData.field_76203_h.putAll(saveVanilla);
                    Minecraft.func_71410_x().field_71460_t.func_147701_i().func_148246_a((MapData)mapData);
                }
            });
            return null;
        }
    }
}

