/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomes;
import twilightforest.block.BlockTFCastleMagic;
import twilightforest.block.BlockTFForceField;
import twilightforest.block.TFBlocks;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleDungeonEntrance;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleDungeonExit;
import twilightforest.structures.lichtower.ComponentTFTowerWing;
import twilightforest.util.RotationUtil;

public class ComponentTFFinalCastleDungeonRoom31
extends ComponentTFTowerWing {
    public int level;

    public ComponentTFFinalCastleDungeonRoom31() {
    }

    public ComponentTFFinalCastleDungeonRoom31(TFFeature feature, Random rand, int i, int x, int y, int z, EnumFacing direction, int level) {
        super(feature, i);
        this.func_186164_a(direction);
        this.spawnListIndex = 2;
        this.size = 31;
        this.height = 7;
        this.level = level;
        this.field_74887_e = StructureTFComponent.getComponentToAddBoundingBox(x, y, z, -15, 0, -15, this.size - 1, this.height - 1, this.size - 1, EnumFacing.SOUTH);
    }

    @Override
    public void func_74861_a(StructureComponent parent, List<StructureComponent> list, Random rand) {
        int i;
        Rotation direction;
        int maxSpread;
        if (parent != null && parent instanceof StructureTFComponent) {
            this.deco = ((StructureTFComponent)parent).deco;
        }
        int mySpread = this.func_74877_c() - parent.func_74877_c();
        int n = maxSpread = this.level == 1 ? 2 : 3;
        if (mySpread == maxSpread && !this.isExitBuildForLevel(parent)) {
            direction = RotationUtil.getRandomRotation(rand);
            for (i = 0; i < 8 && !this.isExitBuildForLevel(parent); ++i) {
                if (!this.addDungeonExit(parent, list, rand, direction = direction.func_185830_a(RotationUtil.ROTATIONS[i & 3]))) continue;
                this.setExitBuiltForLevel(parent, true);
            }
        }
        if (mySpread < maxSpread) {
            direction = RotationUtil.getRandomRotation(rand);
            for (i = 0; i < 12; ++i) {
                direction = direction.func_185830_a(RotationUtil.ROTATIONS[i & 3]);
                this.addDungeonRoom(parent, list, rand, direction, this.level);
            }
        }
    }

    private boolean isExitBuildForLevel(StructureComponent parent) {
        if (parent instanceof ComponentTFFinalCastleDungeonEntrance) {
            return ((ComponentTFFinalCastleDungeonEntrance)parent).hasExit;
        }
        return false;
    }

    private void setExitBuiltForLevel(StructureComponent parent, boolean exit) {
        if (parent instanceof ComponentTFFinalCastleDungeonEntrance) {
            ((ComponentTFFinalCastleDungeonEntrance)parent).hasExit = exit;
        }
    }

    protected boolean addDungeonRoom(StructureComponent parent, List<StructureComponent> list, Random rand, Rotation rotation, int level) {
        rotation = rotation.func_185830_a(this.field_186169_c);
        BlockPos rc = this.getNewRoomCoords(rand, rotation);
        ComponentTFFinalCastleDungeonRoom31 dRoom = new ComponentTFFinalCastleDungeonRoom31(this.getFeatureType(), rand, this.field_74886_g + 1, rc.func_177958_n(), rc.func_177956_o(), rc.func_177952_p(), rotation.func_185831_a(EnumFacing.SOUTH), level);
        StructureBoundingBox largerBB = new StructureBoundingBox(dRoom.func_74874_b());
        int expand = 0;
        largerBB.field_78897_a -= expand;
        largerBB.field_78896_c -= expand;
        largerBB.field_78893_d += expand;
        largerBB.field_78892_f += expand;
        StructureComponent intersect = StructureTFComponent.findIntersectingExcluding(list, largerBB, this);
        if (intersect == null) {
            list.add(dRoom);
            dRoom.func_74861_a(parent, list, rand);
            return true;
        }
        return false;
    }

    protected boolean addDungeonExit(StructureComponent parent, List<StructureComponent> list, Random rand, Rotation rotation) {
        rotation = rotation.func_185830_a(this.field_186169_c);
        BlockPos rc = this.getNewRoomCoords(rand, rotation);
        ComponentTFFinalCastleDungeonExit dRoom = new ComponentTFFinalCastleDungeonExit(this.getFeatureType(), rand, this.field_74886_g + 1, rc.func_177958_n(), rc.func_177956_o(), rc.func_177952_p(), rotation.func_185831_a(EnumFacing.SOUTH), this.level);
        StructureComponent intersect = StructureTFComponent.findIntersectingExcluding(list, dRoom.func_74874_b(), this);
        if (intersect == null) {
            list.add(dRoom);
            dRoom.func_74861_a(this, list, rand);
            return true;
        }
        return false;
    }

    private BlockPos getNewRoomCoords(Random rand, Rotation rotation) {
        int offset = rand.nextInt(15) - 9;
        if (rand.nextBoolean()) {
            offset += this.size;
        }
        switch (rotation) {
            default: {
                return new BlockPos(this.field_74887_e.field_78893_d + 9, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + offset);
            }
            case CLOCKWISE_90: {
                return new BlockPos(this.field_74887_e.field_78897_a + offset, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 9);
            }
            case CLOCKWISE_180: {
                return new BlockPos(this.field_74887_e.field_78897_a - 9, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + offset);
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new BlockPos(this.field_74887_e.field_78897_a + offset, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 9);
    }

    @Override
    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        if (this.isBoundingBoxOutOfPlateau(world, sbb)) {
            return false;
        }
        Random decoRNG = new Random(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 321534781) ^ (long)(this.field_74887_e.field_78896_c * 756839));
        this.func_74878_a(world, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        EnumDyeColor forceFieldMeta = this.getForceFieldMeta(decoRNG);
        EnumDyeColor runeMeta = this.getRuneMeta(forceFieldMeta);
        IBlockState forceField = TFBlocks.forceField.func_176223_P().func_177226_a(BlockTFForceField.COLOR, (Comparable)forceFieldMeta);
        IBlockState castleMagic = TFBlocks.castleMagic.func_176223_P().func_177226_a(BlockTFCastleMagic.COLOR, (Comparable)runeMeta);
        for (Rotation rotation : RotationUtil.ROTATIONS) {
            int cs = 7;
            this.fillBlocksRotated(world, sbb, cs, 0, cs + 1, cs, this.height - 1, this.size - 2 - cs, forceField, rotation);
            for (int z = cs; z < this.size - 1 - cs; z += 4) {
                this.fillBlocksRotated(world, sbb, cs, 0, z, cs, this.height - 1, z, castleMagic, rotation);
                int y = (z - cs) % 8 == 0 ? decoRNG.nextInt(3) + 0 : decoRNG.nextInt(3) + 4;
                this.fillBlocksRotated(world, sbb, cs, y, z + 1, cs, y, z + 3, castleMagic, rotation);
            }
        }
        return true;
    }

    private boolean isBoundingBoxOutOfPlateau(World world, StructureBoundingBox sbb) {
        int minX = this.field_74887_e.field_78897_a - 1;
        int minZ = this.field_74887_e.field_78896_c - 1;
        int maxX = this.field_74887_e.field_78893_d + 1;
        int maxZ = this.field_74887_e.field_78892_f + 1;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                pos.func_181079_c(x, 0, z);
                if (world.func_180494_b((BlockPos)pos) == TFBiomes.highlandsCenter || world.func_180494_b((BlockPos)pos) == TFBiomes.thornlands) continue;
                return true;
            }
        }
        return false;
    }

    protected EnumDyeColor getRuneMeta(EnumDyeColor forceFieldMeta) {
        return BlockTFCastleMagic.VALID_COLORS.get(forceFieldMeta == BlockTFForceField.VALID_COLORS.get(4) ? 1 : 2);
    }

    protected EnumDyeColor getForceFieldMeta(Random decoRNG) {
        return BlockTFForceField.VALID_COLORS.get(decoRNG.nextInt(2) + 3);
    }
}

