/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.hollowtree;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.TFFeature;
import twilightforest.block.TFBlocks;
import twilightforest.structures.hollowtree.ComponentTFHollowTreeLeafDungeon;
import twilightforest.structures.hollowtree.ComponentTFHollowTreeMedBranch;
import twilightforest.world.TFGenerator;

public class ComponentTFHollowTreeLargeBranch
extends ComponentTFHollowTreeMedBranch {
    private static final int LEAF_DUNGEON_CHANCE = 8;
    public boolean hasLeafDungeon = false;

    public ComponentTFHollowTreeLargeBranch() {
    }

    protected ComponentTFHollowTreeLargeBranch(TFFeature feature, int i, int sx, int sy, int sz, double length, double angle, double tilt, boolean leafy) {
        super(feature, i, sx, sy, sz, length, angle, tilt, leafy);
    }

    public void func_74861_a(StructureComponent structurecomponent, List<StructureComponent> list, Random rand) {
        int index = this.func_74877_c();
        boolean bl = this.hasLeafDungeon = rand.nextInt(8) == 0;
        if (this.hasLeafDungeon) {
            BlockPos dpos = TFGenerator.translate(this.dest, 2.0, this.angle, this.tilt);
            this.makeLeafDungeon(list, rand, index + 1, dpos);
        }
        int numMedBranches = rand.nextInt((int)(this.length / 6.0)) + (int)(this.length / 8.0);
        for (int i = 0; i <= numMedBranches; ++i) {
            double outVar = rand.nextDouble() * 0.3 + 0.3;
            double angleVar = rand.nextDouble() * 0.225 * ((i & 1) == 0 ? 1.0 : -1.0);
            BlockPos bsrc = TFGenerator.translate(this.src, this.length * outVar, this.angle, this.tilt);
            this.makeMedBranch(list, rand, index + 2 + i, bsrc.func_177958_n(), bsrc.func_177956_o(), bsrc.func_177952_p(), this.length * 0.6, this.angle + angleVar, this.tilt, this.leafy);
        }
    }

    public void makeLeafDungeon(List<StructureComponent> list, Random rand, int index, BlockPos pos) {
        ComponentTFHollowTreeLeafDungeon dungeon = new ComponentTFHollowTreeLeafDungeon(this.getFeatureType(), index, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 4);
        list.add(dungeon);
        dungeon.func_74861_a(this, list, rand);
    }

    public void makeMedBranch(List<StructureComponent> list, Random rand, int index, int x, int y, int z, double branchLength, double branchRotation, double branchAngle, boolean leafy) {
        ComponentTFHollowTreeMedBranch branch = new ComponentTFHollowTreeMedBranch(this.getFeatureType(), index, x, y, z, branchLength, branchRotation, branchAngle, leafy);
        if (!this.branchIntersectsDungeon(branch, list)) {
            list.add(branch);
            branch.func_74861_a(this, list, rand);
        }
    }

    @Override
    public boolean func_74875_a(World world, Random random, StructureBoundingBox sbb) {
        return this.addComponentParts(world, random, sbb, false);
    }

    @Override
    public boolean addComponentParts(World world, Random rand, StructureBoundingBox sbb, boolean drawLeaves) {
        int i;
        BlockPos rsrc = this.src.func_177982_a(-this.field_74887_e.field_78897_a, -this.field_74887_e.field_78895_b, -this.field_74887_e.field_78896_c);
        BlockPos rdest = this.dest.func_177982_a(-this.field_74887_e.field_78897_a, -this.field_74887_e.field_78895_b, -this.field_74887_e.field_78896_c);
        if (!drawLeaves) {
            IBlockState defaultState = TFBlocks.log.func_176223_P();
            this.drawBresehnam(world, sbb, rsrc.func_177958_n(), rsrc.func_177956_o(), rsrc.func_177952_p(), rdest.func_177958_n(), rdest.func_177956_o(), rdest.func_177952_p(), defaultState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE));
            int reinforcements = 4;
            for (i = 0; i <= reinforcements; ++i) {
                int vx = (i & 2) == 0 ? 1 : 0;
                int vy = (i & 1) == 0 ? 1 : -1;
                int vz = (i & 2) == 0 ? 0 : 1;
                this.drawBresehnam(world, sbb, rsrc.func_177958_n() + vx, rsrc.func_177956_o() + vy, rsrc.func_177952_p() + vz, rdest.func_177958_n(), rdest.func_177956_o(), rdest.func_177952_p(), defaultState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE));
            }
        }
        Random decoRNG = new Random(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 321534781) ^ (long)(this.field_74887_e.field_78896_c * 756839));
        int numSmallBranches = decoRNG.nextInt(2) + 1;
        for (i = 0; i <= numSmallBranches; ++i) {
            double outVar = decoRNG.nextFloat() * 0.25f + 0.25f;
            double angleVar = decoRNG.nextFloat() * 0.25f * ((i & 1) == 0 ? 1.0f : -1.0f);
            BlockPos bsrc = TFGenerator.translate(rsrc, this.length * outVar, this.angle, this.tilt);
            this.drawSmallBranch(world, sbb, bsrc.func_177958_n(), bsrc.func_177956_o(), bsrc.func_177952_p(), Math.max(this.length * (double)0.3f, 2.0), this.angle + angleVar, this.tilt, drawLeaves);
        }
        if (drawLeaves && !this.hasLeafDungeon) {
            this.makeLeafBlob(world, sbb, rdest.func_177958_n(), rdest.func_177956_o(), rdest.func_177952_p(), 3);
        }
        return true;
    }
}

