/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.icetower;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.structures.icetower.ComponentTFIceTowerBridge;
import twilightforest.structures.icetower.ComponentTFIceTowerEntrance;
import twilightforest.structures.icetower.ComponentTFIceTowerWing;
import twilightforest.structures.icetower.StructureDecoratorIceTower;

public class ComponentTFIceTowerMain
extends ComponentTFIceTowerWing {
    public boolean hasBossWing = false;

    public ComponentTFIceTowerMain() {
    }

    public ComponentTFIceTowerMain(TFFeature feature, World world, Random rand, int index, int x, int y, int z) {
        this(feature, world, rand, index, x + 11, y + 40, z + 11, EnumFacing.NORTH);
    }

    public ComponentTFIceTowerMain(TFFeature feature, World world, Random rand, int index, int x, int y, int z, EnumFacing rotation) {
        super(feature, index, x, y, z, 11, 31 + rand.nextInt(3) * 10, rotation);
        if (this.deco == null) {
            this.deco = new StructureDecoratorIceTower();
        }
    }

    protected ComponentTFIceTowerMain(TFFeature feature, int i, int x, int y, int z, int pSize, int pHeight, EnumFacing direction) {
        super(feature, i, x, y, z, pSize, pHeight, direction);
    }

    @Override
    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("hasBossWing", this.hasBossWing);
    }

    @Override
    protected void func_143011_b(NBTTagCompound par1NBTTagCompound, TemplateManager templateManager) {
        super.func_143011_b(par1NBTTagCompound, templateManager);
        this.hasBossWing = par1NBTTagCompound.func_74767_n("hasBossWing");
    }

    @Override
    public void func_74861_a(StructureComponent parent, List<StructureComponent> list, Random rand) {
        int length;
        super.func_74861_a(parent, list, rand);
        StructureBoundingBox towerBB = StructureBoundingBox.func_78887_a();
        for (StructureComponent structurecomponent : list) {
            towerBB.func_78888_b(structurecomponent.func_74874_b());
        }
        BlockPos myDoor = (BlockPos)this.openings.get(0);
        BlockPos entranceDoor = new BlockPos((Vec3i)myDoor);
        if (myDoor.func_177958_n() == 0 && (length = this.func_74874_b().field_78897_a - towerBB.field_78897_a) >= 0) {
            entranceDoor = entranceDoor.func_177985_f(length);
            this.makeEntranceBridge(list, rand, this.func_74877_c() + 1, myDoor.func_177958_n(), myDoor.func_177956_o(), myDoor.func_177952_p(), length, Rotation.CLOCKWISE_180);
        }
        if (myDoor.func_177958_n() == this.size - 1) {
            entranceDoor = entranceDoor.func_177965_g(towerBB.field_78893_d - this.func_74874_b().field_78893_d);
        }
        if (myDoor.func_177952_p() == 0) {
            entranceDoor = entranceDoor.func_177970_e(towerBB.field_78896_c - this.func_74874_b().field_78896_c);
        }
        if (myDoor.func_177958_n() == this.size - 1) {
            entranceDoor = entranceDoor.func_177970_e(towerBB.field_78892_f - this.func_74874_b().field_78892_f);
        }
        this.makeEntranceTower(list, rand, this.func_74877_c() + 1, entranceDoor.func_177958_n(), entranceDoor.func_177956_o(), entranceDoor.func_177952_p(), 11, 11, this.field_186169_c);
    }

    private void makeEntranceBridge(List<StructureComponent> list, Random rand, int index, int x, int y, int z, int length, Rotation rotation) {
        EnumFacing direction = this.getStructureRelativeRotation(rotation);
        BlockPos dest = this.offsetTowerCCoords(x, y, z, 5, direction);
        ComponentTFIceTowerBridge bridge = new ComponentTFIceTowerBridge(this.getFeatureType(), index, dest.func_177958_n(), dest.func_177956_o(), dest.func_177952_p(), length, direction);
        list.add(bridge);
        bridge.func_74861_a(list.get(0), list, rand);
    }

    public boolean makeEntranceTower(List<StructureComponent> list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        EnumFacing direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        ComponentTFIceTowerEntrance entrance = new ComponentTFIceTowerEntrance(this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        list.add(entrance);
        ((ComponentTFIceTowerWing)entrance).func_74861_a(list.get(0), list, rand);
        this.addOpening(x, y, z, rotation);
        return true;
    }
}

