/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.stronghold;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.TFTreasure;
import twilightforest.structures.stronghold.StructureTFStrongholdComponent;

public class ComponentTFStrongholdSmallStairs
extends StructureTFStrongholdComponent {
    private boolean enterBottom;
    public boolean hasTreasure;
    public boolean chestTrapped;

    public ComponentTFStrongholdSmallStairs() {
    }

    public ComponentTFStrongholdSmallStairs(TFFeature feature, int i, EnumFacing facing, int x, int y, int z) {
        super(feature, i, facing, x, y, z);
    }

    @Override
    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("enterBottom", this.enterBottom);
        par1NBTTagCompound.func_74757_a("hasTreasure", this.hasTreasure);
        par1NBTTagCompound.func_74757_a("chestTrapped", this.chestTrapped);
    }

    @Override
    protected void func_143011_b(NBTTagCompound par1NBTTagCompound, TemplateManager templateManager) {
        super.func_143011_b(par1NBTTagCompound, templateManager);
        this.enterBottom = par1NBTTagCompound.func_74767_n("enterBottom");
        this.hasTreasure = par1NBTTagCompound.func_74767_n("hasTreasure");
        this.chestTrapped = par1NBTTagCompound.func_74767_n("chestTrapped");
    }

    @Override
    public StructureBoundingBox generateBoundingBox(EnumFacing facing, int x, int y, int z) {
        if (y > 17) {
            this.enterBottom = false;
        } else if (y < 11) {
            this.enterBottom = true;
        } else {
            boolean bl = this.enterBottom = (z & 1) == 0;
        }
        if (this.enterBottom) {
            return StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)9, (int)14, (int)9, (EnumFacing)facing);
        }
        return StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-4, (int)-8, (int)0, (int)9, (int)14, (int)9, (EnumFacing)facing);
    }

    @Override
    public void func_74861_a(StructureComponent parent, List<StructureComponent> list, Random random) {
        super.func_74861_a(parent, list, random);
        if (this.enterBottom) {
            this.addDoor(4, 1, 0);
            this.addNewComponent(parent, list, random, Rotation.NONE, 4, 8, 9);
        } else {
            this.addDoor(4, 8, 0);
            this.addNewComponent(parent, list, random, Rotation.NONE, 4, 1, 9);
        }
        this.hasTreasure = random.nextBoolean();
        this.chestTrapped = random.nextInt(3) == 0;
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        this.placeStrongholdWalls(world, sbb, 0, 0, 0, 8, 13, 8, rand, this.deco.randomBlocks);
        this.func_175804_a(world, sbb, 1, 7, 1, 7, 7, 7, this.deco.platformState, Blocks.field_150350_a.func_176223_P(), false);
        this.func_74878_a(world, sbb, 2, 7, 2, 6, 7, 6);
        Rotation rotation = this.enterBottom ? Rotation.NONE : Rotation.CLOCKWISE_180;
        for (int y = 1; y < 8; ++y) {
            for (int x = 3; x < 6; ++x) {
                this.setBlockStateRotated(world, Blocks.field_150350_a.func_176223_P(), x, y + 1, y, rotation, sbb);
                this.setBlockStateRotated(world, this.deco.stairState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), x, y, y, rotation, sbb);
                this.setBlockStateRotated(world, this.deco.blockState, x, y - 1, y, rotation, sbb);
            }
        }
        if (this.hasTreasure) {
            this.placeTreasureRotated(world, 4, 1, 6, rotation, TFTreasure.stronghold_cache, this.chestTrapped, sbb);
            if (this.chestTrapped) {
                this.setBlockStateRotated(world, Blocks.field_150335_W.func_176223_P(), 4, 0, 6, rotation, sbb);
            }
            for (int z = 5; z < 8; ++z) {
                this.setBlockStateRotated(world, this.deco.stairState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST), 3, 1, z, rotation, sbb);
                this.setBlockStateRotated(world, this.deco.stairState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST), 5, 1, z, rotation, sbb);
            }
            this.setBlockStateRotated(world, this.deco.stairState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), 4, 1, 5, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.stairState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH), 4, 1, 7, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.stairState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), 4, 2, 6, rotation, sbb);
        }
        if (this.enterBottom) {
            this.placeWallStatue(world, 4, 8, 1, Rotation.CLOCKWISE_180, sbb);
        } else {
            this.placeWallStatue(world, 4, 8, 7, Rotation.NONE, sbb);
        }
        this.placeDoors(world, rand, sbb);
        return true;
    }
}

