/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.biomes.TFBiomes;
import twilightforest.block.TFBlocks;
import twilightforest.world.MapGenTFHollowTree;
import twilightforest.world.MapGenTFMajorFeature;
import twilightforest.world.TFGenCaves;
import twilightforest.world.TFGenRavine;
import twilightforest.world.TFWorld;

public class ChunkGeneratorTwilightForest
implements IChunkGenerator {
    private final Random rand;
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    private NoiseGeneratorPerlin surfaceNoise;
    private NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    public NoiseGeneratorOctaves forestNoise;
    private final World world;
    private WorldType terrainType;
    private final double[] heightMap;
    private final float[] biomeWeights;
    private double[] depthBuffer = new double[256];
    private Biome[] biomesForGeneration;
    double[] mainNoiseRegion;
    double[] minLimitRegion;
    double[] maxLimitRegion;
    double[] depthRegion;
    private final TFGenCaves caveGenerator = new TFGenCaves();
    private final TFGenRavine ravineGenerator = new TFGenRavine();
    private final MapGenTFMajorFeature majorFeatureGenerator = new MapGenTFMajorFeature();
    private final MapGenTFHollowTree hollowTreeGenerator = new MapGenTFHollowTree();

    public ChunkGeneratorTwilightForest(World world, long l, boolean flag) {
        this.world = world;
        this.terrainType = world.func_72912_H().func_76067_t();
        this.rand = new Random(l);
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.forestNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.biomeWeights[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
    }

    public Chunk func_185932_a(int cx, int cz) {
        this.rand.setSeed((long)cx * 341873128712L + (long)cz * 132897987541L);
        ChunkPrimer primer = new ChunkPrimer();
        this.setBlocksInChunk(cx, cz, primer);
        this.squishTerrain(primer);
        this.addDarkForestCanopy2(cx, cz, primer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, cx * 16, cz * 16, 16, 16);
        this.addGlaciers(cx, cz, primer, this.biomesForGeneration);
        this.deformTerrainForFeature(cx, cz, primer);
        this.replaceBiomeBlocks(cx, cz, primer, this.biomesForGeneration);
        this.caveGenerator.func_186125_a(this.world, cx, cz, primer);
        this.ravineGenerator.func_186125_a(this.world, cx, cz, primer);
        this.majorFeatureGenerator.func_186125_a(this.world, cx, cz, null);
        this.hollowTreeGenerator.func_186125_a(this.world, cx, cz, null);
        Chunk chunk = new Chunk(this.world, primer, cx, cz);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        int seaLevel = 63;
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.generateHeightmap(chunkX * 4, 0, chunkZ * 4);
        for (int k = 0; k < 4; ++k) {
            int l = k * 5;
            int i1 = (k + 1) * 5;
            for (int j1 = 0; j1 < 4; ++j1) {
                int k1 = (l + j1) * 33;
                int l1 = (l + j1 + 1) * 33;
                int i2 = (i1 + j1) * 33;
                int j2 = (i1 + j1 + 1) * 33;
                for (int k2 = 0; k2 < 32; ++k2) {
                    double d0 = 0.125;
                    double d1 = this.heightMap[k1 + k2];
                    double d2 = this.heightMap[l1 + k2];
                    double d3 = this.heightMap[i2 + k2];
                    double d4 = this.heightMap[j2 + k2];
                    double d5 = (this.heightMap[k1 + k2 + 1] - d1) * d0;
                    double d6 = (this.heightMap[l1 + k2 + 1] - d2) * d0;
                    double d7 = (this.heightMap[i2 + k2 + 1] - d3) * d0;
                    double d8 = (this.heightMap[j2 + k2 + 1] - d4) * d0;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double d15 = d10 - d16;
                            for (int k3 = 0; k3 < 4; ++k3) {
                                double d;
                                d15 += d16;
                                if (d > 0.0) {
                                    primer.func_177855_a(k * 4 + i3, k2 * 8 + l2, j1 * 4 + k3, Blocks.field_150348_b.func_176223_P());
                                    continue;
                                }
                                if (k2 * 8 + l2 >= seaLevel) continue;
                                primer.func_177855_a(k * 4 + i3, k2 * 8 + l2, j1 * 4 + k3, Blocks.field_150355_j.func_176223_P());
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void generateHeightmap(int x, int zero, int z) {
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, x, z, 5, 5, 200.0, 200.0, 0.5);
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, x, zero, z, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        int terrainIndex = 0;
        int noiseIndex = 0;
        for (int ax = 0; ax < 5; ++ax) {
            for (int az = 0; az < 5; ++az) {
                float totalVariation = 0.0f;
                float totalHeight = 0.0f;
                float totalFactor = 0.0f;
                int two = 2;
                Biome biomegenbase = this.biomesForGeneration[ax + 2 + (az + 2) * 10];
                for (int ox = -two; ox <= two; ++ox) {
                    for (int oz = -two; oz <= two; ++oz) {
                        Biome biomegenbase1 = this.biomesForGeneration[ax + ox + 2 + (az + oz + 2) * 10];
                        float rootHeight = biomegenbase1.func_185355_j();
                        float heightVariation = biomegenbase1.func_185360_m();
                        if (this.terrainType == WorldType.field_151360_e && rootHeight > 0.0f) {
                            rootHeight = 1.0f + rootHeight * 2.0f;
                            heightVariation = 1.0f + heightVariation * 4.0f;
                        }
                        float heightFactor = this.biomeWeights[ox + 2 + (oz + 2) * 5] / (rootHeight + 2.0f);
                        if (biomegenbase1.func_185355_j() > biomegenbase.func_185355_j()) {
                            heightFactor /= 2.0f;
                        }
                        totalVariation += heightVariation * heightFactor;
                        totalHeight += rootHeight * heightFactor;
                        totalFactor += heightFactor;
                    }
                }
                totalVariation /= totalFactor;
                totalHeight /= totalFactor;
                totalVariation = totalVariation * 0.9f + 0.1f;
                totalHeight = (totalHeight * 4.0f - 1.0f) / 8.0f;
                double terrainNoise = this.depthRegion[noiseIndex] / 8000.0;
                if (terrainNoise < 0.0) {
                    terrainNoise = -terrainNoise * 0.3;
                }
                if ((terrainNoise = terrainNoise * 3.0 - 2.0) < 0.0) {
                    if ((terrainNoise /= 2.0) < -1.0) {
                        terrainNoise = -1.0;
                    }
                    terrainNoise /= 1.4;
                    terrainNoise /= 2.0;
                } else {
                    if (terrainNoise > 1.0) {
                        terrainNoise = 1.0;
                    }
                    terrainNoise /= 8.0;
                }
                ++noiseIndex;
                double heightCalc = totalHeight;
                double variationCalc = totalVariation;
                heightCalc += terrainNoise * 0.2;
                heightCalc = heightCalc * 8.5 / 8.0;
                double d5 = 8.5 + heightCalc * 4.0;
                for (int ay = 0; ay < 33; ++ay) {
                    double d6 = ((double)ay - d5) * 12.0 * 128.0 / 256.0 / variationCalc;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.minLimitRegion[terrainIndex] / 512.0;
                    double d8 = this.maxLimitRegion[terrainIndex] / 512.0;
                    double d9 = (this.mainNoiseRegion[terrainIndex] / 10.0 + 1.0) / 2.0;
                    double terrainCalc = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (ay > 29) {
                        double d11 = (float)(ay - 29) / 3.0f;
                        terrainCalc = terrainCalc * (1.0 - d11) + -10.0 * d11;
                    }
                    this.heightMap[terrainIndex] = terrainCalc;
                    ++terrainIndex;
                }
            }
        }
    }

    private void squishTerrain(ChunkPrimer primer) {
        int squishHeight = TFWorld.MAXHEIGHT / 2;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < TFWorld.CHUNKHEIGHT; ++y) {
                    if (y < squishHeight) {
                        primer.func_177855_a(x, y, z, primer.func_177856_a(x, y * 2 + 1, z));
                        continue;
                    }
                    primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    public void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        double d0 = 0.03125;
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomesIn[j + i * 16];
                biome.func_180622_a(this.world, this.rand, primer, x * 16 + i, z * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    private void deformTerrainForFeature(int cx, int cz, ChunkPrimer primer) {
        TFFeature nearFeature = TFFeature.getNearestFeature(cx, cz, this.world);
        if (!nearFeature.isTerrainAltered) {
            return;
        }
        int[] nearCenter = TFFeature.getNearestCenter(cx, cz, this.world);
        int hx = nearCenter[0];
        int hz = nearCenter[1];
        if (nearFeature == TFFeature.trollCave) {
            this.deformTerrainForTrollCloud2(primer, nearFeature, cx, cz, hx, hz);
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int dx = x - hx;
                int dz = z - hz;
                if (nearFeature == TFFeature.hill1 || nearFeature == TFFeature.hill2 || nearFeature == TFFeature.hill3 || nearFeature == TFFeature.hydraLair) {
                    int hdiam = (nearFeature.size * 2 + 1) * 16;
                    int dist = (int)Math.sqrt(dx * dx + dz * dz);
                    int hheight = (int)(Math.cos((double)((float)dist / (float)hdiam) * Math.PI) * (double)((float)hdiam / 3.0f));
                    this.raiseHills(primer, nearFeature, hdiam, x, z, dx, dz, hheight);
                    continue;
                }
                if (nearFeature == TFFeature.hedgeMaze || nearFeature == TFFeature.nagaCourtyard || nearFeature == TFFeature.questGrove) {
                    this.flattenTerrainForFeature(primer, nearFeature, x, z, dx, dz);
                    continue;
                }
                if (nearFeature != TFFeature.yetiCave) continue;
                this.deformTerrainForYetiLair(primer, nearFeature, x, z, dx, dz);
            }
        }
    }

    private void raiseHills(ChunkPrimer primer, TFFeature nearFeature, int hdiam, int x, int z, int dx, int dz, int hillHeight) {
        int newGround = -1;
        boolean foundGroundLevel = false;
        for (int y = 0; y < TFWorld.CHUNKHEIGHT; ++y) {
            Block currentTerrain = primer.func_177856_a(x, y, z).func_177230_c();
            if (currentTerrain != Blocks.field_150348_b && !foundGroundLevel) {
                newGround = y + hillHeight;
                foundGroundLevel = true;
            }
            if (!foundGroundLevel || y > newGround) continue;
            primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
        }
        int hollow = hillHeight - 4 - nearFeature.size;
        if (nearFeature == TFFeature.hydraLair) {
            int mx = dx + 16;
            int mz = dz + 16;
            int mdist = (int)Math.sqrt(mx * mx + mz * mz);
            int mheight = (int)(Math.cos((double)mdist / ((double)hdiam / 1.5) * Math.PI) * ((double)hdiam / 1.5));
            hollow = Math.max(mheight - 4, hollow);
        }
        if (hollow < 0) {
            hollow = 0;
        }
        for (int y = 0; y < TFWorld.CHUNKHEIGHT; ++y) {
            if (hillHeight > 0 && y < TFWorld.SEALEVEL && primer.func_177856_a(x, y, z).func_177230_c() != Blocks.field_150348_b) {
                primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
            }
            int hollowFloor = TFWorld.SEALEVEL - 3 - hollow / 8;
            if (nearFeature == TFFeature.hydraLair) {
                hollowFloor = TFWorld.SEALEVEL;
            }
            if (y <= hollowFloor || y >= hollowFloor + hollow) continue;
            primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
        }
    }

    private void flattenTerrainForFeature(ChunkPrimer primer, TFFeature nearFeature, int x, int z, int dx, int dz) {
        int y;
        float squishfactor = 0.0f;
        int mazeheight = TFWorld.SEALEVEL + 1;
        int FEATUREBOUNDRY = (nearFeature.size * 2 + 1) * 8 - 8;
        if (dx <= -FEATUREBOUNDRY) {
            squishfactor = (float)(-dx - FEATUREBOUNDRY) / 8.0f;
        }
        if (dx >= FEATUREBOUNDRY) {
            squishfactor = (float)(dx - FEATUREBOUNDRY) / 8.0f;
        }
        if (dz <= -FEATUREBOUNDRY) {
            squishfactor = Math.max(squishfactor, (float)(-dz - FEATUREBOUNDRY) / 8.0f);
        }
        if (dz >= FEATUREBOUNDRY) {
            squishfactor = Math.max(squishfactor, (float)(dz - FEATUREBOUNDRY) / 8.0f);
        }
        if (squishfactor > 0.0f) {
            int newGround = -1;
            for (y = 0; y <= 127; ++y) {
                Block currentTerrain = primer.func_177856_a(x, y, z).func_177230_c();
                if (currentTerrain == Blocks.field_150348_b || newGround != -1) continue;
                int oldGround = y;
                mazeheight = (int)((float)mazeheight + (float)(oldGround - mazeheight) * squishfactor);
                newGround = oldGround;
            }
        }
        for (y = 0; y <= 127; ++y) {
            Block b = primer.func_177856_a(x, y, z).func_177230_c();
            if (y < mazeheight && (b == Blocks.field_150350_a || b == Blocks.field_150355_j)) {
                primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
            }
            if (y < mazeheight || b == Blocks.field_150355_j) continue;
            primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
        }
    }

    private void deformTerrainForYetiLair(ChunkPrimer primer, TFFeature nearFeature, int x, int z, int dx, int dz) {
        int y;
        float squishfactor = 0.0f;
        int topHeight = TFWorld.SEALEVEL + 24;
        int outerBoundry = (nearFeature.size * 2 + 1) * 8 - 8;
        if (dx <= -outerBoundry) {
            squishfactor = (float)(-dx - outerBoundry) / 8.0f;
        }
        if (dx >= outerBoundry) {
            squishfactor = (float)(dx - outerBoundry) / 8.0f;
        }
        if (dz <= -outerBoundry) {
            squishfactor = Math.max(squishfactor, (float)(-dz - outerBoundry) / 8.0f);
        }
        if (dz >= outerBoundry) {
            squishfactor = Math.max(squishfactor, (float)(dz - outerBoundry) / 8.0f);
        }
        int caveBoundry = nearFeature.size * 2 * 8 - 8;
        int hollowCeiling = TFWorld.SEALEVEL + 16;
        int offset = Math.min(Math.abs(dx), Math.abs(dz));
        hollowCeiling = TFWorld.SEALEVEL + 40 - offset * 4;
        if (dx >= -caveBoundry && dz >= -caveBoundry && dx <= caveBoundry && dz <= caveBoundry) {
            hollowCeiling = TFWorld.SEALEVEL + 16;
        }
        hollowCeiling -= offset / 6;
        hollowCeiling = Math.min(hollowCeiling, TFWorld.SEALEVEL + 16);
        int hollowFloor = TFWorld.SEALEVEL - 1 + offset / 6;
        if (squishfactor > 0.0f) {
            int newGround = -1;
            for (y = 0; y <= 127; ++y) {
                Block currentTerrain = primer.func_177856_a(x, y, z).func_177230_c();
                if (currentTerrain == Blocks.field_150348_b || newGround != -1) continue;
                int oldGround = y;
                topHeight = (int)((float)topHeight + (float)(oldGround - topHeight) * squishfactor);
                hollowFloor = (int)((float)hollowFloor + (float)(oldGround - hollowFloor) * squishfactor);
                newGround = oldGround;
            }
        }
        for (y = 0; y <= 127; ++y) {
            Block b = primer.func_177856_a(x, y, z).func_177230_c();
            if (y < topHeight && (b == Blocks.field_150350_a || b == Blocks.field_150355_j)) {
                primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
            }
            if (y > hollowFloor && y < hollowCeiling) {
                primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
            }
            if (y != hollowFloor || y >= hollowCeiling || y >= TFWorld.SEALEVEL + 3) continue;
            primer.func_177855_a(x, y, z, Blocks.field_150403_cj.func_176223_P());
        }
    }

    private void deformTerrainForTrollCloud2(ChunkPrimer primer, TFFeature nearFeature, int cx, int cz, int hx, int hz) {
        for (int bx = 0; bx < 4; ++bx) {
            for (int bz = 0; bz < 4; ++bz) {
                int dx = bx * 4 - hx - 2;
                int dz = bz * 4 - hz - 2;
                int regionX = cx + 8 >> 4;
                int regionZ = cz + 8 >> 4;
                long seed = (long)(regionX * 3129871) ^ (long)regionZ * 116129781L;
                seed = seed * seed * 42317861L + seed * 7L;
                int num0 = (int)(seed >> 12 & 3L);
                int num1 = (int)(seed >> 15 & 3L);
                int num2 = (int)(seed >> 18 & 3L);
                int num3 = (int)(seed >> 21 & 3L);
                int num4 = (int)(seed >> 9 & 3L);
                int num5 = (int)(seed >> 6 & 3L);
                int num6 = (int)(seed >> 3 & 3L);
                int num7 = (int)(seed >> 0 & 3L);
                int dx2 = dx + num0 * 5 - num1 * 4;
                int dz2 = dz + num2 * 4 - num3 * 5;
                int dx3 = dx + num4 * 5 - num5 * 4;
                int dz3 = dz + num6 * 4 - num7 * 5;
                double dist0 = Math.sqrt(dx * dx + dz * dz) / 4.0;
                double dist2 = Math.sqrt(dx2 * dx2 + dz2 * dz2) / 3.5;
                double dist3 = Math.sqrt(dx3 * dx3 + dz3 * dz3) / 4.5;
                double dist = Math.min(dist0, Math.min(dist2, dist3));
                float pr = this.world.field_73012_v.nextFloat();
                double cv = dist - 7.0 - (double)(pr * 3.0f);
                int y = 166;
                int depth = 4;
                if (pr < 0.1f) {
                    ++y;
                }
                if (pr > 0.6f) {
                    ++depth;
                }
                if (pr > 0.9f) {
                    ++depth;
                }
                for (int sx = 0; sx < 4; ++sx) {
                    for (int sz = 0; sz < 4; ++sz) {
                        int d;
                        int lx = bx * 4 + sx;
                        int lz = bz * 4 + sz;
                        if (dist < 7.0 || cv < (double)0.05f) {
                            primer.func_177855_a(lx, y, lz, TFBlocks.wispyCloud.func_176223_P());
                            for (d = 1; d < depth; ++d) {
                                primer.func_177855_a(lx, y - d, lz, TFBlocks.fluffyCloud.func_176223_P());
                            }
                            primer.func_177855_a(lx, y - depth, lz, TFBlocks.wispyCloud.func_176223_P());
                            continue;
                        }
                        if (!(dist < 8.0) && !(cv < 1.0)) continue;
                        for (d = 1; d < depth; ++d) {
                            primer.func_177855_a(lx, y - d, lz, TFBlocks.fluffyCloud.func_176223_P());
                        }
                    }
                }
            }
        }
    }

    private void addGlaciers(int chunkX, int chunkZ, ChunkPrimer primer, Biome[] biomes) {
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                Biome biome = biomes[x & 0xF | (z & 0xF) << 4];
                if (biome != TFBiomes.glacier) continue;
                int topLevel = -1;
                for (int y = 127; y >= 0; --y) {
                    Block currentBlock = primer.func_177856_a(x, y, z).func_177230_c();
                    if (currentBlock != Blocks.field_150348_b) continue;
                    topLevel = y;
                    primer.func_177855_a(x, y, z, Blocks.field_150351_n.func_176223_P());
                    break;
                }
                int gHeight = 32;
                int gTop = topLevel + gHeight + 1;
                for (int y = topLevel + 1; y <= gTop && y < 128; ++y) {
                    primer.func_177855_a(x, y, z, Blocks.field_150432_aD.func_176223_P());
                }
            }
        }
    }

    private void addDarkForestCanopy2(int chunkX, int chunkZ, ChunkPrimer primer) {
        int x;
        int z;
        int[] thicks = new int[25];
        for (z = 0; z < 5; ++z) {
            for (x = 0; x < 5; ++x) {
                for (int bx = -1; bx <= 1; ++bx) {
                    for (int bz = -1; bz <= 1; ++bz) {
                        Biome biome = this.biomesForGeneration[x + bx + 2 + (z + bz + 2) * 10];
                        if (biome != TFBiomes.darkForest && biome != TFBiomes.darkForestCenter) continue;
                        int n = x + z * 5;
                        thicks[n] = thicks[n] + 1;
                    }
                }
            }
        }
        for (z = 0; z < 16; ++z) {
            for (x = 0; x < 16; ++x) {
                Block currentBlock;
                boolean generateForest;
                int hz;
                int dz;
                int[] nearCenter;
                int hx;
                int dx;
                int dist;
                int qx = x / 4;
                int qz = z / 4;
                float xweight = (float)(x % 4) * 0.25f + 0.125f;
                float zweight = (float)(z % 4) * 0.25f + 0.125f;
                float thickness = 0.0f;
                thickness += (float)thicks[qx + qz * 5] * (1.0f - xweight) * (1.0f - zweight);
                thickness += (float)thicks[qx + 1 + qz * 5] * xweight * (1.0f - zweight);
                thickness += (float)thicks[qx + (qz + 1) * 5] * (1.0f - xweight) * zweight;
                thickness += (float)thicks[qx + 1 + (qz + 1) * 5] * xweight * zweight;
                thickness -= 4.0f;
                TFFeature nearFeature = TFFeature.getNearestFeature(chunkX, chunkZ, this.world);
                if (nearFeature == TFFeature.darkTower && (dist = (int)Math.sqrt((dx = x - (hx = (nearCenter = TFFeature.getNearestCenter(chunkX, chunkZ, this.world))[0])) * dx + (dz = z - (hz = nearCenter[1])) * dz)) < 24) {
                    thickness -= (float)(24 - dist);
                }
                boolean bl = generateForest = thickness > 1.0f;
                if (!generateForest) continue;
                double d = 0.03125;
                this.depthBuffer = this.noiseGen4.func_76304_a(this.depthBuffer, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
                int topLevel = -1;
                for (int y = 127; y >= 0 && (currentBlock = primer.func_177856_a(x, y, z).func_177230_c()) != Blocks.field_150355_j; --y) {
                    if (currentBlock != Blocks.field_150348_b) continue;
                    topLevel = y;
                    break;
                }
                if (topLevel == -1) continue;
                int noise = Math.min(3, (int)(this.depthBuffer[z & 0xF | (x & 0xF) << 4] / 1.25));
                int treeBottom = topLevel + 12 - (int)(thickness * 0.5f);
                int treeTop = treeBottom + (int)(thickness * 1.5f);
                for (int y = treeBottom -= noise; y < treeTop; ++y) {
                    primer.func_177855_a(x, y, z, TFBlocks.darkleaves.func_176223_P());
                }
            }
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        int i = chunkX * 16;
        int j = chunkZ * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * k + (long)chunkZ * l ^ this.world.func_72905_C());
        boolean flag = false;
        ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag);
        boolean disableFeatures = false;
        disableFeatures |= this.majorFeatureGenerator.func_175794_a(this.world, this.rand, chunkpos);
        boolean bl = !TFFeature.getNearestFeature((int)chunkX, (int)chunkZ, (World)this.world).areChunkDecorationsEnabled;
        this.hollowTreeGenerator.func_175794_a(this.world, this.rand, chunkpos);
        if (!(disableFeatures |= bl) && this.rand.nextInt(4) == 0 && biome.field_76760_I.field_76808_K) {
            int i1 = blockpos.func_177958_n() + this.rand.nextInt(16) + 8;
            int i2 = this.rand.nextInt(TFWorld.CHUNKHEIGHT);
            int i3 = blockpos.func_177952_p() + this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.rand, new BlockPos(i1, i2, i3));
        }
        if (!disableFeatures && this.rand.nextInt(32) == 0) {
            int j1 = blockpos.func_177958_n() + this.rand.nextInt(16) + 8;
            int j2 = this.rand.nextInt(this.rand.nextInt(TFWorld.CHUNKHEIGHT - 8) + 8);
            int j3 = blockpos.func_177952_p() + this.rand.nextInt(16) + 8;
            if (j2 < TFWorld.SEALEVEL || this.rand.nextInt(10) == 0) {
                new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.world, this.rand, new BlockPos(j1, j2, j3));
            }
        }
        for (int k1 = 0; k1 < 8; ++k1) {
            int k2 = blockpos.func_177958_n() + this.rand.nextInt(16) + 8;
            int k3 = this.rand.nextInt(TFWorld.CHUNKHEIGHT);
            int l3 = blockpos.func_177952_p() + this.rand.nextInt(16) + 8;
            new WorldGenDungeons().func_180709_b(this.world, this.rand, new BlockPos(k2, k3, l3));
        }
        biome.func_180624_a(this.world, this.rand, new BlockPos(i, 0, j));
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    BlockPos blockpos1 = this.world.func_175725_q(blockpos.func_177982_a(k2, 0, j3));
                    BlockPos blockpos2 = blockpos1.func_177977_b();
                    if (this.world.func_175675_v(blockpos2)) {
                        this.world.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                    }
                    if (!this.world.func_175708_f(blockpos1, true)) continue;
                    this.world.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
                }
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome;
        TFFeature nearestFeature = TFFeature.getFeatureForRegion(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, this.world);
        if (nearestFeature != TFFeature.nothing) {
            if (this.isStructureConquered(pos)) {
                return null;
            }
            int spawnListIndex = this.majorFeatureGenerator.getSpawnListIndexAt(pos);
            if (spawnListIndex >= 0) {
                return nearestFeature.getSpawnableList(creatureType, spawnListIndex);
            }
        }
        if ((biome = this.world.func_180494_b(pos)) == null) {
            return Lists.newArrayList();
        }
        if (pos.func_177956_o() < TFWorld.SEALEVEL && creatureType == EnumCreatureType.MONSTER && biome instanceof TFBiomeBase) {
            return ((TFBiomeBase)biome).getUndergroundSpawnableList();
        }
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        if (structureName.equalsIgnoreCase(this.hollowTreeGenerator.func_143025_a())) {
            return this.hollowTreeGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        TFFeature feature = TFFeature.getFeatureByName(new ResourceLocation(structureName));
        if (feature != null && feature != TFFeature.nothing) {
            return TFFeature.findNearestFeaturePosBySpacing(worldIn, feature, position, 20, 11, 10387313, true, 100, findUnexplored);
        }
        return null;
    }

    public void setStructureConquered(int mapX, int mapY, int mapZ, boolean flag) {
        this.majorFeatureGenerator.setStructureConquered(mapX, mapY, mapZ, flag);
    }

    public boolean isStructureLocked(BlockPos pos, int lockIndex) {
        return this.majorFeatureGenerator.isStructureLocked(pos, lockIndex);
    }

    public boolean isBlockInStructureBB(BlockPos pos) {
        return this.majorFeatureGenerator.func_175795_b(pos);
    }

    public StructureBoundingBox getSBBAt(BlockPos pos) {
        return this.majorFeatureGenerator.getSBBAt(pos);
    }

    public boolean isBlockProtected(BlockPos pos) {
        return this.majorFeatureGenerator.isBlockProtectedAt(pos);
    }

    public boolean isStructureConquered(BlockPos pos) {
        return this.majorFeatureGenerator.isStructureConquered(pos);
    }

    public boolean isBlockInFullStructure(int x, int z) {
        return this.majorFeatureGenerator.isBlockInFullStructure(x, z);
    }

    public boolean isBlockNearFullStructure(int x, int z, int range) {
        return this.majorFeatureGenerator.isBlockNearFullStructure(x, z, range);
    }

    public StructureBoundingBox getFullSBBAt(int mapX, int mapZ) {
        return this.majorFeatureGenerator.getFullSBBAt(mapX, mapZ);
    }

    public StructureBoundingBox getFullSBBNear(int mapX, int mapZ, int range) {
        return this.majorFeatureGenerator.getFullSBBNear(mapX, mapZ, range);
    }

    public TFFeature getFeatureAt(BlockPos pos) {
        return this.majorFeatureGenerator.getFeatureAt(pos);
    }

    public void func_180514_a(Chunk chunk, int var1, int var2) {
        this.majorFeatureGenerator.func_186125_a(this.world, var1, var2, null);
        this.hollowTreeGenerator.func_186125_a(this.world, var1, var2, null);
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        TFFeature feature = TFFeature.getFeatureByName(new ResourceLocation(structureName));
        return structureName.equalsIgnoreCase(this.hollowTreeGenerator.func_143025_a()) ? this.hollowTreeGenerator.func_175795_b(pos) : feature != null && feature != TFFeature.nothing && this.getFeatureAt(pos) == feature;
    }
}

