/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import twilightforest.block.BlockTFLeaves;
import twilightforest.block.BlockTFLog;
import twilightforest.block.TFBlocks;
import twilightforest.block.enums.LeavesVariant;
import twilightforest.block.enums.WoodVariant;
import twilightforest.world.TFGenerator;
import twilightforest.world.TFTreeGenerator;

public class TFGenMangroveTree
extends TFTreeGenerator {
    private boolean checkForWater;
    private List<LeafBlob> leaves = Lists.newArrayList();

    public TFGenMangroveTree() {
        this(false);
    }

    public TFGenMangroveTree(boolean par1) {
        super(par1);
        this.checkForWater = !par1;
        this.treeState = TFBlocks.log.func_176223_P().func_177226_a(BlockTFLog.VARIANT, (Comparable)((Object)WoodVariant.MANGROVE));
        this.branchState = this.treeState.func_177226_a((IProperty)BlockTFLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        this.leafState = TFBlocks.leaves.func_176223_P().func_177226_a(BlockTFLeaves.VARIANT, (Comparable)((Object)LeavesVariant.MANGROVE)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        this.rootState = TFBlocks.root.func_176223_P();
    }

    protected void func_175903_a(World worldIn, BlockPos pos, IBlockState state) {
        if (this.func_150523_a(worldIn.func_180495_p(pos).func_177230_c())) {
            super.func_175903_a(worldIn, pos, state);
        }
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        if (this.checkForWater && world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150355_j || pos.func_177956_o() >= 109) {
            return false;
        }
        this.leaves.clear();
        this.buildBranch(world, random, pos, 5, 6 + random.nextInt(3), 0.0, 0.0, true);
        int numBranches = random.nextInt(3);
        double offset = random.nextDouble();
        for (int b = 0; b < numBranches; ++b) {
            this.buildBranch(world, random, pos, 7 + b, 6 + random.nextInt(2), 0.3 * (double)b + offset, 0.25, false);
        }
        for (LeafBlob blob : this.leaves) {
            this.makeLeafBlob(world, blob.pos, blob.size);
        }
        int numRoots = 3 + random.nextInt(2);
        offset = random.nextDouble();
        for (int i = 0; i < numRoots; ++i) {
            double rTilt = 0.75 + random.nextDouble() * 0.1;
            this.buildRoot(world, pos, 5, 12.0, 0.4 * (double)i + offset, rTilt);
        }
        this.addFirefly(world, pos, 5 + random.nextInt(5), random.nextDouble());
        return true;
    }

    private void makeLeafBlob(World world, BlockPos pos, int size) {
        TFGenerator.makeLeafCircle(this, world, pos.func_177977_b(), size - 1, this.leafState, false);
        TFGenerator.makeLeafCircle(this, world, pos, size, this.leafState, false);
        TFGenerator.makeLeafCircle(this, world, pos.func_177984_a(), size - 2, this.leafState, false);
    }

    private void buildBranch(World world, Random random, BlockPos pos, int height, double length, double angle, double tilt, boolean trunk) {
        int bSize;
        BlockPos src = pos.func_177981_b(height);
        BlockPos dest = TFGenerator.translate(src, length, angle, tilt);
        if (world.func_175697_a(dest, (bSize = 2 + random.nextInt(3)) + 1)) {
            TFGenerator.drawBresehnam(this, world, src, dest, trunk ? this.treeState : this.branchState);
            if (bSize > 2) {
                this.func_175903_a(world, dest.func_177974_f(), this.branchState);
                this.func_175903_a(world, dest.func_177976_e(), this.branchState);
                this.func_175903_a(world, dest.func_177968_d(), this.branchState);
                this.func_175903_a(world, dest.func_177978_c(), this.branchState);
            }
            this.leaves.add(new LeafBlob(dest, bSize));
        }
    }

    private void buildRoot(World world, BlockPos pos, int height, double length, double angle, double tilt) {
        BlockPos src = pos.func_177981_b(height);
        BlockPos dest = TFGenerator.translate(src, length, angle, tilt);
        if (world.func_175697_a(dest, 1)) {
            BlockPos[] lineArray = TFGenerator.getBresehnamArrays(src, dest);
            boolean stillAboveGround = true;
            for (BlockPos coord : lineArray) {
                if (stillAboveGround && TFGenerator.hasAirAround(world, coord)) {
                    this.func_175903_a(world, coord, this.branchState);
                    this.func_175903_a(world, coord.func_177977_b(), this.branchState);
                    continue;
                }
                this.placeRootBlock(world, coord, this.rootState);
                this.placeRootBlock(world, coord.func_177977_b(), this.rootState);
                stillAboveGround = false;
            }
        }
    }

    private class LeafBlob {
        BlockPos pos;
        int size;

        public LeafBlob(BlockPos pos, int size) {
            this.pos = pos;
            this.size = size;
        }
    }
}

