/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorLV;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityConnectorStructural
extends TileEntityConnectorLV
implements IEBlockInterfaces.IHammerInteraction,
IOBJModelCallback<IBlockState> {
    public float rotation = 0.0f;

    @Override
    protected boolean canTakeMV() {
        return false;
    }

    @Override
    protected boolean canTakeLV() {
        return false;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        this.rotation += player.func_70093_af() ? -22.5f : 22.5f;
        this.rotation %= 360.0f;
        this.func_70296_d();
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 254, 0);
        return true;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74776_a("rotation", this.rotation);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.rotation = nbt.func_74760_g("rotation");
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && this.field_145850_b != null) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        EnumFacing side = this.facing.func_176734_d();
        double conRadius = 0.03125;
        return new Vec3d(0.5 + (double)side.func_82601_c() * (-0.125 - conRadius), 0.5 + (double)side.func_96559_d() * (-0.125 - conRadius), 0.5 + (double)side.func_82599_e() * (-0.125 - conRadius));
    }

    @Override
    int getRenderRadiusIncrease() {
        return WireType.STRUCTURE_STEEL.getMaxLength();
    }

    @Override
    public int getMaxInput() {
        return 0;
    }

    @Override
    public int getMaxOutput() {
        return 0;
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        if (cableType != WireType.STRUCTURE_ROPE && cableType != WireType.STRUCTURE_STEEL) {
            return false;
        }
        return this.limitType == null || this.limitType == cableType;
    }

    @Override
    public boolean isEnergyOutput() {
        return false;
    }

    @Override
    public Optional<TRSRTransformation> applyTransformations(IBlockState object, String group, Optional<TRSRTransformation> transform) {
        Matrix4 mat = transform.isPresent() ? new Matrix4(transform.get().getMatrix()) : new Matrix4();
        mat = mat.translate(0.5, 0.0, 0.5).rotate(Math.toRadians(this.rotation), 0.0, 1.0, 0.0).translate(-0.5, 0.0, -0.5);
        transform = Optional.of(new TRSRTransformation(mat.toMatrix4f()));
        return transform;
    }

    @Override
    public String getCacheKey(IBlockState object) {
        return Float.toString(this.rotation);
    }
}

