/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.opencomputers;

import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBottlingMachine;
import blusunrize.immersiveengineering.common.util.compat.opencomputers.ManagedEnvironmentIE;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BottlingMachineDriver
extends DriverSidedTileEntity {
    public ManagedEnvironment createEnvironment(World w, BlockPos bp, EnumFacing facing) {
        TileEntityBottlingMachine ref;
        TileEntityBottlingMachine master;
        TileEntity te = w.func_175625_s(bp);
        if (te instanceof TileEntityBottlingMachine && (master = (TileEntityBottlingMachine)(ref = (TileEntityBottlingMachine)te).master()) != null && ref.isRedstonePos()) {
            return new BottlingMachineEnvironment(w, master.func_174877_v(), TileEntityBottlingMachine.class);
        }
        return null;
    }

    public Class<?> getTileEntityClass() {
        return TileEntityBottlingMachine.class;
    }

    public class BottlingMachineEnvironment
    extends ManagedEnvironmentIE<TileEntityBottlingMachine> {
        public BottlingMachineEnvironment(World w, BlockPos bp, Class<? extends TileEntityIEBase> teClass) {
            super(w, bp, teClass);
        }

        public void onConnect(Node node) {
            TileEntityBottlingMachine master = (TileEntityBottlingMachine)this.getTileEntity();
            if (master != null) {
                ++master.controllingComputers;
                master.computerOn = true;
            }
        }

        public void onDisconnect(Node node) {
            TileEntityBottlingMachine te = (TileEntityBottlingMachine)this.getTileEntity();
            if (te != null) {
                --te.controllingComputers;
            }
        }

        @Callback(doc="function():boolean -- checks whether the Bottling Machine is currently active")
        public Object[] isActive(Context context, Arguments args) {
            return new Object[]{((TileEntityBottlingMachine)this.getTileEntity()).shouldRenderAsActive()};
        }

        @Callback(doc="function(enable:boolean) -- enable or disable the Bottling Machine")
        public Object[] setEnabled(Context context, Arguments args) {
            ((TileEntityBottlingMachine)this.getTileEntity()).computerOn = args.checkBoolean(0);
            return null;
        }

        @Callback(doc="function():number -- get energy storage capacity")
        public Object[] getEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityBottlingMachine)this.getTileEntity()).energyStorage.getEnergyStored()};
        }

        @Callback(doc="function():number -- get currently stored energy")
        public Object[] getMaxEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityBottlingMachine)this.getTileEntity()).energyStorage.getMaxEnergyStored()};
        }

        @Callback(doc="function():table -- get tankinfo for fluid tank")
        public Object[] getTank(Context context, Arguments args) {
            return new Object[]{((TileEntityBottlingMachine)this.getTileEntity()).tanks[0].getInfo()};
        }

        public String preferredName() {
            return "ie_bottling_machine";
        }

        public int priority() {
            return 1000;
        }
    }
}

