/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.block;

import cofh.api.block.IDismantleable;
import cofh.core.block.BlockCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.CoreUtils;
import cofh.core.util.RayTracer;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.WrenchHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.block.ItemBlockGlassAlloy;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockGlassAlloy
extends BlockCore
implements IDismantleable,
IInitializer,
IModelRegister {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static ItemStack glassSteel;
    public static ItemStack glassElectrum;
    public static ItemStack glassInvar;
    public static ItemStack glassBronze;
    public static ItemStack glassConstantan;
    public static ItemStack glassSignalum;
    public static ItemStack glassLumium;
    public static ItemStack glassEnderium;

    public BlockGlassAlloy() {
        super(Material.field_151592_s, "thermalfoundation");
        this.func_149663_c("glass");
        this.func_149647_a(ThermalFoundation.tabCommon);
        this.func_149711_c(3.0f);
        this.func_149752_b(200.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.STEEL)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.METADATA_LOOKUP.length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getLight();
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_176201_c(state) == Type.SIGNALUM.getMetadata() ? 15 : 0;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_149744_f(IBlockState state) {
        return this.func_176201_c(state) == Type.SIGNALUM.getMetadata();
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        RayTraceResult traceResult;
        if (player.func_70093_af() && WrenchHelper.isHoldingUsableWrench((EntityPlayer)player, (RayTraceResult)(traceResult = RayTracer.retrace((EntityPlayer)player)))) {
            if (ServerHelper.isServerWorld((World)world)) {
                this.dismantleBlock(world, pos, state, player, false);
                WrenchHelper.usedWrench((EntityPlayer)player, (RayTraceResult)traceResult);
            }
            return true;
        }
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState offset = blockAccess.func_180495_p(pos.func_177972_a(side));
        return offset.func_177230_c() != this && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public float[] getBeaconColorMultiplier(IBlockState state, World world, BlockPos pos, BlockPos beaconPos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).beaconMult;
    }

    public ArrayList<ItemStack> dismantleBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, boolean returnDrops) {
        int metadata = this.func_176201_c(world.func_180495_p(pos));
        ItemStack dropBlock = new ItemStack((Block)this, 1, this.func_180651_a(state));
        world.func_175698_g(pos);
        if (!returnDrops) {
            float f = 0.3f;
            double x2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double y2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double z2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem dropEntity = new EntityItem(world, (double)pos.func_177958_n() + x2, (double)pos.func_177956_o() + y2, (double)pos.func_177952_p() + z2, dropBlock);
            dropEntity.func_174867_a(10);
            world.func_72838_d((Entity)dropEntity);
            CoreUtils.dismantleLog((String)player.func_70005_c_(), (Block)this, (int)metadata, (BlockPos)pos);
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(dropBlock);
        return ret;
    }

    public boolean canDismantle(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name + "_alloy", "type=" + Type.byMetadata(i).func_176610_l()));
        }
    }

    public boolean initialize() {
        this.setRegistryName("glass_alloy");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockGlassAlloy itemBlock = new ItemBlockGlassAlloy((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        glassSteel = new ItemStack((Block)this, 1, Type.STEEL.getMetadata());
        glassElectrum = new ItemStack((Block)this, 1, Type.ELECTRUM.getMetadata());
        glassInvar = new ItemStack((Block)this, 1, Type.INVAR.getMetadata());
        glassBronze = new ItemStack((Block)this, 1, Type.BRONZE.getMetadata());
        glassConstantan = new ItemStack((Block)this, 1, Type.CONSTANTAN.getMetadata());
        glassSignalum = new ItemStack((Block)this, 1, Type.SIGNALUM.getMetadata());
        glassLumium = new ItemStack((Block)this, 1, Type.LUMIUM.getMetadata());
        glassEnderium = new ItemStack((Block)this, 1, Type.ENDERIUM.getMetadata());
        OreDictionary.registerOre((String)"blockGlassHardened", (ItemStack)new ItemStack((Block)this, 1, Short.MAX_VALUE));
        ThermalFoundation.proxy.addIModelRegister(this);
        return true;
    }

    public boolean register() {
        return true;
    }

    public static enum Type implements IStringSerializable
    {
        STEEL(0, "steel", new float[]{0.478f, 0.478f, 0.478f}),
        ELECTRUM(1, "electrum", new float[]{0.82f, 0.761f, 0.365f}),
        INVAR(2, "invar", new float[]{0.58f, 0.616f, 0.6f}),
        BRONZE(3, "bronze", new float[]{0.808f, 0.557f, 0.267f}),
        CONSTANTAN(4, "constantan", new float[]{0.804f, 0.635f, 0.373f}),
        SIGNALUM(5, "signalum", 7, new float[]{0.788f, 0.345f, 0.133f}, EnumRarity.UNCOMMON),
        LUMIUM(6, "lumium", 15, new float[]{0.918f, 0.898f, 0.62f}, EnumRarity.UNCOMMON),
        ENDERIUM(7, "enderium", 4, new float[]{0.165f, 0.459f, 0.459f}, EnumRarity.RARE);

        private static final Type[] METADATA_LOOKUP;
        private final int metadata;
        private final String name;
        private final int light;
        private final float[] beaconMult;
        private final EnumRarity rarity;

        private Type(int metadata, String name, int light, float[] beaconMult, EnumRarity rarity) {
            this.metadata = metadata;
            this.name = name;
            this.light = light;
            this.beaconMult = beaconMult;
            this.rarity = rarity;
        }

        private Type(int metadata, String name, int light, float[] beaconMult) {
            this(metadata, name, light, beaconMult, EnumRarity.COMMON);
        }

        private Type(int metadata, String name, float[] beaconMult) {
            this(metadata, name, 0, beaconMult, EnumRarity.COMMON);
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return this.light;
        }

        public EnumRarity getRarity() {
            return this.rarity;
        }

        public static Type byMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }
            return METADATA_LOOKUP[metadata];
        }

        static {
            METADATA_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.METADATA_LOOKUP[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

