/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.block;

import cofh.core.block.BlockCore;
import cofh.core.fluid.BlockFluidCore;
import cofh.core.render.IModelRegister;
import cofh.core.render.particle.EntityDropParticleFX;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.block.ItemBlockOreFluid;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemMaterial;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockOreFluid
extends BlockCore
implements IInitializer,
IModelRegister {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    private BlockFluidCore[] fluidBlocks = new BlockFluidCore[Type.values().length];
    private ItemStack[] drops = new ItemStack[Type.values().length];
    public static ItemStack oreFluidCrudeOilSand;
    public static ItemStack oreFluidCrudeOilGravel;
    public static ItemStack oreFluidRedstone;
    public static ItemStack oreFluidGlowstone;
    public static ItemStack oreFluidEnder;

    public BlockOreFluid() {
        super(Material.field_151576_e, "thermalfoundation");
        this.func_149663_c("ore");
        this.func_149647_a(ThermalFoundation.tabCommon);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.CRUDE_OIL_SAND)));
        this.setHarvestLevel("pickaxe", 1);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.METADATA_LOOKUP.length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getLight();
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos north = pos.func_177982_a(0, 0, -1);
        BlockPos south = pos.func_177982_a(0, 0, 1);
        BlockPos west = pos.func_177982_a(-1, 0, 0);
        BlockPos east = pos.func_177982_a(1, 0, 0);
        if (world.func_175623_d(north)) {
            world.func_180501_a(north, this.fluidBlocks[((Type)((Object)state.func_177229_b(VARIANT))).getMetadata()].func_176223_P().func_177226_a((IProperty)BlockFluidCore.LEVEL, (Comparable)Integer.valueOf(1)), 3);
        }
        if (world.func_175623_d(south)) {
            world.func_180501_a(south, this.fluidBlocks[((Type)((Object)state.func_177229_b(VARIANT))).getMetadata()].func_176223_P().func_177226_a((IProperty)BlockFluidCore.LEVEL, (Comparable)Integer.valueOf(1)), 3);
        }
        if (world.func_175623_d(west)) {
            world.func_180501_a(west, this.fluidBlocks[((Type)((Object)state.func_177229_b(VARIANT))).getMetadata()].func_176223_P().func_177226_a((IProperty)BlockFluidCore.LEVEL, (Comparable)Integer.valueOf(1)), 3);
        }
        if (world.func_175623_d(east)) {
            world.func_180501_a(east, this.fluidBlocks[((Type)((Object)state.func_177229_b(VARIANT))).getMetadata()].func_176223_P().func_177226_a((IProperty)BlockFluidCore.LEVEL, (Comparable)Integer.valueOf(1)), 3);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        return world.func_180501_a(new BlockPos((Vec3i)pos), this.fluidBlocks[((Type)((Object)state.func_177229_b(VARIANT))).getMetadata()].func_176223_P().func_177226_a((IProperty)BlockFluidCore.LEVEL, (Comparable)Integer.valueOf(1)), world.field_72995_K ? 11 : 3);
    }

    public boolean func_149744_f(IBlockState state) {
        return this.func_176201_c(state) == Type.REDSTONE.getMetadata();
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.func_176201_c(world.func_180495_p(pos)) <= Type.CRUDE_OIL_GRAVEL.getMetadata();
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing face) {
        return this.func_176201_c(world.func_180495_p(pos)) <= Type.CRUDE_OIL_GRAVEL.getMetadata();
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        int metadata = this.func_176201_c(state);
        if (metadata >= Type.values().length) {
            return 0;
        }
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        switch (Type.values()[metadata]) {
            case CRUDE_OIL_SAND: {
                return MathHelper.func_76136_a((Random)rand, (int)0, (int)2);
            }
            case CRUDE_OIL_GRAVEL: {
                return MathHelper.func_76136_a((Random)rand, (int)0, (int)2);
            }
            case REDSTONE: {
                return MathHelper.func_76136_a((Random)rand, (int)1, (int)5);
            }
            case GLOWSTONE: {
                return MathHelper.func_76136_a((Random)rand, (int)2, (int)5);
            }
            case ENDER: {
                return MathHelper.func_76136_a((Random)rand, (int)3, (int)7);
            }
        }
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.func_176201_c(world.func_180495_p(pos)) <= Type.CRUDE_OIL_GRAVEL.getMetadata() ? 15 : 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.func_176201_c(world.func_180495_p(pos)) <= Type.CRUDE_OIL_GRAVEL.getMetadata() ? 1 : 0;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_176201_c(state) == Type.REDSTONE.getMetadata() ? 7 : 0;
    }

    public int quantityDropped(IBlockState state, int fortune, Random rand) {
        return 1 + rand.nextInt(fortune + 1);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(ItemHelper.cloneStack((ItemStack)this.drops[this.func_180651_a(state)], (int)this.quantityDropped(state, fortune, world instanceof World ? ((World)world).field_73012_v : RANDOM)));
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        double px = (float)pos.func_177958_n() + rand.nextFloat();
        double py = (double)pos.func_177956_o() - 0.05;
        double pz = (float)pos.func_177952_p() + rand.nextFloat();
        BlockFluidCore fluid = this.fluidBlocks[((Type)((Object)state.func_177229_b(VARIANT))).getMetadata()];
        int density = fluid.getDensity();
        int densityDir = fluid.getDensityDir();
        if (density < 0) {
            py = (double)pos.func_177956_o() + 1.1;
        }
        if (rand.nextInt(20) == 0 && !world.isSideSolid(pos.func_177982_a(0, densityDir, 0), densityDir == -1 ? EnumFacing.UP : EnumFacing.DOWN) && !world.func_180495_p(pos.func_177982_a(0, densityDir, 0)).func_185904_a().func_76230_c()) {
            EntityDropParticleFX fx = new EntityDropParticleFX(world, px, py, pz, fluid.getParticleRed(), fluid.getParticleGreen(), fluid.getParticleBlue(), densityDir);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name + "_fluid", "type=" + Type.byMetadata(i).func_176610_l()));
        }
    }

    public boolean initialize() {
        this.setRegistryName("ore_fluid");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockOreFluid itemBlock = new ItemBlockOreFluid((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        oreFluidCrudeOilSand = new ItemStack((Block)this, 1, Type.CRUDE_OIL_SAND.getMetadata());
        oreFluidCrudeOilGravel = new ItemStack((Block)this, 1, Type.CRUDE_OIL_GRAVEL.getMetadata());
        oreFluidRedstone = new ItemStack((Block)this, 1, Type.REDSTONE.getMetadata());
        oreFluidGlowstone = new ItemStack((Block)this, 1, Type.GLOWSTONE.getMetadata());
        oreFluidEnder = new ItemStack((Block)this, 1, Type.ENDER.getMetadata());
        ItemHelper.registerWithHandlers((String)"oreFluidCrudeOilSand", (ItemStack)oreFluidCrudeOilSand);
        ItemHelper.registerWithHandlers((String)"oreFluidCrudeOilShale", (ItemStack)oreFluidCrudeOilGravel);
        ItemHelper.registerWithHandlers((String)"oreFluidRedstone", (ItemStack)oreFluidRedstone);
        ItemHelper.registerWithHandlers((String)"oreFluidGlowstone", (ItemStack)oreFluidGlowstone);
        ItemHelper.registerWithHandlers((String)"oreFluidEnder", (ItemStack)oreFluidEnder);
        ThermalFoundation.proxy.addIModelRegister(this);
        return true;
    }

    public boolean register() {
        this.fluidBlocks[Type.CRUDE_OIL_SAND.getMetadata()] = TFFluids.blockFluidCrudeOil;
        this.fluidBlocks[Type.CRUDE_OIL_GRAVEL.getMetadata()] = TFFluids.blockFluidCrudeOil;
        this.fluidBlocks[Type.REDSTONE.getMetadata()] = TFFluids.blockFluidRedstone;
        this.fluidBlocks[Type.GLOWSTONE.getMetadata()] = TFFluids.blockFluidGlowstone;
        this.fluidBlocks[Type.ENDER.getMetadata()] = TFFluids.blockFluidEnder;
        this.drops[Type.CRUDE_OIL_SAND.getMetadata()] = ItemMaterial.crystalCrudeOil;
        this.drops[Type.CRUDE_OIL_GRAVEL.getMetadata()] = ItemMaterial.crystalCrudeOil;
        this.drops[Type.REDSTONE.getMetadata()] = ItemMaterial.crystalRedstone;
        this.drops[Type.GLOWSTONE.getMetadata()] = ItemMaterial.crystalGlowstone;
        this.drops[Type.ENDER.getMetadata()] = ItemMaterial.crystalEnder;
        return true;
    }

    public static enum Type implements IStringSerializable
    {
        CRUDE_OIL_SAND(0, "crude_oil_sand", TFFluids.blockFluidCrudeOil),
        CRUDE_OIL_GRAVEL(1, "crude_oil_gravel", TFFluids.blockFluidCrudeOil),
        REDSTONE(2, "redstone", TFFluids.blockFluidRedstone, 7, EnumRarity.UNCOMMON),
        GLOWSTONE(3, "glowstone", TFFluids.blockFluidGlowstone, 15, EnumRarity.UNCOMMON),
        ENDER(4, "ender", TFFluids.blockFluidEnder, 3, EnumRarity.RARE);

        private static final Type[] METADATA_LOOKUP;
        private final int metadata;
        private final String name;
        private final int light;
        private final EnumRarity rarity;

        private Type(int metadata, String name, BlockFluidCore fluid, int light, EnumRarity rarity) {
            this.metadata = metadata;
            this.name = name;
            this.light = light;
            this.rarity = rarity;
        }

        private Type(int metadata, String name, BlockFluidCore fluid, int light) {
            this(metadata, name, fluid, light, EnumRarity.COMMON);
        }

        private Type(int metadata, String name, BlockFluidCore fluid) {
            this(metadata, name, fluid, 0, EnumRarity.COMMON);
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return this.light;
        }

        public EnumRarity getRarity() {
            return this.rarity;
        }

        public static Type byMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }
            return METADATA_LOOKUP[metadata];
        }

        static {
            METADATA_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.METADATA_LOOKUP[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

