/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.block;

import cofh.core.block.BlockCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.RecipeHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.block.ItemBlockRockwool;
import cofh.thermalfoundation.item.ItemMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockRockwool
extends BlockCore
implements IInitializer,
IModelRegister {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static ItemStack rockwoolBlack;
    public static ItemStack rockwoolRed;
    public static ItemStack rockwoolGreen;
    public static ItemStack rockwoolBrown;
    public static ItemStack rockwoolBlue;
    public static ItemStack rockwoolPurple;
    public static ItemStack rockwoolCyan;
    public static ItemStack rockwoolSilver;
    public static ItemStack rockwoolGray;
    public static ItemStack rockwoolPink;
    public static ItemStack rockwoolLime;
    public static ItemStack rockwoolYellow;
    public static ItemStack rockwoolLightBlue;
    public static ItemStack rockwoolMagenta;
    public static ItemStack rockwoolOrange;
    public static ItemStack rockwoolWhite;

    public BlockRockwool() {
        super(Material.field_151576_e, "thermalfoundation");
        this.func_149663_c("rockwool");
        this.func_149647_a(ThermalFoundation.tabCommon);
        this.func_149711_c(0.8f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.GRAY)));
        this.setHarvestLevel("pickaxe", 1);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.METADATA_LOOKUP.length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name, "type=" + Type.byMetadata(i).func_176610_l()));
        }
    }

    public boolean initialize() {
        this.setRegistryName("rockwool");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockRockwool itemBlock = new ItemBlockRockwool((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        rockwoolBlack = new ItemStack((Block)this, 1, Type.BLACK.getMetadata());
        rockwoolRed = new ItemStack((Block)this, 1, Type.RED.getMetadata());
        rockwoolGreen = new ItemStack((Block)this, 1, Type.GREEN.getMetadata());
        rockwoolBrown = new ItemStack((Block)this, 1, Type.BROWN.getMetadata());
        rockwoolBlue = new ItemStack((Block)this, 1, Type.BLUE.getMetadata());
        rockwoolPurple = new ItemStack((Block)this, 1, Type.PURPLE.getMetadata());
        rockwoolCyan = new ItemStack((Block)this, 1, Type.CYAN.getMetadata());
        rockwoolSilver = new ItemStack((Block)this, 1, Type.SILVER.getMetadata());
        rockwoolGray = new ItemStack((Block)this, 1, Type.GRAY.getMetadata());
        rockwoolPink = new ItemStack((Block)this, 1, Type.PINK.getMetadata());
        rockwoolLime = new ItemStack((Block)this, 1, Type.LIME.getMetadata());
        rockwoolYellow = new ItemStack((Block)this, 1, Type.YELLOW.getMetadata());
        rockwoolLightBlue = new ItemStack((Block)this, 1, Type.LIGHT_BLUE.getMetadata());
        rockwoolMagenta = new ItemStack((Block)this, 1, Type.MAGENTA.getMetadata());
        rockwoolOrange = new ItemStack((Block)this, 1, Type.ORANGE.getMetadata());
        rockwoolWhite = new ItemStack((Block)this, 1, Type.WHITE.getMetadata());
        OreDictionary.registerOre((String)"blockRockwool", (ItemStack)new ItemStack((Block)this, 1, Short.MAX_VALUE));
        ThermalFoundation.proxy.addIModelRegister(this);
        return true;
    }

    public boolean register() {
        RecipeHelper.addSmelting((ItemStack)ItemMaterial.crystalSlag, (ItemStack)rockwoolSilver, (float)0.1f);
        for (int i = 0; i < 16; ++i) {
            RecipeHelper.addShapelessRecipe((ItemStack)new ItemStack((Block)this, 1, i), (Object[])new Object[]{new ItemStack((Block)this, 1, Short.MAX_VALUE), new ItemStack(Items.field_151100_aR, 1, i)});
        }
        return true;
    }

    public static enum Type implements IStringSerializable
    {
        BLACK(0, "black"),
        RED(1, "red"),
        GREEN(2, "green"),
        BROWN(3, "brown"),
        BLUE(4, "blue"),
        PURPLE(5, "purple"),
        CYAN(6, "cyan"),
        SILVER(7, "silver"),
        GRAY(8, "gray"),
        PINK(9, "pink"),
        LIME(10, "lime"),
        YELLOW(11, "yellow"),
        LIGHT_BLUE(12, "light_blue"),
        MAGENTA(13, "magenta"),
        ORANGE(14, "orange"),
        WHITE(15, "white");

        private static final Type[] METADATA_LOOKUP;
        private final int metadata;
        private final String name;

        private Type(int metadata, String name) {
            this.metadata = metadata;
            this.name = name;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static Type byMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }
            return METADATA_LOOKUP[metadata];
        }

        static {
            METADATA_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.METADATA_LOOKUP[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

