/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.fluid;

import cofh.core.fluid.BlockFluidInteractive;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockFluidPetrotheum
extends BlockFluidInteractive {
    public static final int LEVELS = 6;
    public static final Material materialFluidPetrotheum = new MaterialLiquid(MapColor.field_151665_m);
    private static boolean enableSourceFall = true;
    private static boolean effect = true;
    private static boolean extreme = false;

    public BlockFluidPetrotheum(Fluid fluid) {
        super(fluid, materialFluidPetrotheum, "thermalfoundation", "petrotheum");
        this.setQuantaPerBlock(6);
        this.setTickRate(10);
        this.func_149711_c(1000.0f);
        this.func_149713_g(1);
        this.setParticleColor(0.4f, 0.3f, 0.2f);
    }

    public static void config() {
        String category = "Fluid.Petrotheum";
        String comment = "If TRUE, Fluid Petrotheum will break apart stone blocks.";
        effect = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Effect", category, effect, comment);
        comment = "If TRUE, Fluid Petrotheum will have an EXTREME effect on stone blocks. Fun but not recommended.";
        extreme = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Extreme", category, extreme, comment);
        comment = "If TRUE, Fluid Petrotheum Source blocks will gradually fall downwards.";
        enableSourceFall = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Fall", category, enableSourceFall, comment);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!effect) {
            return;
        }
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        if (world.func_82737_E() % 8L != 0L) {
            return;
        }
        if (world.func_82737_E() % 8L == 0L && entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_70662_br()) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76422_e, 120, 0));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76439_r, 120, 0));
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return TFFluids.fluidPetrotheum.getLuminosity();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (effect) {
            this.checkForInteraction(world, pos);
        }
        if (enableSourceFall && state.func_177230_c().func_176201_c(state) == 0) {
            BlockPos offsetPos = pos.func_177982_a(0, this.densityDir, 0);
            IBlockState offsetState = world.func_180495_p(offsetPos);
            int bMeta = offsetState.func_177230_c().func_176201_c(offsetState);
            if (offsetState.func_177230_c() == this && bMeta != 0) {
                world.func_180501_a(offsetPos, this.func_176223_P(), 3);
                world.func_175698_g(pos);
                return;
            }
        }
        super.func_180650_b(world, pos, state, rand);
    }

    protected void checkForInteraction(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return;
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            this.interactWithBlock(world, pos.func_177972_a(face));
        }
    }

    protected void interactWithBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c() == this) {
            return;
        }
        if (extreme && state.func_185904_a() == Material.field_151576_e && state.func_177230_c().func_176195_g(state, world, pos) > 0.0f) {
            state.func_177230_c().func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            this.triggerInteractionEffects(world, pos);
        } else if (this.hasInteraction(state)) {
            world.func_180501_a(pos, this.getInteraction(state), 3);
        }
    }

    protected void triggerInteractionEffects(World world, BlockPos pos) {
        world.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187835_fT, SoundCategory.BLOCKS, 0.5f, 0.9f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f, false);
    }

    public void addInteractions() {
        this.addInteraction(Blocks.field_150348_b, Blocks.field_150351_n);
        this.addInteraction(Blocks.field_150347_e, Blocks.field_150351_n);
        this.addInteraction(Blocks.field_150417_aV, Blocks.field_150351_n);
        this.addInteraction(Blocks.field_150341_Y, Blocks.field_150351_n);
    }

    public boolean initialize() {
        this.setRegistryName("fluid_petrotheum");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlock itemBlock = new ItemBlock((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        BlockFluidPetrotheum.config();
        this.addInteractions();
        return true;
    }
}

