/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.item.tome;

import cofh.api.item.IMultiModeItem;
import cofh.core.item.ItemCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.StateMapper;
import cofh.core.util.core.IInitializer;
import cofh.thermalfoundation.ThermalFoundation;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemTome
extends ItemCore
implements IInitializer,
IModelRegister,
IMultiModeItem {
    public ItemTome() {
        super("thermalfoundation");
        this.func_77625_d(1);
        this.func_77637_a(ThermalFoundation.tabUtils);
    }

    protected boolean isEmpowered(ItemStack stack) {
        return this.getMode(stack) == 1;
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (this.isEmpowered(stack)) {
            return EnumRarity.RARE;
        }
        return EnumRarity.UNCOMMON;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.FAIL;
    }

    public Item func_77655_b(String name) {
        this.name = name;
        ForgeRegistries.ITEMS.register(this.setRegistryName("tome_" + this.name));
        return super.func_77655_b(this.modName + ".tome." + name);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMapper mapper = new StateMapper(this.modName, "util", this.name);
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)mapper);
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + "util", "type=" + this.name));
    }

    public int getMode(ItemStack stack) {
        return !stack.func_77942_o() ? 0 : stack.func_77978_p().func_74762_e("Mode");
    }

    public boolean setMode(ItemStack stack, int mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("Mode", mode);
        return false;
    }

    public boolean incrMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int curMode = this.getMode(stack);
        if (++curMode >= this.getNumModes(stack)) {
            curMode = 0;
        }
        stack.func_77978_p().func_74768_a("Mode", curMode);
        return true;
    }

    public boolean decrMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int curMode = this.getMode(stack);
        if (--curMode <= 0) {
            curMode = this.getNumModes(stack) - 1;
        }
        stack.func_77978_p().func_74768_a("Mode", curMode);
        return true;
    }

    public int getNumModes(ItemStack stack) {
        return 2;
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        if (this.isEmpowered(stack)) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187754_de, SoundCategory.PLAYERS, 0.4f, 1.0f);
        } else {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.6f);
        }
    }
}

