/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.item.tome;

import cofh.api.fluid.IFluidContainerItem;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.util.CoreUtils;
import cofh.core.util.capabilities.FluidContainerItemWrapper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.tome.ItemTome;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;

public class ItemTomeExperience
extends ItemTome
implements IFluidContainerItem,
IEnchantableItem {
    public static final int CAPACITY = 10000;
    public static ItemStack tomeExperience;

    public ItemTomeExperience() {
        this.func_77655_b("experience");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.thermalfoundation.tome.experience.a.0"));
        tooltip.add(StringHelper.localize((String)"info.thermalfoundation.tome.experience.a.1"));
        tooltip.add(StringHelper.getNoticeText((String)"info.thermalfoundation.tome.experience.a.2"));
        if (this.isEmpowered(stack)) {
            tooltip.add(StringHelper.localizeFormat((String)"info.thermalfoundation.tome.experience.c.0", (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        } else {
            tooltip.add(StringHelper.localizeFormat((String)"info.thermalfoundation.tome.experience.b.0", (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        }
        tooltip.add(StringHelper.localize((String)"info.cofh.experience") + ": " + StringHelper.formatNumber((long)ItemTomeExperience.getExperience(stack)) + " / " + StringHelper.formatNumber((long)ItemTomeExperience.getMaxExperience(stack)));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrentItem) {
        if (!this.isEmpowered(stack)) {
            return;
        }
        NBTTagCompound tag = entity.getEntityData();
        tag.func_74772_a("thermalfoundation.experience_timer", entity.field_70170_p.func_82737_E());
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags((ItemStack)oldStack, (ItemStack)newStack, (String[])new String[]{"Experience"}));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 10;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 8039506;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return 1.0 - (double)ItemTomeExperience.getExperience(stack) / (double)ItemTomeExperience.getMaxExperience(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (CoreUtils.isFakePlayer((Entity)player) || hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        int exp = ItemTomeExperience.getExperience(stack);
        if (player.func_70093_af()) {
            if (exp >= player.func_71050_bK()) {
                ItemTomeExperience.modifyExperience(stack, -player.func_71050_bK());
                ++player.field_71068_ca;
            } else if (exp > 0) {
                ItemTomeExperience.modifyExperience(stack, -exp);
                ItemTomeExperience.addExperienceToPlayer(player, exp);
            }
        } else if (player.field_71068_ca > 0 && exp < ItemTomeExperience.getMaxExperience(stack)) {
            --player.field_71068_ca;
            ItemTomeExperience.modifyExperience(stack, player.func_71050_bK());
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public static int getExperience(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p().func_74762_e("Experience");
    }

    public static int getMaxExperience(ItemStack stack) {
        return 10000 + 10000 * EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack) / 2;
    }

    public static int modifyExperience(ItemStack stack, int exp) {
        int storedExp = ItemTomeExperience.getExperience(stack) + exp;
        if (storedExp > ItemTomeExperience.getMaxExperience(stack)) {
            storedExp = ItemTomeExperience.getMaxExperience(stack);
        } else if (storedExp < 0) {
            storedExp = 0;
        }
        stack.func_77978_p().func_74768_a("Experience", storedExp);
        return storedExp;
    }

    public static void addExperienceToPlayer(EntityPlayer player, int exp) {
        int i = Integer.MAX_VALUE - player.field_71067_cb;
        if (exp > i) {
            exp = i;
        }
        player.field_71106_cc += (float)exp / (float)player.func_71050_bK();
        player.field_71067_cb += exp;
        while (player.field_71106_cc >= 1.0f) {
            player.field_71106_cc = (player.field_71106_cc - 1.0f) * (float)player.func_71050_bK();
            player.func_82242_a(1);
            player.field_71106_cc /= (float)player.func_71050_bK();
        }
    }

    public FluidStack getFluid(ItemStack container) {
        int experience = ItemTomeExperience.getExperience(container);
        return experience > 0 ? new FluidStack(TFFluids.fluidExperience, experience * 20) : null;
    }

    public int getCapacity(ItemStack container) {
        return ItemTomeExperience.getMaxExperience(container) * 20;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() != TFFluids.fluidExperience) {
            return 0;
        }
        int experience = ItemTomeExperience.getExperience(container);
        int filled = Math.min(ItemTomeExperience.getMaxExperience(container) - experience, resource.amount / 20);
        if (doFill) {
            ItemTomeExperience.modifyExperience(container, filled);
        }
        return filled * 20;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        int experience = ItemTomeExperience.getExperience(container);
        if (experience <= 0) {
            return null;
        }
        int drained = Math.min(experience, maxDrain / 20);
        if (doDrain) {
            ItemTomeExperience.modifyExperience(container, -drained);
        }
        return new FluidStack(TFFluids.fluidExperience, drained * 20);
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.holding;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidContainerItemWrapper(stack, (IFluidContainerItem)this, false, true);
    }

    public boolean initialize() {
        tomeExperience = new ItemStack((Item)this);
        ThermalFoundation.proxy.addIModelRegister(this);
        return true;
    }

    public boolean register() {
        RecipeHelper.addShapedRecipe((ItemStack)tomeExperience, (Object[])new Object[]{" L ", "EBE", " L ", Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('E'), "gemEmerald", Character.valueOf('L'), "gemLapis"});
        return true;
    }
}

