/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.network;

import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.gui.container.ContainerLexiconStudy;
import cofh.thermalfoundation.gui.container.ContainerLexiconTransmute;
import net.minecraft.entity.player.EntityPlayer;

public class PacketTFBase
extends PacketCoFHBase {
    public static void initialize() {
        PacketHandler.INSTANCE.registerPacket(PacketTFBase.class);
    }

    public void handlePacket(EntityPlayer player, boolean isServer) {
        try {
            byte type = this.getByte();
            switch (PacketTypes.values()[type]) {
                case LEXICON_STUDY: {
                    if (player.field_71070_bA instanceof ContainerLexiconStudy) {
                        ((ContainerLexiconStudy)player.field_71070_bA).handlePacket(this);
                    }
                    return;
                }
                case LEXICON_TRANSMUTE: {
                    if (player.field_71070_bA instanceof ContainerLexiconTransmute) {
                        ((ContainerLexiconTransmute)player.field_71070_bA).handlePacket(this);
                    }
                    return;
                }
            }
            ThermalFoundation.LOG.error("Unknown Packet! Internal: TFPH, ID: " + type);
        }
        catch (Exception e) {
            ThermalFoundation.LOG.error("Packet payload failure! Please check your config files!");
            e.printStackTrace();
        }
    }

    public static PacketCoFHBase getPacket(PacketTypes theType) {
        return new PacketTFBase().addByte(theType.ordinal());
    }

    public static void sendLexiconStudyPacketToServer(int command) {
        PacketHandler.sendToServer((PacketBase)PacketTFBase.getPacket(PacketTypes.LEXICON_STUDY).addByte(command));
    }

    public static void sendLexiconStudySelectPacketToServer(int command, String oreName) {
        PacketHandler.sendToServer((PacketBase)PacketTFBase.getPacket(PacketTypes.LEXICON_STUDY).addByte(command).addString(oreName));
    }

    public static void sendLexiconTransmutePacketToServer(int command) {
        PacketHandler.sendToServer((PacketBase)PacketTFBase.getPacket(PacketTypes.LEXICON_TRANSMUTE).addByte(command));
    }

    public static enum PacketTypes {
        CONFIG_SYNC,
        LEXICON_STUDY,
        LEXICON_TRANSMUTE;

    }
}

