/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.proxy;

import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.thermalfoundation.init.TFProps;
import cofh.thermalfoundation.item.ItemMaterial;
import cofh.thermalfoundation.item.tome.ItemTomeExperience;
import cofh.thermalfoundation.util.LexiconManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandler {
    public static final EventHandler INSTANCE = new EventHandler();

    @SubscribeEvent
    public void handleLivingDropsEvent(LivingDropsEvent event) {
        Entity entity = event.getEntity();
        if (entity.func_70045_F() && TFProps.dropSulfurFireImmuneMobs && event.getEntityLiving().field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            boolean s = entity instanceof EntitySlime;
            if (event.getEntityLiving().func_70681_au().nextInt(6 + (s ? 16 : 0)) != 0) {
                return;
            }
            event.getDrops().add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ItemMaterial.dustSulfur.func_77946_l()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handleEntityItemPickupEvent(EntityItemPickupEvent event) {
        ItemStack stack = event.getItem().func_92059_d();
        if (stack.func_190926_b() || !LexiconManager.validOre(stack)) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        NBTTagCompound tag = player.getEntityData();
        if (player.field_70170_p.func_82737_E() - tag.func_74763_f("thermalfoundation.lexicon_timer") > 20L) {
            return;
        }
        ItemStack lexiconStack = LexiconManager.getPreferredStack(player, stack);
        if (!player.field_71071_by.func_70441_a(lexiconStack)) {
            stack.func_190920_e(lexiconStack.func_190916_E());
            event.getItem().func_92058_a(stack);
            return;
        }
        stack.func_190920_e(0);
        FMLCommonHandler.instance().firePlayerItemPickupEvent(player, event.getItem());
        if (stack.func_190916_E() <= 0) {
            event.getItem().func_70106_y();
        }
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handlePlayerCloneEvent(PlayerEvent.Clone event) {
        NBTTagCompound newTag = event.getEntityPlayer().getEntityData();
        NBTTagCompound oldTag = event.getOriginal().getEntityData();
        if (oldTag.func_74764_b("thermalfoundation.lexicon_data")) {
            newTag.func_74782_a("thermalfoundation.lexicon_data", (NBTBase)oldTag.func_74775_l("thermalfoundation.lexicon_data"));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void handlePlayerPickupXpEvent(PlayerPickupXpEvent event) {
        if (event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        NBTTagCompound tag = player.getEntityData();
        if (player.field_70170_p.func_82737_E() - tag.func_74763_f("thermalfoundation.experience_timer") > 20L) {
            return;
        }
        ItemStack tome = this.findExpTome(player);
        if (tome.func_190926_b()) {
            return;
        }
        EntityXPOrb orb = event.getOrb();
        ItemTomeExperience.modifyExperience(tome, orb.field_70530_e);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, (MathHelper.RANDOM.nextFloat() - MathHelper.RANDOM.nextFloat()) * 0.35f + 0.9f);
        orb.func_70106_y();
        event.setCanceled(true);
    }

    public ItemStack findExpTome(EntityPlayer player) {
        ItemStack offHand = player.func_184592_cb();
        ItemStack mainHand = player.func_184614_ca();
        if (ItemHelper.itemsEqualWithMetadata((ItemStack)offHand, (ItemStack)ItemTomeExperience.tomeExperience) && ItemTomeExperience.getExperience(offHand) < ItemTomeExperience.getMaxExperience(offHand)) {
            return offHand;
        }
        if (ItemHelper.itemsEqualWithMetadata((ItemStack)mainHand, (ItemStack)ItemTomeExperience.tomeExperience) && ItemTomeExperience.getExperience(mainHand) < ItemTomeExperience.getMaxExperience(mainHand)) {
            return mainHand;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!ItemHelper.itemsEqualWithMetadata((ItemStack)stack, (ItemStack)ItemTomeExperience.tomeExperience) || ItemTomeExperience.getExperience(stack) >= ItemTomeExperience.getMaxExperience(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }
}

