/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.util;

import cofh.core.init.CorePotions;
import cofh.core.util.crafting.FluidIngredientFactory;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.init.TFEquipment;
import cofh.thermalfoundation.init.TFProps;
import cofh.thermalfoundation.item.ItemMaterial;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class TFCrafting {
    public static void loadRecipes() {
        String[] oreNameList;
        RecipeHelper.addSmelting((ItemStack)ItemMaterial.dustWoodCompressed, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        RecipeHelper.addStorageRecipe((ItemStack)ItemMaterial.dustWoodCompressed, (String)"dustWood");
        RecipeHelper.addShapelessOreRecipe((ItemStack)new ItemStack(Items.field_151016_H), (Object[])new Object[]{"dustCoal", "dustSulfur", "dustSaltpeter", "dustSaltpeter"});
        RecipeHelper.addShapelessOreRecipe((ItemStack)new ItemStack(Items.field_151016_H), (Object[])new Object[]{"dustCharcoal", "dustSulfur", "dustSaltpeter", "dustSaltpeter"});
        RecipeHelper.addShapedRecipe((ItemStack)new ItemStack(Blocks.field_150478_aa, 4), (Object[])new Object[]{"X", "#", Character.valueOf('X'), ItemMaterial.globRosin, Character.valueOf('#'), "string"});
        RecipeHelper.addShapedRecipe((ItemStack)new ItemStack((Block)Blocks.field_150320_F, 1), (Object[])new Object[]{"S", "P", Character.valueOf('S'), ItemMaterial.globRosin, Character.valueOf('P'), Blocks.field_150331_J});
        RecipeHelper.addShapedRecipe((ItemStack)new ItemStack(Items.field_151058_ca, 2), (Object[])new Object[]{"~~ ", "~O ", "  ~", Character.valueOf('~'), "string", Character.valueOf('O'), ItemMaterial.globRosin});
        RecipeHelper.addShapedRecipe((ItemStack)new ItemStack(Blocks.field_150478_aa, 4), (Object[])new Object[]{"X", "#", Character.valueOf('X'), ItemMaterial.globTar, Character.valueOf('#'), "string"});
        RecipeHelper.addShapedRecipe((ItemStack)new ItemStack((Block)Blocks.field_150320_F, 1), (Object[])new Object[]{"S", "P", Character.valueOf('S'), ItemMaterial.globTar, Character.valueOf('P'), Blocks.field_150331_J});
        RecipeHelper.addShapedRecipe((ItemStack)new ItemStack(Items.field_151058_ca, 2), (Object[])new Object[]{"~~ ", "~O ", "  ~", Character.valueOf('~'), "string", Character.valueOf('O'), ItemMaterial.globTar});
        for (String oreName : oreNameList = OreDictionary.getOreNames()) {
            if (oreName.length() <= 3 || !oreName.startsWith("ore")) continue;
            String dustName = "dust" + StringHelper.titleCase((String)oreName.substring(3, oreName.length()));
            String ingotName = "ingot" + StringHelper.titleCase((String)oreName.substring(3, oreName.length()));
            String gemName = "gem" + StringHelper.titleCase((String)oreName.substring(3, oreName.length()));
            NonNullList registeredOre = OreDictionary.getOres((String)oreName, (boolean)false);
            NonNullList registeredDust = OreDictionary.getOres((String)dustName, (boolean)false);
            NonNullList registeredIngot = OreDictionary.getOres((String)ingotName, (boolean)false);
            NonNullList registeredGem = OreDictionary.getOres((String)gemName, (boolean)false);
            if (registeredOre.isEmpty()) continue;
            if (TFProps.enablePetrotheumCrafting && !registeredDust.isEmpty()) {
                RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)((ItemStack)registeredDust.get(0)), (int)2), (Object[])new Object[]{oreName, "dustPetrotheum"});
                if (!registeredIngot.isEmpty()) {
                    RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)((ItemStack)registeredDust.get(0)), (int)1), (Object[])new Object[]{ingotName, "dustPetrotheum"});
                }
            }
            if (TFProps.enablePetrotheumCrafting && !registeredGem.isEmpty()) {
                RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)((ItemStack)registeredGem.get(0)), (int)2), (Object[])new Object[]{oreName, "dustPetrotheum"});
            }
            if (TFProps.enablePyrotheumCrafting && !registeredIngot.isEmpty()) {
                RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)((ItemStack)registeredIngot.get(0)), (int)1), (Object[])new Object[]{oreName, "dustPyrotheum"});
                if (!registeredDust.isEmpty()) {
                    RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)((ItemStack)registeredIngot.get(0)), (int)1), (Object[])new Object[]{dustName, "dustPyrotheum"});
                }
            }
            if (!TFProps.enablePetrotheumCrafting || !TFProps.enablePyrotheumCrafting || registeredDust.isEmpty() || registeredIngot.isEmpty()) continue;
            RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)((ItemStack)registeredIngot.get(0)), (int)2), (Object[])new Object[]{oreName, "dustPetrotheum", "dustPyrotheum"});
        }
        RecipeHelper.addShapelessFluidRecipe((ItemStack)new ItemStack(Blocks.field_150432_aD), (Object[])new Object[]{new FluidIngredientFactory.FluidIngredient(FluidRegistry.WATER.getName()), "dustCryotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150403_cj), (Object[])new Object[]{new ItemStack(Blocks.field_150432_aD), "dustCryotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151137_ax, 2), (Object[])new Object[]{ItemMaterial.crystalRedstone, "dustCryotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151114_aO), (Object[])new Object[]{ItemMaterial.crystalGlowstone, "dustCryotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151079_bi), (Object[])new Object[]{ItemMaterial.crystalEnder, "dustCryotheum"});
        RecipeHelper.addShapelessFluidRecipe((ItemStack)new ItemStack(Items.field_151137_ax, 10), (Object[])new Object[]{new FluidIngredientFactory.FluidIngredient("redstone"), "dustCryotheum"});
        RecipeHelper.addShapelessFluidRecipe((ItemStack)new ItemStack(Items.field_151114_aO, 4), (Object[])new Object[]{new FluidIngredientFactory.FluidIngredient("glowstone"), "dustCryotheum"});
        RecipeHelper.addShapelessFluidRecipe((ItemStack)new ItemStack(Items.field_151079_bi, 4), (Object[])new Object[]{new FluidIngredientFactory.FluidIngredient("ender"), "dustCryotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150351_n), (Object[])new Object[]{new ItemStack(Blocks.field_150347_e), TFEquipment.ToolSet.COPPER.itemHammer});
        TFCrafting.loadVanillaRecipes();
        TFCrafting.loadPotions();
    }

    public static void loadVanillaRecipes() {
        if (TFProps.enableHorseArmorCrafting) {
            RecipeHelper.addShapedRecipe((ItemStack)new ItemStack(Items.field_151138_bX, 1), (Object[])new Object[]{"  H", "ICI", "III", Character.valueOf('C'), "blockWool", Character.valueOf('H'), Items.field_151028_Y, Character.valueOf('I'), "ingotIron"});
            RecipeHelper.addShapedRecipe((ItemStack)new ItemStack(Items.field_151136_bY), (Object[])new Object[]{"  H", "ICI", "III", Character.valueOf('C'), "blockWool", Character.valueOf('H'), Items.field_151169_ag, Character.valueOf('I'), "ingotGold"});
            RecipeHelper.addShapedRecipe((ItemStack)new ItemStack(Items.field_151125_bZ), (Object[])new Object[]{"  H", "ICI", "III", Character.valueOf('C'), "blockWool", Character.valueOf('H'), Items.field_151161_ac, Character.valueOf('I'), "gemDiamond"});
        }
        if (TFProps.enableSaddleCrafting) {
            RecipeHelper.addShapedRecipe((ItemStack)new ItemStack(Items.field_151141_av), (Object[])new Object[]{"LLL", "LIL", "I I", Character.valueOf('I'), "ingotIron", Character.valueOf('L'), Items.field_151116_aA});
        }
    }

    public static void loadPotions() {
        PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemMaterial.dustBasalz}), (PotionType)CorePotions.haste);
        PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemMaterial.dustObsidian}), (PotionType)CorePotions.resistance);
        PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemMaterial.dustBlitz}), (PotionType)CorePotions.levitation);
        PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemMaterial.dustBlizz}), (PotionType)CorePotions.absorption);
        PotionHelper.func_193357_a((PotionType)PotionTypes.field_185220_C, (Item)Items.field_151071_bq, (PotionType)CorePotions.wither);
        PotionHelper.func_193357_a((PotionType)CorePotions.haste, (Item)Items.field_151137_ax, (PotionType)CorePotions.hasteLong);
        PotionHelper.func_193357_a((PotionType)CorePotions.resistance, (Item)Items.field_151137_ax, (PotionType)CorePotions.resistanceLong);
        PotionHelper.func_193357_a((PotionType)CorePotions.levitation, (Item)Items.field_151137_ax, (PotionType)CorePotions.levitationLong);
        PotionHelper.func_193357_a((PotionType)CorePotions.absorption, (Item)Items.field_151137_ax, (PotionType)CorePotions.absorptionLong);
        PotionHelper.func_193357_a((PotionType)CorePotions.wither, (Item)Items.field_151137_ax, (PotionType)CorePotions.witherLong);
        PotionHelper.func_193357_a((PotionType)CorePotions.haste, (Item)Items.field_151114_aO, (PotionType)CorePotions.hasteStrong);
        PotionHelper.func_193357_a((PotionType)CorePotions.resistance, (Item)Items.field_151114_aO, (PotionType)CorePotions.resistanceStrong);
        PotionHelper.func_193357_a((PotionType)CorePotions.absorption, (Item)Items.field_151114_aO, (PotionType)CorePotions.absorptionStrong);
        PotionHelper.func_193357_a((PotionType)CorePotions.wither, (Item)Items.field_151114_aO, (PotionType)CorePotions.witherStrong);
    }
}

