/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.ClientCommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.Logging;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketIntegerFromServer
implements IMessage {
    private BlockPos pos;
    private Integer result;
    private String command;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos(buf);
        this.command = NetworkTools.readString(buf);
        boolean resultPresent = buf.readBoolean();
        this.result = resultPresent ? Integer.valueOf(buf.readInt()) : null;
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos(buf, this.pos);
        NetworkTools.writeString(buf, this.command);
        buf.writeBoolean(this.result != null);
        if (this.result != null) {
            buf.writeInt(this.result.intValue());
        }
    }

    public PacketIntegerFromServer() {
    }

    public PacketIntegerFromServer(BlockPos pos, String command, Integer result) {
        this.pos = pos;
        this.command = command;
        this.result = result;
    }

    public static class Handler
    implements IMessageHandler<PacketIntegerFromServer, IMessage> {
        public IMessage onMessage(PacketIntegerFromServer message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketIntegerFromServer message, MessageContext ctx) {
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
            if (!(te instanceof ClientCommandHandler)) {
                Logging.log("createInventoryReadyPacket: TileEntity is not a ClientCommandHandler!");
                return;
            }
            ClientCommandHandler clientCommandHandler = (ClientCommandHandler)te;
            if (!clientCommandHandler.execute(message.command, message.result)) {
                Logging.log("Command " + message.command + " was not handled!");
            }
        }
    }
}

