/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import mcjty.lib.McJtyLib;
import mcjty.lib.compat.RedstoneFluxCompatibility;
import mcjty.lib.varia.EnergySupportDraconic;
import mcjty.lib.varia.EnergySupportEnderIO;
import mcjty.lib.varia.EnergySupportMekanism;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;

public class EnergyTools {
    private static boolean draconic = false;
    private static boolean mekanism = false;
    private static boolean enderio = false;
    private static boolean checkMods = true;

    public static boolean isEnergyTE(TileEntity te) {
        if (te == null) {
            return false;
        }
        if (McJtyLib.redstoneflux && RedstoneFluxCompatibility.isEnergyHandler(te)) {
            return true;
        }
        return te.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    private static void doCheckMods() {
        if (checkMods) {
            draconic = Loader.isModLoaded((String)"draconicevolution");
            mekanism = Loader.isModLoaded((String)"mekanism") || Loader.isModLoaded((String)"Mekanism");
            enderio = Loader.isModLoaded((String)"EnderIO") || Loader.isModLoaded((String)"enderio");
            checkMods = false;
        }
    }

    public static EnergyLevelMulti getEnergyLevelMulti(TileEntity tileEntity) {
        long energyStored;
        long maxEnergyStored;
        EnergyTools.doCheckMods();
        if (draconic && EnergySupportDraconic.isDraconicEnergyTile(tileEntity)) {
            maxEnergyStored = EnergySupportDraconic.getMaxEnergy(tileEntity);
            energyStored = EnergySupportDraconic.getCurrentEnergy(tileEntity);
        } else if (mekanism && EnergySupportMekanism.isMekanismTileEntity(tileEntity)) {
            maxEnergyStored = EnergySupportMekanism.getMaxEnergy(tileEntity);
            energyStored = EnergySupportMekanism.getCurrentEnergy(tileEntity);
        } else if (enderio && EnergySupportEnderIO.isEnderioTileEntity(tileEntity)) {
            maxEnergyStored = EnergySupportEnderIO.getMaxEnergy(tileEntity);
            energyStored = EnergySupportEnderIO.getCurrentEnergy(tileEntity);
        } else if (McJtyLib.redstoneflux && RedstoneFluxCompatibility.isEnergyHandler(tileEntity)) {
            maxEnergyStored = RedstoneFluxCompatibility.getMaxEnergy(tileEntity);
            energyStored = RedstoneFluxCompatibility.getEnergy(tileEntity);
        } else if (tileEntity != null && tileEntity.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage energy = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, null);
            maxEnergyStored = energy.getMaxEnergyStored();
            energyStored = energy.getEnergyStored();
        } else {
            maxEnergyStored = 0L;
            energyStored = 0L;
        }
        return new EnergyLevelMulti(energyStored, maxEnergyStored);
    }

    public static EnergyLevel getEnergyLevel(TileEntity tileEntity) {
        int energyStored;
        int maxEnergyStored;
        if (McJtyLib.redstoneflux && RedstoneFluxCompatibility.isEnergyHandler(tileEntity)) {
            maxEnergyStored = RedstoneFluxCompatibility.getMaxEnergy(tileEntity);
            energyStored = RedstoneFluxCompatibility.getEnergy(tileEntity);
        } else if (tileEntity != null && tileEntity.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage energy = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, null);
            maxEnergyStored = energy.getMaxEnergyStored();
            energyStored = energy.getEnergyStored();
        } else {
            maxEnergyStored = 0;
            energyStored = 0;
        }
        return new EnergyLevel(energyStored, maxEnergyStored);
    }

    public static int receiveEnergy(TileEntity tileEntity, EnumFacing from, int maxReceive) {
        IEnergyStorage capability;
        if (McJtyLib.redstoneflux && RedstoneFluxCompatibility.isEnergyReceiver(tileEntity)) {
            return RedstoneFluxCompatibility.receiveEnergy(tileEntity, from, maxReceive);
        }
        if (tileEntity != null && tileEntity.hasCapability(CapabilityEnergy.ENERGY, from) && (capability = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, from)).canReceive()) {
            return capability.receiveEnergy(maxReceive, false);
        }
        return 0;
    }

    public static class EnergyLevelMulti {
        private final long energy;
        private final long maxEnergy;

        public EnergyLevelMulti(long energy, long maxEnergy) {
            this.energy = energy;
            this.maxEnergy = maxEnergy;
        }

        public long getEnergy() {
            return this.energy;
        }

        public long getMaxEnergy() {
            return this.maxEnergy;
        }
    }

    public static class EnergyLevel {
        private final int energy;
        private final int maxEnergy;

        public EnergyLevel(int energy, int maxEnergy) {
            this.energy = energy;
            this.maxEnergy = maxEnergy;
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getMaxEnergy() {
            return this.maxEnergy;
        }
    }
}

