/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.api.IDataRetainingTile;
import com.brandon3055.brandonscore.lib.datamanager.IDataManagerProvider;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.TileDataManager;
import com.brandon3055.brandonscore.lib.datamanager.TileDataOptions;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class TileBCBase
extends TileEntity
implements IDataManagerProvider,
IDataRetainingTile {
    public static final String TILE_DATA_TAG = "BCTileData";
    protected boolean shouldRefreshOnState = true;
    protected TileDataManager<TileBCBase> dataManager = new TileDataManager<TileBCBase>(this);

    @Override
    public TileDataManager getDataManager() {
        return this.dataManager;
    }

    public <M extends IManagedData> TileDataOptions<M> register(String name, M managedData) {
        return this.dataManager.register(name, managedData);
    }

    public void update() {
        if (!this.field_145850_b.field_72995_K) {
            this.dataManager.detectAndSendChanges();
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.dataManager.writeSyncNBT(compound);
        this.writeExtraNBT(compound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        this.dataManager.writeSyncNBT(compound);
        this.writeExtraNBT(compound);
        return compound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.dataManager.readSyncNBT(pkt.func_148857_g());
        this.readExtraNBT(pkt.func_148857_g());
    }

    public void sendPacketToServer(Consumer<MCDataOutput> writer, int id) {
        PacketCustom packet = new PacketCustom((Object)"BCPCChannel", 1);
        packet.writePos(this.field_174879_c);
        packet.writeByte((int)((byte)id));
        writer.accept((MCDataOutput)packet);
        packet.sendToServer();
    }

    public void receivePacketFromClient(MCDataInput data, EntityPlayerMP client, int id) {
    }

    public PacketCustom sendPacketToClient(Consumer<MCDataOutput> writer, int id) {
        PacketCustom packet = new PacketCustom((Object)"BCPCChannel", 2);
        packet.writePos(this.field_174879_c);
        packet.writeByte((int)((byte)id));
        writer.accept((MCDataOutput)packet);
        return packet;
    }

    public void sendPacketToClient(EntityPlayerMP player, Consumer<MCDataOutput> writer, int id) {
        this.sendPacketToClient(writer, id).sendToPlayer((EntityPlayer)player);
    }

    public void sendPacketToClient(NetworkRegistry.TargetPoint tp, Consumer<MCDataOutput> writer, int id) {
        this.sendPacketToClient(writer, id).sendPacketToAllAround(tp.x, tp.y, tp.z, tp.range, tp.dimension);
    }

    public void receivePacketFromServer(MCDataInput data, int id) {
    }

    public void updateBlock() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public void dirtyBlock() {
        Chunk chunk = this.field_145850_b.func_175726_f(this.func_174877_v());
        chunk.func_177427_f(true);
    }

    public void setShouldRefreshOnBlockChange() {
        this.shouldRefreshOnState = false;
    }

    public IBlockState getState(Block expectedBlock) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return state.func_177230_c() == expectedBlock ? state : expectedBlock.func_176223_P();
    }

    public Block getBlockTypeSafe(Block defaultBlock) {
        if (this.func_145838_q() != null) {
            return this.func_145838_q();
        }
        return defaultBlock;
    }

    @Deprecated
    public boolean verifyPlayerPermission(EntityPlayer player) {
        PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock(player, EnumHand.MAIN_HAND, this.field_174879_c, EnumFacing.UP, player.func_70040_Z());
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    @Override
    public NBTTagCompound writeToItemStack(ItemStack stack, boolean willHarvest) {
        NBTTagCompound dataTag = new NBTTagCompound();
        this.dataManager.writeToStackNBT(dataTag);
        ItemNBTHelper.getCompound(stack).func_74782_a(TILE_DATA_TAG, (NBTBase)dataTag);
        return dataTag;
    }

    @Override
    @Nullable
    public NBTTagCompound readFromItemStack(ItemStack stack) {
        NBTTagCompound dataTag = stack.func_190925_c(TILE_DATA_TAG);
        this.dataManager.readFromStackNBT(dataTag);
        return dataTag;
    }

    public void writeExtraNBT(NBTTagCompound compound) {
    }

    public void readExtraNBT(NBTTagCompound compound) {
    }

    public final NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.dataManager.writeToNBT(compound);
        this.writeExtraNBT(compound);
        return compound;
    }

    public final void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.dataManager.readFromNBT(compound);
        this.readExtraNBT(compound);
        this.onTileLoaded();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return this.shouldRefreshOnState ? oldState != newSate : oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void onTileLoaded() {
    }
}

