/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui;

import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class MGuiElementBase {
    public int xPos;
    public int yPos;
    public int xSize;
    public int ySize;
    private boolean enabled = true;
    public IModularGui modularGui;
    public String id = "";
    private List<String> groups = new ArrayList<String>();
    public LinkedList<MGuiElementBase> childElements = new LinkedList();
    public FontRenderer fontRenderer;
    public Minecraft mc;
    public Object linkedObject = null;
    public MGuiElementBase parent = null;
    protected List<MGuiElementBase> toRemove = new ArrayList<MGuiElementBase>();
    public int displayLevel = 0;
    protected double zOffset = 0.0;
    private Rectangle rectangle = new Rectangle();

    public MGuiElementBase(IModularGui modularGui) {
        this.modularGui = modularGui;
    }

    public MGuiElementBase(IModularGui modularGui, int xPos, int yPos) {
        this(modularGui);
        this.xPos = xPos;
        this.yPos = yPos;
    }

    public MGuiElementBase(IModularGui modularGui, int xPos, int yPos, int xSize, int ySize) {
        this(modularGui, xPos, yPos);
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public void initElement() {
        for (MGuiElementBase element : this.childElements) {
            element.initElement();
        }
    }

    public MGuiElementBase addChild(MGuiElementBase element) {
        this.childElements.add(element);
        element.parent = this;
        return this;
    }

    public MGuiElementBase addChildren(List<MGuiElementBase> elements) {
        this.childElements.addAll(elements);
        for (MGuiElementBase element : elements) {
            element.parent = this;
        }
        return this;
    }

    public MGuiElementBase removeChild(MGuiElementBase element) {
        if (element != null && this.childElements.contains(element)) {
            this.toRemove.add(element);
        }
        return this;
    }

    public MGuiElementBase removeChildByID(String id) {
        for (MGuiElementBase element : this.childElements) {
            if (element.id == null || !element.id.equals(id)) continue;
            this.toRemove.add(element);
            return this;
        }
        return this;
    }

    public MGuiElementBase removeChildByGroup(String group) {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isInGroup(group)) continue;
            this.toRemove.add(element);
        }
        return this;
    }

    public MGuiElementBase setChildIDEnabled(String id, boolean enabled) {
        for (MGuiElementBase element : this.childElements) {
            if (element.id == null || !element.id.equals(id)) continue;
            element.enabled = enabled;
            return this;
        }
        return this;
    }

    public MGuiElementBase setChildGroupEnabled(String group, boolean enabled) {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isInGroup(group)) continue;
            element.enabled = enabled;
        }
        return this;
    }

    public MGuiElementBase addToGroup(String group) {
        this.groups.add(group);
        return this;
    }

    public MGuiElementBase removeFromGroup(String group) {
        if (this.groups.contains(group)) {
            this.groups.remove(group);
        }
        return this;
    }

    public MGuiElementBase removeFromAllGroups() {
        this.groups.clear();
        return this;
    }

    public boolean isInGroup(String group) {
        return this.groups.contains(group);
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public MGuiElementBase setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return GuiHelper.isInRect(this.xPos, this.yPos, this.xSize, this.ySize, mouseX, mouseY);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled() || !element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(int mouseX, int mouseY, int state) {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled() || !element.mouseReleased(mouseX, mouseY, state)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled() || !element.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) continue;
            return true;
        }
        return false;
    }

    public boolean handleMouseInput() {
        int mouseX = Mouse.getEventX() * this.modularGui.screenWidth() / this.modularGui.getMinecraft().field_71443_c;
        int mouseY = this.modularGui.screenHeight() - Mouse.getEventY() * this.modularGui.screenHeight() / this.modularGui.getMinecraft().field_71440_d - 1;
        int scrollDirection = Mouse.getEventDWheel();
        if (scrollDirection != 0) {
            for (MGuiElementBase element : this.childElements) {
                if (!element.isEnabled() || !element.handleMouseScroll(mouseX, mouseY, scrollDirection)) continue;
                return true;
            }
        }
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled() || !element.handleMouseInput()) continue;
            return true;
        }
        return false;
    }

    public boolean handleMouseScroll(int mouseX, int mouseY, int scrollDirection) {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled() || !element.handleMouseScroll(mouseX, mouseY, scrollDirection)) continue;
            return true;
        }
        return false;
    }

    protected boolean keyTyped(char typedChar, int keyCode) throws IOException {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled() || !element.keyTyped(typedChar, keyCode)) continue;
            return true;
        }
        return false;
    }

    public boolean onUpdate() {
        if (!this.toRemove.isEmpty()) {
            this.childElements.removeAll(this.toRemove);
            this.toRemove.clear();
        }
        for (MGuiElementBase element : this.childElements) {
            if (!element.onUpdate()) continue;
            return true;
        }
        return false;
    }

    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled()) continue;
            element.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
        }
    }

    public void renderForegroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled()) continue;
            element.renderForegroundLayer(minecraft, mouseX, mouseY, partialTicks);
        }
    }

    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled() || !element.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks)) continue;
            return true;
        }
        return false;
    }

    public GuiScreen getScreen() {
        return this.modularGui.getScreen();
    }

    public int hashCode() {
        return ("[" + this.id + "-" + this.xPos + "-" + this.yPos + "-" + this.xSize + "-" + this.ySize + "" + this.displayLevel + "]").hashCode();
    }

    public void bindTexture(ResourceLocation resourceLocation) {
        this.modularGui.getMinecraft().func_110434_K().func_110577_a(resourceLocation);
    }

    public MGuiElementBase setId(String id) {
        this.id = id;
        return this;
    }

    public void setWorldAndResolution(Minecraft mc, int width, int height) {
        this.mc = mc;
        this.fontRenderer = mc.field_71466_p;
        for (MGuiElementBase element : this.childElements) {
            element.setWorldAndResolution(mc, width, height);
        }
    }

    public void moveBy(int xAmount, int yAmount) {
        this.xPos += xAmount;
        this.yPos += yAmount;
        for (MGuiElementBase element : this.childElements) {
            element.moveBy(xAmount, yAmount);
        }
    }

    public void setXPos(int x) {
        this.moveBy(x - this.xPos, 0);
    }

    public void setYPos(int y) {
        this.moveBy(0, y - this.yPos);
    }

    public MGuiElementBase setLinkedObject(Object linkedObject) {
        this.linkedObject = linkedObject;
        return this;
    }

    public Rectangle getRectangle() {
        this.rectangle.setBounds(this.xPos, this.yPos, this.xSize, this.ySize);
        return this.rectangle;
    }

    public double getRenderZLevel() {
        return (double)this.modularGui.getZLevel() + this.zOffset;
    }

    public void drawHorizontalLine(double startX, double endX, double y, int color) {
        if (endX < startX) {
            double i = startX;
            startX = endX;
            endX = i;
        }
        this.drawRect(startX, y, endX + 1.0, y + 1.0, color);
    }

    public void drawVerticalLine(double x, double startY, double endY, int color) {
        if (endY < startY) {
            double i = startY;
            startY = endY;
            endY = i;
        }
        this.drawRect(x, startY + 1.0, x + 1.0, endY, color);
    }

    public void drawRect(double left, double top, double right, double bottom, int color) {
        double zLevel = this.getRenderZLevel();
        if (left < right) {
            double i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            double j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b(left, bottom, zLevel).func_181675_d();
        vertexbuffer.func_181662_b(right, bottom, zLevel).func_181675_d();
        vertexbuffer.func_181662_b(right, top, zLevel).func_181675_d();
        vertexbuffer.func_181662_b(left, top, zLevel).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        double zLevel = this.getRenderZLevel();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + height), zLevel).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), zLevel).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0), zLevel).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + 0), zLevel).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawTexturedModalRect(double xCoord, double yCoord, int minU, int minV, int maxU, int maxV) {
        double zLevel = this.getRenderZLevel();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(xCoord + 0.0, yCoord + (double)maxV, zLevel).func_187315_a((double)((float)(minU + 0) * 0.00390625f), (double)((float)(minV + maxV) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b(xCoord + (double)maxU, yCoord + (double)maxV, zLevel).func_187315_a((double)((float)(minU + maxU) * 0.00390625f), (double)((float)(minV + maxV) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b(xCoord + (double)maxU, yCoord + 0.0, zLevel).func_187315_a((double)((float)(minU + maxU) * 0.00390625f), (double)((float)(minV + 0) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b(xCoord + 0.0, yCoord + 0.0, zLevel).func_187315_a((double)((float)(minU + 0) * 0.00390625f), (double)((float)(minV + 0) * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        double zLevel = this.getRenderZLevel();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        vertexbuffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        vertexbuffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        vertexbuffer.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawModalRectWithCustomSizedTexture(double x, double y, double u, double v, double width, double height, double textureWidth, double textureHeight) {
        double zLevel = this.getRenderZLevel();
        double f = 1.0 / textureWidth;
        double f1 = 1.0 / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(x, y + height, zLevel).func_187315_a(u * f, (v + height) * f1).func_181675_d();
        vertexbuffer.func_181662_b(x + width, y + height, zLevel).func_187315_a((u + width) * f, (v + height) * f1).func_181675_d();
        vertexbuffer.func_181662_b(x + width, y, zLevel).func_187315_a((u + width) * f, v * f1).func_181675_d();
        vertexbuffer.func_181662_b(x, y, zLevel).func_187315_a(u * f, v * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawScaledCustomSizeModalRect(double xPos, double yPos, double u, double v, double uWidth, double vHeight, double width, double height, double textureSheetWidth, double testureSheetHeight) {
        double zLevel = this.getRenderZLevel();
        double f = 1.0 / textureSheetWidth;
        double f1 = 1.0 / testureSheetHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(xPos, yPos + height, zLevel).func_187315_a(u * f, (v + vHeight) * f1).func_181675_d();
        vertexbuffer.func_181662_b(xPos + width, yPos + height, zLevel).func_187315_a((u + uWidth) * f, (v + vHeight) * f1).func_181675_d();
        vertexbuffer.func_181662_b(xPos + width, yPos, zLevel).func_187315_a((u + uWidth) * f, v * f1).func_181675_d();
        vertexbuffer.func_181662_b(xPos, yPos, zLevel).func_187315_a(u * f, v * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public int drawString(FontRenderer fontRenderer, String text, float x, float y, int color) {
        return this.drawString(fontRenderer, text, x, y, color, false);
    }

    public int drawString(FontRenderer fontRenderer, String text, float x, float y, int color, boolean dropShadow) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(this.getRenderZLevel() + 1.0));
        int i = fontRenderer.func_175065_a(text, x, y, color, dropShadow);
        GlStateManager.func_179121_F();
        return i;
    }

    public void drawCenteredString(FontRenderer fontRenderer, String text, float x, float y, int color, boolean dropShadow) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(this.getRenderZLevel() + 1.0));
        fontRenderer.func_175065_a(text, x - (float)(fontRenderer.func_78256_a(text) / 2), y, color, dropShadow);
        GlStateManager.func_179121_F();
    }

    public void drawSplitString(FontRenderer fontRenderer, String text, float x, float y, int wrapWidth, int color, boolean dropShadow) {
        for (String s : fontRenderer.func_78271_c(text, wrapWidth)) {
            this.drawString(fontRenderer, s, x, y, color, dropShadow);
            y += (float)fontRenderer.field_78288_b;
        }
    }

    public void drawCenteredSplitString(FontRenderer fontRenderer, String str, float x, float y, int wrapWidth, int color, boolean dropShadow) {
        for (String s : fontRenderer.func_78271_c(str, wrapWidth)) {
            this.drawCenteredString(fontRenderer, s, x, y, color, dropShadow);
            y += (float)fontRenderer.field_78288_b;
        }
    }

    public void drawHoveringText(List<String> textLines, int mouseX, int mouseY, FontRenderer font, int screenWidth, int screenHeight) {
        double oldOffset = this.zOffset;
        this.zOffset = 190.0;
        this.drawHoveringText(textLines, mouseX, mouseY, font, screenWidth, screenHeight, -1);
        this.zOffset = oldOffset;
    }

    public void drawHoveringText(List<String> textLines, int mouseX, int mouseY, FontRenderer font, int screenWidth, int screenHeight, int maxTextWidth) {
        if (!textLines.isEmpty()) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = font.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY + tooltipHeight + 6 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 6;
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            }
            this.zOffset += 1.0;
            int backgroundColor = -267386864;
            this.drawGradientRect(tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, -267386864, -267386864);
            this.drawGradientRect(tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, -267386864, -267386864);
            this.drawGradientRect(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            this.drawGradientRect(tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            this.drawGradientRect(tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            int borderColorStart = 0x505000FF;
            int borderColorEnd = 1344798847;
            this.drawGradientRect(tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, 0x505000FF, 1344798847);
            this.drawGradientRect(tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, 0x505000FF, 1344798847);
            this.drawGradientRect(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, 0x505000FF, 0x505000FF);
            this.drawGradientRect(tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, 1344798847, 1344798847);
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line;
                line = textLines.get(lineNumber);
                this.drawString(font, line, tooltipX, tooltipY, -1, true);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            this.zOffset -= 1.0;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    public void drawGradientRect(double left, double top, double right, double bottom, int colour1, int colour2) {
        double zLevel = this.getRenderZLevel();
        float alpha1 = (float)(colour1 >> 24 & 0xFF) / 255.0f;
        float red1 = (float)(colour1 >> 16 & 0xFF) / 255.0f;
        float green1 = (float)(colour1 >> 8 & 0xFF) / 255.0f;
        float blue1 = (float)(colour1 & 0xFF) / 255.0f;
        float alpha2 = (float)(colour2 >> 24 & 0xFF) / 255.0f;
        float red2 = (float)(colour2 >> 16 & 0xFF) / 255.0f;
        float green2 = (float)(colour2 >> 8 & 0xFF) / 255.0f;
        float blue2 = (float)(colour2 & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b(right, top, zLevel).func_181666_a(red1, green1, blue1, alpha1).func_181675_d();
        vertexbuffer.func_181662_b(left, top, zLevel).func_181666_a(red1, green1, blue1, alpha1).func_181675_d();
        vertexbuffer.func_181662_b(left, bottom, zLevel).func_181666_a(red2, green2, blue2, alpha2).func_181675_d();
        vertexbuffer.func_181662_b(right, bottom, zLevel).func_181666_a(red2, green2, blue2, alpha2).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public void drawColouredRect(double posX, double posY, double xSize, double ySize, int colour) {
        this.drawGradientRect(posX, posY, posX + xSize, posY + ySize, colour, colour);
    }

    public void drawBorderedRect(double posX, double posY, double xSize, double ySize, double borderWidth, int fillColour, int borderColour) {
        this.drawColouredRect(posX, posY, xSize, borderWidth, borderColour);
        this.drawColouredRect(posX, posY + ySize - borderWidth, xSize, borderWidth, borderColour);
        this.drawColouredRect(posX, posY + borderWidth, borderWidth, ySize - 2.0 * borderWidth, borderColour);
        this.drawColouredRect(posX + xSize - borderWidth, posY + borderWidth, borderWidth, ySize - 2.0 * borderWidth, borderColour);
        this.drawColouredRect(posX + borderWidth, posY + borderWidth, xSize - 2.0 * borderWidth, ySize - 2.0 * borderWidth, fillColour);
    }

    public static int mixColours(int colour1, int colour2) {
        return MGuiElementBase.mixColours(colour1, colour2, false);
    }

    public static int mixColours(int colour1, int colour2, boolean subtract) {
        int alpha1 = colour1 >> 24 & 0xFF;
        int alpha2 = colour2 >> 24 & 0xFF;
        int red1 = colour1 >> 16 & 0xFF;
        int red2 = colour2 >> 16 & 0xFF;
        int green1 = colour1 >> 8 & 0xFF;
        int green2 = colour2 >> 8 & 0xFF;
        int blue1 = colour1 & 0xFF;
        int blue2 = colour2 & 0xFF;
        int alpha = MathHelper.func_76125_a((int)(alpha1 + (subtract ? -alpha2 : alpha2)), (int)0, (int)255);
        int red = MathHelper.func_76125_a((int)(red1 + (subtract ? -red2 : red2)), (int)0, (int)255);
        int green = MathHelper.func_76125_a((int)(green1 + (subtract ? -green2 : green2)), (int)0, (int)255);
        int blue = MathHelper.func_76125_a((int)(blue1 + (subtract ? -blue2 : blue2)), (int)0, (int)255);
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }
}

