/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.lib;

import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.EnumAlignment;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.ModuleBuilder;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButtonSolid;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButtonToggle;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiEntityRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiHoverPopup;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiList;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiListEntryWrapper;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiPopupTextField;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiSelectDialog;
import com.brandon3055.brandonscore.lib.EntityFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class MGuiEntityFilter
extends MGuiElementBase
implements IMGuiListener {
    private final EntityFilter filter;
    public List<String> playerNames = new ArrayList<String>();
    private MGuiButtonToggle detectPassive;
    private MGuiButtonToggle detectHostile;
    private MGuiButtonToggle detectPlayer;
    private MGuiButtonToggle detectOther;
    private MGuiButton toggleList;
    private MGuiButton addEntity;
    private MGuiButton addPlayer;
    private MGuiButton addCustom;
    private MGuiLabel listLabel;
    private MGuiList list;
    private MGuiSelectDialog selector = null;
    private LinkedList<String> lastTickList = new LinkedList();
    private static List<Entity> entityList;

    public MGuiEntityFilter(IModularGui modularGui, EntityFilter filter) {
        super(modularGui);
        this.filter = filter;
    }

    public MGuiEntityFilter(IModularGui modularGui, EntityFilter filter, int xPos, int yPos) {
        super(modularGui, xPos, yPos);
        this.filter = filter;
    }

    public MGuiEntityFilter(IModularGui modularGui, EntityFilter filter, int xPos, int yPos, int xSize, int ySize) {
        super(modularGui, xPos, yPos, xSize, ySize);
        this.filter = filter;
    }

    @Override
    public void initElement() {
        this.childElements.clear();
        this.addChild(new MGuiLabel(this.modularGui, this.xPos, this.yPos, this.xSize, 12, I18n.func_135052_a((String)"gui.entityFilter.filter.txt", (Object[])new Object[0])));
        int buttons = (this.filter.isTypeSelectionEnabled() ? 1 : 0) + (this.filter.isTypeSelectionEnabled() ? 1 : 0) + (this.filter.isTypeSelectionEnabled() ? 1 : 0);
        if (buttons <= 0) {
            buttons = 1;
        }
        int width = this.xSize / buttons;
        int offset = this.xSize - width * buttons;
        ModuleBuilder.EqualColumns builder = new ModuleBuilder.EqualColumns(this.xPos + offset, this.yPos + 12, 2, this.xSize / 2 - 1, 12, 1);
        if (this.filter.isTypeSelectionEnabled()) {
            this.detectHostile = (MGuiButtonToggle)new MGuiButtonToggle(this.modularGui){

                @Override
                public List<String> getToolTip() {
                    return Collections.singletonList(MGuiEntityFilter.this.detectHostile.isPressed() ? I18n.func_135052_a((String)"gui.de.button.toggleOff", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.de.button.toggleOn", (Object[])new Object[0]));
                }

                @Override
                public boolean isPressed() {
                    return ((MGuiEntityFilter)MGuiEntityFilter.this).filter.detectHostile;
                }
            }.setListener(this).setDisplayString(I18n.func_135052_a((String)"gui.entityFilter.button.hostile", (Object[])new Object[0]));
            builder.add(this.detectHostile);
            this.detectHostile.toolTipDelay = 5;
        }
        if (this.filter.isTypeSelectionEnabled()) {
            this.detectPassive = (MGuiButtonToggle)new MGuiButtonToggle(this.modularGui){

                @Override
                public List<String> getToolTip() {
                    return Collections.singletonList(MGuiEntityFilter.this.detectPassive.isPressed() ? I18n.func_135052_a((String)"gui.de.button.toggleOff", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.de.button.toggleOn", (Object[])new Object[0]));
                }

                @Override
                public boolean isPressed() {
                    return ((MGuiEntityFilter)MGuiEntityFilter.this).filter.detectPassive;
                }
            }.setListener(this).setDisplayString(I18n.func_135052_a((String)"gui.entityFilter.button.passive", (Object[])new Object[0]));
            builder.add(this.detectPassive);
            this.detectPassive.toolTipDelay = 5;
        }
        if (this.filter.isTypeSelectionEnabled()) {
            this.detectPlayer = (MGuiButtonToggle)new MGuiButtonToggle(this.modularGui){

                @Override
                public List<String> getToolTip() {
                    return Collections.singletonList(MGuiEntityFilter.this.detectPlayer.isPressed() ? I18n.func_135052_a((String)"gui.de.button.toggleOff", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.de.button.toggleOn", (Object[])new Object[0]));
                }

                @Override
                public boolean isPressed() {
                    return ((MGuiEntityFilter)MGuiEntityFilter.this).filter.detectPlayer;
                }
            }.setListener(this).setDisplayString(I18n.func_135052_a((String)"gui.entityFilter.button.players", (Object[])new Object[0]));
            builder.add(this.detectPlayer);
            this.detectPlayer.toolTipDelay = 5;
        }
        if (this.filter.isOtherSelectorEnabled()) {
            this.detectOther = (MGuiButtonToggle)new MGuiButtonToggle(this.modularGui){

                @Override
                public List<String> getToolTip() {
                    return Collections.singletonList(MGuiEntityFilter.this.detectOther.isPressed() ? I18n.func_135052_a((String)"gui.de.button.toggleOff", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.de.button.toggleOn", (Object[])new Object[0]));
                }

                @Override
                public boolean isPressed() {
                    return ((MGuiEntityFilter)MGuiEntityFilter.this).filter.detectOther;
                }
            }.setListener(this).setDisplayString(I18n.func_135052_a((String)"gui.entityFilter.button.other", (Object[])new Object[0]));
            builder.add(this.detectOther);
            this.detectOther.toolTipDelay = 5;
        }
        this.addChildren(builder.finish());
        this.addExtraElements(this);
        if (this.filter.isListEnabled()) {
            this.addEntity = new MGuiButton(this.modularGui, this.xPos, this.yPos + this.ySize - 12, 46, 12, "+Entity").setListener(this);
            this.addChild(this.addEntity);
            this.addPlayer = new MGuiButton(this.modularGui, this.addEntity.xPos + this.addEntity.xSize + 1, this.yPos + this.ySize - 12, 46, 12, "+Player").setListener(this);
            this.addChild(this.addPlayer);
            this.addCustom = new MGuiButton(this.modularGui, this.addPlayer.xPos + this.addPlayer.xSize + 1, this.yPos + this.ySize - 12, 46, 12, "+Custom").setListener(this);
            this.addChild(this.addCustom);
            this.listLabel = new MGuiLabel(this.modularGui, this.xPos, builder.builderEndY + 4, this.xSize, 14, ""){

                @Override
                public String getDisplayString() {
                    return ((MGuiEntityFilter)MGuiEntityFilter.this).filter.isWhiteList ? I18n.func_135052_a((String)"gui.entityFilter.button.whiteList", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.entityFilter.button.blackList", (Object[])new Object[0]);
                }
            };
            this.addChild(this.listLabel);
            this.toggleList = new MGuiButton(this.modularGui, this.xPos + this.xSize - 45, this.listLabel.yPos + 1, 45, this.listLabel.ySize - 2, I18n.func_135052_a((String)"gui.de.button.toggle", (Object[])new Object[0])){

                @Override
                public List<String> getToolTip() {
                    return Collections.singletonList(((MGuiEntityFilter)MGuiEntityFilter.this).filter.isWhiteList ? I18n.func_135052_a((String)"gui.entityFilter.button.blackList", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.entityFilter.button.whiteList", (Object[])new Object[0]));
                }
            }.setListener(this);
            this.addChild(this.toggleList);
            this.list = new MGuiList(this.modularGui, this.xPos, this.listLabel.yPos + this.listLabel.ySize, this.xSize - 1, this.ySize - (this.listLabel.yPos - this.yPos + this.listLabel.ySize) - 13);
            this.addChild(this.list);
            this.listLabel.addChild(new MGuiBorderedRect(this.modularGui, this.list.xPos, this.list.yPos, this.list.xSize + 1, this.list.ySize).setBorderColour(-16777216).setFillColour(0x30000000));
        }
        super.initElement();
    }

    public void addExtraElements(MGuiEntityFilter filter) {
    }

    @Override
    public void onMGuiEvent(String eventString, MGuiElementBase eventElement) {
        if (eventElement == this.toggleList) {
            this.filter.isWhiteList = !this.filter.isWhiteList;
        } else if (eventElement == this.detectHostile) {
            this.filter.detectHostile = !this.filter.detectHostile;
        } else if (eventElement == this.detectPassive) {
            this.filter.detectPassive = !this.filter.detectPassive;
        } else if (eventElement == this.detectPlayer) {
            this.filter.detectPlayer = !this.filter.detectPlayer;
        } else if (eventElement == this.detectOther) {
            this.filter.detectOther = !this.filter.detectOther;
        } else {
            if ((eventElement == this.addEntity || eventElement == this.addPlayer) && this.list != null) {
                if (this.selector != null) {
                    this.modularGui.getManager().remove(this.selector);
                    this.selector = null;
                    return;
                }
                this.selector = new MGuiSelectDialog(this.modularGui, this.list.xPos, this.list.yPos, this.list.xSize, this.list.ySize).setListener(this);
                this.selector.allowOutsideClicks = true;
                this.selector.addChild(new MGuiButton(this.modularGui, this.xPos, this.selector.yPos - 12, 40, 12, TextFormatting.DARK_RED + I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])).setListener(this).setId("SELECT_CANCEL"));
                this.selector.addChild(new MGuiBorderedRect(this.modularGui, this.list.xPos, this.list.yPos, this.list.xSize + 1, this.list.ySize).setFillColour(-7303024).setBorderColour(-16777216));
                ArrayList<MGuiElementBase> elementBases = new ArrayList<MGuiElementBase>();
                if (eventElement == this.addEntity) {
                    for (Entity entity : this.getEntityList()) {
                        if (entity == null) continue;
                        String name = entity.func_145748_c_() == null ? "[unknown]" : entity.func_145748_c_().func_150254_d();
                        MGuiElementBase container = new MGuiElementBase(this.modularGui, 0, 0, this.xSize - 13, 20);
                        container.setLinkedObject(EntityList.func_75621_b((Entity)entity));
                        MGuiEntityRenderer renderer = new MGuiEntityRenderer(this.modularGui, 10, 5, 12, 10).setEntity(entity);
                        container.addChild(renderer);
                        MGuiLabel label = new MGuiLabel(this.modularGui, 30, 0, this.xSize - 42, 20, name).setAlignment(EnumAlignment.LEFT).setTrim(true);
                        if (this.fontRenderer.func_78256_a(name) > this.xSize - 40) {
                            label.addChild(new MGuiHoverPopup(this.modularGui, new String[]{name}, (MGuiElementBase)label));
                        }
                        container.addChild(label);
                        MGuiButtonSolid back = new MGuiButtonSolid(this.modularGui, 30, 0, this.xSize - 42, 20, ""){

                            @Override
                            public int getFillColour(boolean hovering, boolean disabled) {
                                return hovering ? -2130706433 : 0;
                            }

                            @Override
                            public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
                                return false;
                            }
                        }.setColours(0, 0, -1);
                        container.addChild(back);
                        elementBases.add(container);
                    }
                } else if (eventElement == this.addPlayer) {
                    for (String name : this.playerNames) {
                        name = "[player]:" + name;
                        MGuiLabel label = new MGuiLabel(this.modularGui, 0, 0, this.xSize - 12, 20, name).setAlignment(EnumAlignment.LEFT).setTrim(true);
                        if (this.fontRenderer.func_78256_a(name) > this.xSize - 40) {
                            label.addChild(new MGuiHoverPopup(this.modularGui, new String[]{name}, (MGuiElementBase)label));
                        }
                        label.setLinkedObject(name);
                        MGuiButtonSolid button = new MGuiButtonSolid(this.modularGui, 0, 0, this.xSize - 12, 20, ""){

                            @Override
                            public int getFillColour(boolean hovering, boolean disabled) {
                                return hovering ? -2130706433 : 0;
                            }

                            @Override
                            public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
                                return false;
                            }
                        }.setColours(0, 0, -1);
                        label.addChild(button);
                        elementBases.add(label);
                    }
                }
                this.selector.setOptions(elementBases);
                this.selector.initElement();
                this.modularGui.getManager().add(this.selector, this.displayLevel + 1);
                return;
            }
            if (eventElement == this.addCustom) {
                if (this.selector != null) {
                    this.modularGui.getManager().remove(this.selector);
                    this.selector = null;
                }
                MGuiPopupTextField textField = (MGuiPopupTextField)new MGuiPopupTextField(this.modularGui, this.xPos + this.xSize / 2 - 50, this.yPos + this.ySize / 2 - 6, 100, 12, this).setId("ADD_CUSTOM");
                textField.addChild(new MGuiHoverPopup(this.modularGui, new String[]{I18n.func_135052_a((String)"gui.entityFilter.customTip.txt", (Object[])new Object[0])}, (MGuiElementBase)textField));
                textField.show();
            } else if (eventString.equals("SELECTOR_PICK")) {
                if (eventElement.linkedObject instanceof String) {
                    String name = (String)eventElement.linkedObject;
                    this.filter.entityList.add(name);
                    this.modularGui.getManager().remove(this.selector);
                    this.selector = null;
                }
            } else {
                String name;
                if (eventElement.id.equals("SELECT_CANCEL")) {
                    this.modularGui.getManager().remove(this.selector);
                    this.selector = null;
                    return;
                }
                if (eventElement instanceof MGuiButton && ((MGuiButton)eventElement).buttonName.equals("REMOVE_ENTRY")) {
                    if (eventElement.linkedObject instanceof String) {
                        String name2 = (String)eventElement.linkedObject;
                        this.filter.entityList.remove(name2);
                    }
                } else if (eventElement.id.equals("ADD_CUSTOM")) {
                    if (!StringUtils.func_151246_b((String)eventString)) {
                        this.filter.entityList.add(eventString);
                    }
                } else if (eventElement instanceof MGuiButton && ((MGuiButton)eventElement).buttonName.equals("EDIT_ENTRY")) {
                    if (eventElement.linkedObject instanceof String) {
                        String name3 = (String)eventElement.linkedObject;
                        MGuiPopupTextField textField = (MGuiPopupTextField)new MGuiPopupTextField(this.modularGui, this.xPos + this.xSize / 2 - 50, this.yPos + this.ySize / 2 - 6, 100, 12, this).setId("EDIT_RESULT");
                        textField.textField.setText(name3);
                        textField.setLinkedObject(name3);
                        textField.addChild(new MGuiHoverPopup(this.modularGui, new String[]{I18n.func_135052_a((String)"gui.entityFilter.customTip.txt", (Object[])new Object[0])}, (MGuiElementBase)textField));
                        textField.show();
                    }
                } else if (eventElement.id.equals("EDIT_RESULT") && !StringUtils.func_151246_b((String)eventString) && eventElement.linkedObject instanceof String && this.filter.entityList.contains(name = (String)eventElement.linkedObject)) {
                    this.filter.entityList.remove(name);
                    this.filter.entityList.add(eventString);
                }
            }
        }
        this.filter.sendConfigToServer();
    }

    private List<Entity> getEntityList() {
        if (entityList == null) {
            entityList = new LinkedList<Entity>();
            ArrayList<Entity> listCanRender = new ArrayList<Entity>();
            ArrayList<Entity> listCantRender = new ArrayList<Entity>();
            for (ResourceLocation name : EntityList.func_180124_b()) {
                Entity entity = EntityList.func_188429_b((ResourceLocation)name, (World)this.modularGui.getMinecraft().field_71441_e);
                if (entity == null) continue;
                if (entity instanceof EntityItem) {
                    ((EntityItem)entity).func_92058_a(new ItemStack(Items.field_151034_e));
                    entity.func_96094_a("ItemStack");
                }
                try {
                    entity.func_70005_c_();
                }
                catch (Throwable e) {
                    continue;
                }
                if (entity.func_184222_aU() && (entity instanceof EntityLivingBase || entity instanceof EntityMinecart)) {
                    listCanRender.add(entity);
                    continue;
                }
                listCantRender.add(entity);
            }
            Iterator i1 = listCanRender.iterator();
            Iterator i2 = listCantRender.iterator();
            while (i1.hasNext() || i2.hasNext()) {
                if (i1.hasNext()) {
                    entityList.add((Entity)i1.next());
                }
                if (!i2.hasNext()) continue;
                entityList.add((Entity)i2.next());
            }
        }
        return entityList;
    }

    @Override
    public boolean onUpdate() {
        if (this.list != null && (this.list.listEntries.size() != this.filter.entityList.size() || this.filter.entityList.hashCode() != this.lastTickList.hashCode())) {
            this.lastTickList.clear();
            this.lastTickList.addAll(this.filter.entityList);
            this.list.clear();
            for (String name : this.filter.entityList) {
                MGuiLabel label = new MGuiLabel(this.modularGui, 0, 0, this.xSize - 35, 12, name).setAlignment(EnumAlignment.LEFT).setTrim(true);
                label.addChild(new MGuiButtonSolid(this.modularGui, "REMOVE_ENTRY", this.list.xSize - 22, 1, 10, 9, TextFormatting.RED + "x").setToolTip(new String[]{I18n.func_135052_a((String)"generic.remove.txt", (Object[])new Object[0])}).setListener(this).setLinkedObject(name));
                label.addChild(new MGuiButtonSolid(this.modularGui, "EDIT_ENTRY", this.list.xSize - 32, 1, 10, 9, TextFormatting.GREEN + "e").setToolTip(new String[]{I18n.func_135052_a((String)"generic.edit.txt", (Object[])new Object[0])}).setListener(this).setLinkedObject(name));
                if (this.fontRenderer.func_78256_a(name) > this.xSize - 35) {
                    label.addChild(new MGuiHoverPopup(this.modularGui, new String[]{name}, (MGuiElementBase)label));
                }
                this.list.addEntry(new MGuiListEntryWrapper(this.modularGui, label));
            }
        }
        return super.onUpdate();
    }

    public void onClose() {
        if (this.selector != null) {
            this.modularGui.getManager().remove(this.selector);
            this.selector = null;
        }
    }
}

