/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.command;

import com.brandon3055.brandonscore.handlers.HandHelper;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;

public class BCUtilCommands
extends CommandBase {
    public String func_71517_b() {
        return "bcore_util";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/bcore_util help";
    }

    public int func_82362_a() {
        return 3;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.help(sender);
            return;
        }
        try {
            String function = args[0];
            if (function.toLowerCase().equals("nbt")) {
                this.functionNBT(server, sender, args);
            } else if (function.equals("regenchunk")) {
                this.regenChunk(server, sender, args);
            } else if (!(function.equals("") || function.equals("") || function.equals("") || function.equals(""))) {
                this.help(sender);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new CommandException(e.getMessage(), new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return BCUtilCommands.func_71530_a((String[])args, (String[])new String[]{"nbt", "regenchunk"});
    }

    private void help(ICommandSender sender) {
        ChatHelper.message(sender, "The following are a list of Brandon's Core Utility Commands", new Style().func_150238_a(TextFormatting.AQUA).func_150228_d(Boolean.valueOf(true)));
        ChatHelper.message(sender, "/bcore_util nbt", TextFormatting.BLUE);
        ChatHelper.message(sender, "-Prints the NBT tag of the stack you are holding to chat and to the console.", TextFormatting.GRAY);
        ChatHelper.message(sender, "/bcore_util regenchunk [radius]", TextFormatting.BLUE);
        ChatHelper.message(sender, "-Regenerates the chunk(s) at your position.", TextFormatting.GRAY);
    }

    private void functionNBT(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = BCUtilCommands.func_71521_c((ICommandSender)sender);
        ItemStack stack = HandHelper.getMainFirst((EntityPlayer)player);
        if (stack.func_190926_b()) {
            throw new CommandException("You are not holding an item!", new Object[0]);
        }
        if (!stack.func_77942_o()) {
            throw new CommandException("That stack has no NBT tag!", new Object[0]);
        }
        NBTTagCompound compound = stack.func_77978_p();
        LogHelperBC.logNBT(compound);
        StringBuilder builder = new StringBuilder();
        LogHelperBC.buildNBT(builder, (NBTBase)compound, "", "Tag", false);
        String[] lines = builder.toString().split("\n");
        DataUtils.forEach(lines, s -> ChatHelper.message(sender, s, TextFormatting.GOLD));
    }

    private void regenChunk(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int rad = 0;
        if (args.length > 1) {
            rad = BCUtilCommands.func_175755_a((String)args[1]);
        }
        LogHelperBC.dev(rad);
        for (int xOffset = -rad; xOffset <= rad; ++xOffset) {
            for (int yOffset = -rad; yOffset <= rad; ++yOffset) {
                WorldServer world = (WorldServer)sender.func_130014_f_();
                EntityPlayerMP player = BCUtilCommands.func_71521_c((ICommandSender)sender);
                int chunkX = player.field_70176_ah + xOffset;
                int chunkZ = player.field_70164_aj + yOffset;
                Chunk oldChunk = world.func_72964_e(chunkX, chunkZ);
                ChunkProviderServer chunkProviderServer = world.func_72863_F();
                IChunkGenerator chunkGenerate = chunkProviderServer.field_186029_c;
                Chunk newChunk = chunkGenerate.func_185932_a(chunkX, chunkZ);
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (int y = 0; y < world.func_72800_K(); ++y) {
                            BlockPos chunkPos = new BlockPos(x, y, z);
                            BlockPos absPos = new BlockPos(x + chunkX * 16, y, z + chunkZ * 16);
                            IBlockState newState = newChunk.func_177435_g(chunkPos);
                            world.func_175656_a(absPos, newState);
                            TileEntity tileEntity = newChunk.func_177424_a(chunkPos, Chunk.EnumCreateEntityType.IMMEDIATE);
                            if (tileEntity == null) continue;
                            world.func_175690_a(absPos, tileEntity);
                        }
                    }
                }
                oldChunk.func_177446_d(false);
                oldChunk.func_186030_a((IChunkProvider)chunkProviderServer, chunkGenerate);
                PlayerChunkMap playerChunkMap = world.func_184164_w();
                if (playerChunkMap == null) {
                    return;
                }
                oldChunk.func_177427_f(true);
                oldChunk.func_76603_b();
                PlayerChunkMapEntry watcher = playerChunkMap.func_187301_b(oldChunk.field_76635_g, oldChunk.field_76647_h);
                if (watcher == null) continue;
                watcher.func_187267_a((Packet)new SPacketChunkData(oldChunk, 65535));
            }
        }
    }

    private void randomFunction2(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
    }

    private void randomFunction3(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
    }

    private void randomFunction4(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
    }

    private void randomFunction5(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
    }
}

