/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class TableBuilder<T> {
    private String NEW_LINE = System.lineSeparator();
    private static final String DIVIDER_COLUMN = "|";
    private static final String DIVIDER_ROW = "-";
    private static final String LINE_ENDING = "--|";
    private final List<T> entries = new ArrayList<T>();
    private final List<String> columnNames = new ArrayList<String>();
    private final List<Function<? super T, String>> columnFunctions = new ArrayList<Function<? super T, String>>();

    public void addColumn(String name, Function<? super T, ?> function) {
        this.columnNames.add(name);
        this.columnFunctions.add(p -> String.valueOf(function.apply(p)));
    }

    private int getMaxWidth(int columnIndex, Iterable<? extends T> entries) {
        int maxWidth = this.columnNames.get(columnIndex).length();
        Function<T, String> function = this.columnFunctions.get(columnIndex);
        for (T entry : entries) {
            String data = function.apply(entry);
            maxWidth = Math.max(maxWidth, data.length());
        }
        return maxWidth;
    }

    private String padLeft(String string, String padCharacter, int length) {
        while (string.length() < length) {
            string = padCharacter + string;
        }
        return string;
    }

    private List<Integer> getColumnWidths(Iterable<? extends T> entries) {
        ArrayList<Integer> columnWidths = new ArrayList<Integer>();
        for (int columnIndex = 0; columnIndex < this.columnNames.size(); ++columnIndex) {
            columnWidths.add(this.getMaxWidth(columnIndex, entries));
        }
        return columnWidths;
    }

    public void addEntry(T entry) {
        this.entries.add(entry);
    }

    public String createString() {
        return this.createString(this.entries);
    }

    public String createString(Iterable<? extends T> entries) {
        int columnIndex;
        List<Integer> widths = this.getColumnWidths(entries);
        int columnCount = this.columnNames.size();
        StringBuilder builder = new StringBuilder();
        for (columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            builder.append(DIVIDER_COLUMN);
            String columnHeader = "%-" + widths.get(columnIndex) + "s";
            builder.append(" " + String.format(columnHeader, this.columnNames.get(columnIndex)) + " ");
        }
        builder.append(DIVIDER_COLUMN);
        builder.append(this.NEW_LINE);
        builder.append(DIVIDER_COLUMN);
        for (columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            if (columnIndex > 0) {
                builder.append(LINE_ENDING);
            }
            builder.append(this.padLeft("", DIVIDER_ROW, widths.get(columnIndex)));
        }
        builder.append(LINE_ENDING);
        builder.append(this.NEW_LINE);
        for (T entry : entries) {
            for (int columnIndex2 = 0; columnIndex2 < columnCount; ++columnIndex2) {
                builder.append(DIVIDER_COLUMN);
                String format = "%-" + widths.get(columnIndex2) + "s";
                Function<T, String> function = this.columnFunctions.get(columnIndex2);
                String columnText = function.apply(entry);
                builder.append(" " + String.format(format, columnText) + " ");
            }
            builder.append(DIVIDER_COLUMN);
            builder.append(this.NEW_LINE);
        }
        return builder.toString();
    }

    public void setNewLine(String newline) {
        this.NEW_LINE = newline;
    }
}

