/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLContainer;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModUtils {
    private ModUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static String getModName(IForgeRegistryEntry.Impl<?> registerable) {
        String modID = registerable.getRegistryName().func_110624_b();
        ModContainer mod = ModUtils.getModContainer(modID);
        return mod != null ? mod.getName() : ("minecraft".equals(modID) ? "Minecraft" : "Unknown");
    }

    public static String getModName(Entity entity) {
        if (entity == null) {
            return "Unknown";
        }
        EntityRegistry.EntityRegistration reg = ModUtils.getRegistryInfo(entity);
        if (reg != null) {
            ModContainer mod = reg.getContainer();
            if (mod != null) {
                return mod.getName();
            }
            return "Unknown";
        }
        return "Minecraft";
    }

    public static EntityRegistry.EntityRegistration getRegistryInfo(Entity entity) {
        return ModUtils.getRegistryInfo(entity.getClass());
    }

    public static EntityRegistry.EntityRegistration getRegistryInfo(Class<? extends Entity> entity) {
        return EntityRegistry.instance().lookupModSpawn(entity, false);
    }

    public static ModContainer getModContainer(String modID) {
        return (ModContainer)Loader.instance().getIndexedModList().get(modID);
    }

    public static String getModName(String modId) {
        ModContainer mod = ModUtils.getModContainer(modId);
        return mod != null ? mod.getName() : modId;
    }

    @SideOnly(value=Side.CLIENT)
    public static CreativeTabs getTabFromLabel(String label) {
        for (CreativeTabs tab : CreativeTabs.field_78032_a) {
            if (!tab.func_78013_b().equalsIgnoreCase(label)) continue;
            return tab;
        }
        return null;
    }

    public static ResourceLocation getIdForCurrentContainer(String id) {
        int index = id.lastIndexOf(58);
        String entryName = index == -1 ? id : id.substring(index + 1);
        ModContainer mod = Loader.instance().activeModContainer();
        String prefix = mod == null || mod instanceof InjectedModContainer && ((InjectedModContainer)mod).wrappedContainer instanceof FMLContainer ? "minecraft" : mod.getModId().toLowerCase();
        return new ResourceLocation(prefix, entryName);
    }
}

