/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import net.darkhax.bookshelf.client.particle.OpenParticleDigging;
import net.darkhax.bookshelf.lib.Constants;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ParticleUtils {
    private ParticleUtils() {
        throw new IllegalAccessError("Utility class");
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean spawnDigParticles(ParticleManager manager, IBlockState state, World world, BlockPos pos, EnumFacing side) {
        if (state != null && state.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            float offset = 0.1f;
            AxisAlignedBB bounds = state.func_185900_c((IBlockAccess)world, pos);
            double xOffset = (double)x + Constants.RANDOM.nextDouble() * (bounds.field_72336_d - bounds.field_72340_a - (double)0.2f) + (double)0.1f + bounds.field_72340_a;
            double yOffset = (double)y + Constants.RANDOM.nextDouble() * (bounds.field_72337_e - bounds.field_72338_b - (double)0.2f) + (double)0.1f + bounds.field_72338_b;
            double zOffset = (double)z + Constants.RANDOM.nextDouble() * (bounds.field_72334_f - bounds.field_72339_c - (double)0.2f) + (double)0.1f + bounds.field_72339_c;
            if (side == EnumFacing.DOWN) {
                yOffset = (double)y + bounds.field_72338_b - (double)0.1f;
            } else if (side == EnumFacing.UP) {
                yOffset = (double)y + bounds.field_72337_e + (double)0.1f;
            } else if (side == EnumFacing.NORTH) {
                zOffset = (double)z + bounds.field_72339_c - (double)0.1f;
            } else if (side == EnumFacing.SOUTH) {
                zOffset = (double)z + bounds.field_72334_f + (double)0.1f;
            } else if (side == EnumFacing.WEST) {
                xOffset = (double)x + bounds.field_72340_a - (double)0.1f;
            } else if (side == EnumFacing.EAST) {
                xOffset = (double)x + bounds.field_72336_d + (double)0.1f;
            }
            manager.func_78873_a(new OpenParticleDigging(world, xOffset, yOffset, zOffset, 0.0, 0.0, 0.0, state).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean spawnBreakParticles(ParticleManager manager, IBlockState state, World world, BlockPos pos) {
        if (state.func_177230_c() != null) {
            int multiplier = 4;
            for (int xOffset = 0; xOffset < 4; ++xOffset) {
                for (int yOffset = 0; yOffset < 4; ++yOffset) {
                    for (int zOffset = 0; zOffset < 4; ++zOffset) {
                        double xPos = (double)pos.func_177958_n() + ((double)xOffset + 0.5) / 4.0;
                        double yPos = (double)pos.func_177956_o() + ((double)yOffset + 0.5) / 4.0;
                        double zPos = (double)pos.func_177952_p() + ((double)zOffset + 0.5) / 4.0;
                        manager.func_78873_a((Particle)new OpenParticleDigging(world, xPos, yPos, zPos, xPos - (double)pos.func_177958_n() - 0.5, yPos - (double)pos.func_177956_o() - 0.5, zPos - (double)pos.func_177952_p() - 0.5, state).func_174846_a(pos));
                    }
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnParticleRing(World world, EnumParticleTypes particle, double x, double y, double z, double velocityX, double velocityY, double velocityZ, double step) {
        for (double degree = 0.0; degree < Math.PI * 2; degree += step) {
            world.func_175688_a(particle, x + Math.cos(degree), y, z + Math.sin(degree), velocityX, velocityY, velocityZ, new int[0]);
        }
    }

    public static void spawnPercentageParticleRing(World world, EnumParticleTypes particle, float percentage, double x, double y, double z, double velocityX, double velocityY, double velocityZ, double step) {
        for (double degree = 0.0; degree < Math.PI * 2 * (double)percentage; degree += step) {
            world.func_175688_a(particle, x + Math.cos(degree), y, z + Math.sin(degree), velocityX, velocityY, velocityZ, new int[0]);
        }
    }

    public static void spawnWavingParticleRing(World world, EnumParticleTypes particle, float percentage, double x, double y, double z, double velocityX, double velocityY, double velocityZ, double step) {
        for (double degree = 0.0; degree <= Math.PI * 2 * (double)percentage; degree += 0.15) {
            world.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, x + Math.cos(degree), y - Math.cos(Math.sin(degree)) + 0.5, z + Math.sin(degree), 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

