/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.charms;

import java.util.List;
import net.darkhax.bookshelf.util.PlayerUtils;
import net.darkhax.darkutils.DarkUtils;
import net.darkhax.darkutils.features.DUFeature;
import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.charms.ItemCharm;
import net.darkhax.darkutils.features.charms.ItemNullCharm;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@DUFeature(name="Charms", description="A collection of charms which have unique effects")
public class FeatureCharms
extends Feature {
    public static Item itemAgressionCharm;
    public static Item itemFocusSash;
    public static Item itemGluttonyCharm;
    public static Item itemNullCharm;
    public static Item itemPortalCharm;
    public static Item itemSleepCharm;

    @Override
    public void onPreInit() {
        itemAgressionCharm = DarkUtils.REGISTRY.registerItem((Item)new ItemCharm(), "charm_agression");
        itemFocusSash = DarkUtils.REGISTRY.registerItem((Item)new ItemCharm(), "focus_sash");
        itemGluttonyCharm = DarkUtils.REGISTRY.registerItem((Item)new ItemCharm(), "charm_gluttony");
        itemNullCharm = DarkUtils.REGISTRY.registerItem((Item)new ItemNullCharm(), "charm_null");
        itemPortalCharm = DarkUtils.REGISTRY.registerItem((Item)new ItemCharm(), "charm_portal");
        itemSleepCharm = DarkUtils.REGISTRY.registerItem((Item)new ItemCharm(), "charm_sleep");
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        EntityPlayer player;
        EntityLivingBase entityBase = event.getEntityLiving();
        if (entityBase instanceof EntityPlayer && PlayerUtils.playerHasItem((EntityPlayer)((EntityPlayer)entityBase), (Item)itemFocusSash, (int)0) && entityBase.func_110143_aJ() >= entityBase.func_110138_aP() && event.getAmount() >= entityBase.func_110143_aJ()) {
            event.setAmount(entityBase.func_110143_aJ() - 1.0f);
            ((EntityPlayer)entityBase).func_145747_a((ITextComponent)new TextComponentTranslation("chat.darkutils.focussash", new Object[]{TextFormatting.GREEN}));
        }
        if (event.getSource() != null && event.getSource().func_76346_g() instanceof EntityPlayer && PlayerUtils.playerHasItem((EntityPlayer)(player = (EntityPlayer)event.getSource().func_76346_g()), (Item)itemAgressionCharm, (int)0)) {
            for (EntityLivingBase entity : player.func_130014_f_().func_72872_a(event.getEntityLiving().getClass(), player.func_174813_aQ().func_72321_a(32.0, 32.0, 32.0))) {
                entity.func_70604_c((EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void onItemUse(LivingEntityUseItemEvent.Tick event) {
        if (event.getEntityLiving() instanceof EntityPlayer && PlayerUtils.playerHasItem((EntityPlayer)((EntityPlayer)event.getEntityLiving()), (Item)itemGluttonyCharm, (int)0) && event.getItem() != null && event.getItem().func_77973_b() instanceof ItemFood) {
            event.setDuration(0);
        }
    }

    @SubscribeEvent
    public void onItemPickedUp(EntityItemPickupEvent event) {
        List charms = PlayerUtils.getStacksFromPlayer((EntityPlayer)event.getEntityPlayer(), (Item)itemNullCharm, (int)0);
        for (ItemStack charm : charms) {
            if (!ItemNullCharm.isBlackListed(event.getItem().func_92059_d(), charm)) continue;
            event.getItem().func_70106_y();
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer && entity.field_71087_bX) {
            player = (EntityPlayer)entity;
            if (PlayerUtils.playerHasItem((EntityPlayer)((EntityPlayer)entity), (Item)itemPortalCharm, (int)-1)) {
                player.field_82153_h = 100;
            }
        }
        if (entity instanceof EntityPlayer && (player = (EntityPlayer)entity).func_70608_bn() && PlayerUtils.playerHasItem((EntityPlayer)((EntityPlayer)entity), (Item)itemSleepCharm, (int)-1)) {
            player.field_71076_b = 100;
        }
    }
}

