/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.endertether;

import net.darkhax.darkutils.DarkUtils;
import net.darkhax.darkutils.features.DUFeature;
import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.endertether.BlockEnderTether;
import net.darkhax.darkutils.features.endertether.RendererEnderTether;
import net.darkhax.darkutils.features.endertether.TileEntityEnderTether;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@DUFeature(name="Ender Tether", description="A block to redirect ender teleportation")
public class FeatureEnderTether
extends Feature {
    public static Block blockEnderTether;
    protected static boolean affectPlayers;
    public static double tetherRange;

    @Override
    public void onPreInit() {
        blockEnderTether = DarkUtils.REGISTRY.registerBlock((Block)new BlockEnderTether(), "ender_tether");
        GameRegistry.registerTileEntity(TileEntityEnderTether.class, (String)"ender_tether");
    }

    @Override
    public void setupConfiguration(Configuration config) {
        tetherRange = config.getFloat("Tether Range", this.configName, 32.0f, 0.0f, 512.0f, "The range of the effect given by the tether. Distance is measured in blocks.");
        affectPlayers = config.getBoolean("Affect Players", this.configName, true, "Should the Ender Tether catch players using ender teleportation?");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPreInit() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEnderTether.class, (TileEntitySpecialRenderer)new RendererEnderTether());
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        if (event.getEntityLiving() instanceof EntityLivingBase && !event.getEntityLiving().field_70128_L && event.getEntityLiving().func_130014_f_() != null && !event.getEntityLiving().func_130014_f_().field_72995_K) {
            for (TileEntity tile : event.getEntityLiving().func_130014_f_().field_147482_g) {
                if (!(tile instanceof TileEntityEnderTether) || !((TileEntityEnderTether)tile).isEntityCloseEnough(event.getEntityLiving())) continue;
                BlockPos pos = tile.func_174877_v();
                event.setTargetX((double)((float)pos.func_177958_n() + 0.5f));
                event.setTargetY((double)pos.func_177956_o());
                event.setTargetZ((double)((float)pos.func_177952_p() + 0.5f));
                break;
            }
        }
    }

    static {
        affectPlayers = true;
        tetherRange = 32.0;
    }
}

