/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.shulkerpearl;

import net.darkhax.bookshelf.item.ItemBlockBasic;
import net.darkhax.darkutils.DarkUtils;
import net.darkhax.darkutils.features.DUFeature;
import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.shulkerpearl.BlockShulkerPearl;
import net.darkhax.darkutils.features.shulkerpearl.ItemShulkerPearl;
import net.darkhax.darkutils.features.shulkerpearl.ShulkerDataHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;

@DUFeature(name="Shulker Pearls", description="Adds shulker pearls and related content")
public class FeatureShulkerPearlItem
extends Feature {
    public static Item itemShulkerPearl;
    public static Block blockShulkerPearl;
    private boolean harvestablePearls = true;
    private int maxCooldown = 6000;

    @Override
    public void onPreInit() {
        itemShulkerPearl = DarkUtils.REGISTRY.registerItem((Item)new ItemShulkerPearl(), "shulker_pearl");
        blockShulkerPearl = new BlockShulkerPearl();
        DarkUtils.REGISTRY.registerBlock(blockShulkerPearl, (ItemBlock)new ItemBlockBasic(blockShulkerPearl, BlockShulkerPearl.types, false), "pearl_block");
        if (this.harvestablePearls) {
            ShulkerDataHandler.init();
        }
    }

    @Override
    public void onInit() {
        OreDictionary.registerOre((String)"blockPearl", (ItemStack)new ItemStack(blockShulkerPearl, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"gemPearl", (Item)itemShulkerPearl);
    }

    @Override
    public void setupConfiguration(Configuration config) {
        this.harvestablePearls = config.getBoolean("Harvest Pearls", this.configName, true, "Should pearls be harvestable from shulkers?");
        this.maxCooldown = config.getInt("Shulker Cooldown", this.configName, 6000, 0, Integer.MAX_VALUE, "The pearl harvest cooldown tile, in ticks");
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ShulkerDataHandler.ICustomData data;
        if (event.getSide().equals((Object)Side.SERVER) && this.harvestablePearls && event.getTarget() instanceof EntityShulker && (data = ShulkerDataHandler.getData(event.getTarget())) != null && data.getCooldown() <= 0) {
            event.getTarget().func_70099_a(new ItemStack(itemShulkerPearl), 0.5f);
            data.setCooldown(this.maxCooldown);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (this.harvestablePearls && event.getEntity() instanceof EntityShulker) {
            ShulkerDataHandler.ICustomData data = ShulkerDataHandler.getData(event.getEntity());
            int current = data.getCooldown();
            if (data != null && current > 0) {
                data.setCooldown(current - 1);
            }
        }
    }
}

