/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.vector;

import net.darkhax.darkutils.DarkUtils;
import net.darkhax.darkutils.features.DUFeature;
import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.vector.BlockVectorPlate;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;

@DUFeature(name="Vector Plate", description="A block that pushes entities around")
public class FeatureVectorPlate
extends Feature {
    public static Block blockVectorPlate;
    public static Block blockFastVectorPlate;
    public static Block blockHyperVectorPlate;
    public static Block blockUndergroundVectorPlate;
    public static Block blockUndergroundFastVectorPlate;
    public static Block blockUndergroundHyperVectorPlate;
    protected static boolean preventItemDespawn;
    protected static boolean preventItemPickup;
    private static double normalSpeed;
    private static double fastSpeed;
    private static double hyperSpeed;

    @Override
    public void onPreInit() {
        blockVectorPlate = new BlockVectorPlate(normalSpeed);
        DarkUtils.REGISTRY.registerBlock(blockVectorPlate, "trap_move");
        blockFastVectorPlate = new BlockVectorPlate(fastSpeed);
        DarkUtils.REGISTRY.registerBlock(blockFastVectorPlate, "trap_move_fast");
        blockHyperVectorPlate = new BlockVectorPlate(hyperSpeed);
        DarkUtils.REGISTRY.registerBlock(blockHyperVectorPlate, "trap_move_hyper");
    }

    @Override
    public void setupConfiguration(Configuration config) {
        preventItemDespawn = config.getBoolean("Prevent Item Despawn", this.configName, true, "Should vector plates prevent item despawn?");
        preventItemPickup = config.getBoolean("Prevent Item Pickup", this.configName, true, "Should vector plates prevent items from being picked up, while they are being pushed?");
        normalSpeed = config.getFloat("Normal Speed", this.configName, 0.06f, 0.0f, 5.0f, "Speed modifier for the normal vector plate");
        fastSpeed = config.getFloat("Fast Speed", this.configName, 0.3f, 0.0f, 5.0f, "Speed modifier for the fast vector plate");
        hyperSpeed = config.getFloat("Hyper Speed", this.configName, 1.5f, 0.0f, 5.0f, "Speed modifier for the hyper vector plate");
    }

    static {
        preventItemDespawn = true;
        preventItemPickup = true;
        normalSpeed = 0.06;
        fastSpeed = 0.3;
        hyperSpeed = 1.5;
    }
}

