/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.blocks.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import p455w0rd.danknull.api.IRedstoneControllable;
import p455w0rd.danknull.api.ITOPBlockDisplayOverride;
import p455w0rd.danknull.init.ModBlocks;
import p455w0rd.danknull.init.ModGlobals;
import p455w0rd.danknull.inventory.InventoryDankNull;
import p455w0rd.danknull.util.DankNullUtils;

public class TileDankNullDock
extends TileEntity
implements IRedstoneControllable,
ITOPBlockDisplayOverride,
ISidedInventory {
    private static final String TAG_REDSTONEMODE = "RedstoneMode";
    private static final String TAG_HAS_REDSTONE_SIGNAL = "HasRSSignal";
    public static final String TAG_ITEMSTACK = "DankNullStack";
    public static final String TAG_NAME = "PWDock";
    private static final String TAG_SELECTEDSTACK = "SelectedStack";
    private static ItemStack selectedStack = ItemStack.field_190927_a;
    private RedstoneMode redstoneMode = RedstoneMode.REQUIRED;
    private boolean hasRedstoneSignal = false;
    private ItemStack dankNullStack = ItemStack.field_190927_a;
    private NonNullList<ItemStack> slots = NonNullList.func_191196_a();
    InventoryDankNull inventory;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return !this.getStack().func_190926_b() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.DOWN || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (!this.getStack().func_190926_b() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.DOWN) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new SidedInvWrapper((ISidedInventory)this, facing));
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean overrideStandardInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState state, IProbeHitData data) {
        if (state.func_177230_c() == ModBlocks.DANKNULL_DOCK) {
            ItemStack stack = new ItemStack((Block)ModBlocks.DANKNULL_DOCK);
            TileEntity tile = world.func_175625_s(data.getPos());
            if (tile != null && tile instanceof TileDankNullDock) {
                TileDankNullDock te = (TileDankNullDock)tile;
                stack.func_77983_a("BlockEntityTag", (NBTBase)te.func_189515_b(new NBTTagCompound()));
                String msg = te.getStack().func_190926_b() ? "Right-click with /dank/null" : "Right-click with empty hand to open GUI";
                ItemStack dockedDankNull = te.getStack().func_190926_b() ? ItemStack.field_190927_a : te.getStack();
                IProbeInfo topTip = probeInfo.horizontal().item(stack).vertical().itemLabel(stack).text(msg);
                if (!dockedDankNull.func_190926_b()) {
                    String dockedMsg = ModGlobals.Rarities.getRarityFromMeta((int)dockedDankNull.func_77952_i()).field_77937_e + "" + dockedDankNull.func_82833_r() + "" + TextFormatting.WHITE + " Docked";
                    topTip.text("").text(dockedMsg);
                }
                topTip.text(TextStyleClass.MODNAME.toString() + Tools.getModName((Block)state.func_177230_c()));
                return true;
            }
        }
        return false;
    }

    public InventoryDankNull getInventory() {
        if (this.inventory == null && !this.getStack().func_190926_b()) {
            this.inventory = DankNullUtils.getNewDankNullInventory(this.getStack());
        }
        return this.inventory;
    }

    public void setInventory(InventoryDankNull inv) {
        this.inventory = inv;
    }

    public void resetInventory() {
        this.inventory = null;
    }

    public void setStack(@Nonnull ItemStack stack) {
        this.dankNullStack = stack;
        this.func_70296_d();
    }

    public int slotCount() {
        return !this.getStack().func_190926_b() ? this.getStack().func_77952_i() + 9 : 0;
    }

    public ItemStack getSelectedStack() {
        return selectedStack;
    }

    public void setSelectedStack(ItemStack stack) {
        selectedStack = stack;
    }

    public ItemStack getStack() {
        return this.dankNullStack;
    }

    public NonNullList<ItemStack> getSlots() {
        return this.slots;
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.func_70296_d();
    }

    @Override
    public boolean isRedstoneRequirementMet() {
        switch (this.getRedstoneMode()) {
            default: {
                return true;
            }
            case REQUIRED: {
                return this.hasRSSignal();
            }
            case REQUIRE_NONE: 
        }
        return !this.hasRSSignal();
    }

    @Override
    public boolean hasRSSignal() {
        return this.hasRedstoneSignal;
    }

    @Override
    public void setRSSignal(boolean isPowered) {
        this.hasRedstoneSignal = isPowered;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 255, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_70296_d() {
        IBlockState state;
        super.func_70296_d();
        if (this.func_145831_w() != null && (state = this.func_145831_w().func_180495_p(this.field_174879_c)) != null) {
            this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagCompound nbt = compound.func_74775_l(TAG_NAME);
        this.setRedstoneMode(RedstoneMode.values()[nbt.func_74762_e(TAG_REDSTONEMODE)]);
        this.setRSSignal(nbt.func_74767_n(TAG_HAS_REDSTONE_SIGNAL));
        NBTTagCompound itemNBT = compound.func_74775_l(TAG_ITEMSTACK);
        ItemStack newStack = itemNBT == null ? ItemStack.field_190927_a : new ItemStack(itemNBT);
        this.setStack(newStack);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        NBTTagCompound itemNBT = new NBTTagCompound();
        compound.func_74768_a(TAG_REDSTONEMODE, this.redstoneMode.ordinal());
        compound.func_74757_a(TAG_HAS_REDSTONE_SIGNAL, this.hasRSSignal());
        if (!this.getSelectedStack().func_190926_b()) {
            NBTTagCompound selectedItemNBT = new NBTTagCompound();
            this.getSelectedStack().func_77955_b(selectedItemNBT);
            compound.func_74782_a(TAG_SELECTEDSTACK, (NBTBase)selectedItemNBT);
        }
        if (!this.getStack().func_190926_b()) {
            this.getStack().func_77955_b(itemNBT);
            compound.func_74782_a(TAG_ITEMSTACK, (NBTBase)itemNBT);
        }
        return compound;
    }

    public int func_70302_i_() {
        return !this.getStack().func_190926_b() ? this.getInventory().func_70302_i_() : 0;
    }

    public ItemStack func_70301_a(int index) {
        return !this.getStack().func_190926_b() ? this.getInventory().func_70301_a(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack ret = !this.getStack().func_190926_b() ? this.getInventory().func_70298_a(index, count) : ItemStack.field_190927_a;
        DankNullUtils.reArrangeStacks(this.getInventory());
        return ret;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.getInventory().func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return !this.getStack().func_190926_b() ? Integer.MAX_VALUE : 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return "danknull-inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (!this.getStack().func_190926_b() && side == EnumFacing.DOWN) {
            int[] slots = new int[this.func_70302_i_()];
            for (int i = 0; i < slots.length; ++i) {
                slots[i] = i;
            }
            return slots;
        }
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (!this.getStack().func_190926_b() && DankNullUtils.getExtractionModeForStack(this.getStack(), stack) != DankNullUtils.SlotExtractionMode.KEEP_ALL) {
            int numToKeep = DankNullUtils.getExtractionModeForStack(this.getStack(), stack).getNumberToKeep();
            if (stack.func_190916_E() > numToKeep) {
                return true;
            }
        }
        return false;
    }

    public boolean func_191420_l() {
        return !this.getStack().func_190926_b();
    }

    public static enum RedstoneMode {
        REQUIRED,
        REQUIRE_NONE,
        IGNORED;

    }
}

