/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.init;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import p455w0rd.danknull.blocks.tiles.TileDankNullDock;
import p455w0rd.danknull.entity.EntityPFakePlayer;
import p455w0rd.danknull.init.ModGlobals;
import p455w0rd.danknull.init.ModKeyBindings;
import p455w0rd.danknull.init.ModRecipes;
import p455w0rd.danknull.inventory.InventoryDankNull;
import p455w0rd.danknull.util.DankNullUtils;
import p455w0rdslib.util.EasyMappings;

public class ModEvents {
    private static final ModEvents INSTANCE = new ModEvents();
    private int remainingHighlightTicks;
    private String highlightItemName = "";

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    public static ModEvents getInstance() {
        return INSTANCE;
    }

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.player instanceof EntityPlayerMP) {
            EntityPFakePlayer.getFakePlayerForParent((EntityPlayerMP)e.player);
        }
    }

    @SubscribeEvent
    public void onRecipeRegistryReady(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModRecipes.getInstance().getArray());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onModelRegistryReady(ModelRegistryEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderOverlayEvent(RenderGameOverlayEvent e) {
        if (ModGlobals.GUI_DANKNULL_ISOPEN && (e.getType() == RenderGameOverlayEvent.ElementType.HOTBAR || e.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS || e.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE || e.getType() == RenderGameOverlayEvent.ElementType.FOOD || e.getType() == RenderGameOverlayEvent.ElementType.HEALTH || e.getType() == RenderGameOverlayEvent.ElementType.ARMOR)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemPickUp(EntityItemPickupEvent e) {
        InventoryDankNull inventory;
        EntityPlayer player = e.getEntityPlayer();
        ItemStack entityStack = e.getItem().func_92059_d();
        if (entityStack.func_190926_b() || player == null) {
            return;
        }
        ItemStack dankNull = DankNullUtils.getDankNullForStack(player, entityStack);
        if (!dankNull.func_190926_b() && (inventory = DankNullUtils.getInventoryFromStack(dankNull)) != null && DankNullUtils.addFilteredStackToDankNull(inventory, entityStack)) {
            entityStack.func_190920_e(0);
            return;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        EntityPlayer player = EasyMappings.player();
        ItemStack dankNullItem = ItemStack.field_190927_a;
        dankNullItem = DankNullUtils.getDankNull(player);
        InventoryDankNull inventory = DankNullUtils.getInventoryFromHeld(player);
        if (dankNullItem.func_190926_b() || !DankNullUtils.isDankNull(dankNullItem)) {
            return;
        }
        int currentIndex = DankNullUtils.getSelectedStackIndex(inventory);
        int totalSize = DankNullUtils.getItemCount(inventory);
        if (currentIndex == -1 || totalSize <= 1) {
            return;
        }
        if (ModKeyBindings.getNextItemKeyBind().func_151468_f()) {
            DankNullUtils.setNextSelectedStack(inventory, player);
        } else if (ModKeyBindings.getPreviousItemKeyBind().func_151468_f()) {
            DankNullUtils.setPreviousSelectedStack(inventory, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        EntityPlayer player = EasyMappings.player();
        ItemStack dankNullItem = ItemStack.field_190927_a;
        dankNullItem = DankNullUtils.getDankNull(player);
        InventoryDankNull inventory = DankNullUtils.getInventoryFromHeld(player);
        if (dankNullItem.func_190926_b() || !DankNullUtils.isDankNull(dankNullItem)) {
            return;
        }
        if (event.getDwheel() == 0) {
            int currentIndex = DankNullUtils.getSelectedStackIndex(inventory);
            int totalSize = DankNullUtils.getItemCount(inventory);
            if (currentIndex == -1 || totalSize <= 1) {
                return;
            }
            if (ModKeyBindings.getNextItemKeyBind().func_151468_f()) {
                DankNullUtils.setNextSelectedStack(inventory, player);
                event.setCanceled(true);
            } else if (ModKeyBindings.getPreviousItemKeyBind().func_151468_f()) {
                DankNullUtils.setPreviousSelectedStack(inventory, player);
                event.setCanceled(true);
            }
        } else if (player.func_70093_af()) {
            int currentIndex = DankNullUtils.getSelectedStackIndex(inventory);
            int totalSize = DankNullUtils.getItemCount(inventory);
            if (currentIndex == -1 || totalSize <= 1) {
                return;
            }
            int scrollForward = event.getDwheel();
            if (scrollForward < 0) {
                DankNullUtils.setNextSelectedStack(inventory, player);
                event.setCanceled(true);
            } else if (scrollForward > 0) {
                DankNullUtils.setPreviousSelectedStack(inventory, player);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        BlockPos pos = event.getPos();
        EnumHand hand = event.getHand();
        TileDankNullDock te = null;
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileDankNullDock) {
            te = (TileDankNullDock)world.func_175625_s(pos);
        }
        if (te != null && player.func_184586_b(hand).func_190926_b() && player.func_70093_af() && !te.getStack().func_190926_b()) {
            player.func_184611_a(hand, te.getStack());
            te.setStack(ItemStack.field_190927_a);
            te.setSelectedStack(ItemStack.field_190927_a);
            te.resetInventory();
        }
    }

    public void setSelectedMessage(String msg) {
        this.highlightItemName = msg;
        this.remainingHighlightTicks = 160;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.PlayerTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null) {
            if (this.highlightItemName.isEmpty()) {
                this.remainingHighlightTicks = 0;
            } else if (!this.highlightItemName.isEmpty() && this.remainingHighlightTicks > 0) {
                --this.remainingHighlightTicks;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPostRenderOverlay(RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.SUBTITLES) {
            this.renderSelectedItem();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderSelectedItem() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71424_I.func_76320_a("dankNullSelectedItem");
        ScaledResolution scaledRes = new ScaledResolution(mc);
        if (this.remainingHighlightTicks > 0 && !this.highlightItemName.isEmpty()) {
            int k;
            int i = (scaledRes.func_78326_a() - mc.field_71466_p.func_78256_a(this.highlightItemName)) / 2;
            int j = scaledRes.func_78328_b() - 47;
            if (!mc.field_71442_b.func_78755_b()) {
                j += 14;
            }
            if ((k = (int)((float)this.remainingHighlightTicks * 256.0f / 10.0f)) > 255) {
                k = 255;
            }
            if (k > 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
                mc.field_71466_p.func_175063_a(this.highlightItemName, (float)i, (float)j, 0xFFFFFF + (k << 24));
                GlStateManager.func_179121_F();
            }
        }
        mc.field_71424_I.func_76319_b();
    }
}

