/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.items;

import net.minecraft.block.Block;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemEgg;
import net.minecraft.item.ItemEnderPearl;
import net.minecraft.item.ItemSnowball;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import p455w0rd.danknull.api.IModelHolder;
import p455w0rd.danknull.client.render.DankNullRenderer;
import p455w0rd.danknull.client.render.PModelRegistryHelper;
import p455w0rd.danknull.entity.EntityPFakePlayer;
import p455w0rd.danknull.init.ModGlobals;
import p455w0rd.danknull.init.ModGuiHandler;
import p455w0rd.danknull.inventory.InventoryDankNull;
import p455w0rd.danknull.util.DankNullUtils;

public class ItemDankNull
extends Item
implements IModelHolder {
    public static String INV_NAME = "danknull-inventory";
    InventoryDankNull inventory = null;

    public ItemDankNull() {
        this.setRegistryName("dank_null");
        this.func_77655_b("dank_null");
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        return new ICapabilityProvider(){

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return (T)(this.hasCapability(capability, facing) ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new InvWrapper((IInventory)DankNullUtils.getNewDankNullInventory(stack))) : null);
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i = 0; i < 6; ++i) {
            PModelRegistryHelper.registerMetaRenderer(this, DankNullRenderer.getInstance(), i);
        }
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)(this.func_77657_g(stack) + "_" + this.getDamage(stack) + ".name")).trim();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (playerIn.func_70093_af()) {
            ModGuiHandler.launchGui(ModGuiHandler.GUIType.DANKNULL, playerIn, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!worldIn.field_72995_K) {
            InventoryDankNull inventory = new InventoryDankNull(stack);
            ItemStack selectedStack = DankNullUtils.getSelectedStack(inventory);
            if (selectedStack.func_77973_b() instanceof ItemSnowball || selectedStack.func_77973_b() instanceof ItemEnderPearl || selectedStack.func_77973_b() instanceof ItemEgg) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            EntityPFakePlayer fakePlayer = EntityPFakePlayer.getFakePlayerForParent((EntityPlayerMP)playerIn);
            if (fakePlayer.field_71134_c.func_73081_b() != GameType.NOT_SET) {
                fakePlayer.field_71134_c.func_73076_a(GameType.NOT_SET);
            }
            fakePlayer.func_184611_a(hand, selectedStack);
            fakePlayer.setItemInHand(selectedStack);
            fakePlayer.field_70165_t = playerIn.field_70165_t;
            fakePlayer.field_70163_u = playerIn.field_70163_u;
            fakePlayer.field_70161_v = playerIn.field_70161_v;
            fakePlayer.func_70034_d(playerIn.field_70759_as);
            fakePlayer.field_70177_z = playerIn.field_70177_z;
            fakePlayer.field_70125_A = playerIn.field_70125_A;
            fakePlayer.eyeHeight = playerIn.eyeHeight;
            if (selectedStack.func_77946_l().func_77973_b().func_77659_a(worldIn, (EntityPlayer)fakePlayer, hand).func_188397_a() == EnumActionResult.SUCCESS) {
                DankNullUtils.decrSelectedStackSize(inventory, 0);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < 6; ++i) {
                subItems.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public boolean func_77614_k() {
        return true;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public boolean func_77645_m() {
        return false;
    }

    private Block getBlockUnderPlayer(EntityPlayer player) {
        int blockX = MathHelper.func_76128_c((double)player.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)(player.func_174813_aQ().field_72338_b - 1.0));
        int blockZ = MathHelper.func_76128_c((double)player.field_70161_v);
        return player.func_130014_f_().func_180495_p(new BlockPos(blockX, blockY, blockZ)).func_177230_c();
    }

    public RayTraceResult rayTrace(EntityPlayer player, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = player.func_174824_e(partialTicks);
        Vec3d vec3d1 = player.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return player.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos posIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        Block blockUnderPlayer = this.getBlockUnderPlayer(player);
        if (player.func_70093_af() && blockUnderPlayer != Blocks.field_150350_a) {
            ModGuiHandler.launchGui(ModGuiHandler.GUIType.DANKNULL, player, worldIn, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return EnumActionResult.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        InventoryDankNull inventory = new InventoryDankNull(stack);
        ItemStack selectedStack = DankNullUtils.getSelectedStack(inventory);
        IBlockState state = worldIn.func_180495_p(posIn);
        Block block = state.func_177230_c();
        BlockPos pos = posIn;
        if (selectedStack.func_190926_b() || selectedStack.func_77973_b() instanceof ItemBlock || !(selectedStack.func_77973_b() instanceof ItemBlockSpecial)) {
            // empty if block
        }
        if (block.func_176200_f((IBlockAccess)worldIn, posIn) && block == Blocks.field_150431_aC) {
            facing = EnumFacing.UP;
        } else if (block.func_176200_f((IBlockAccess)worldIn, posIn)) {
            pos = posIn.func_177972_a(facing);
        }
        if (DankNullUtils.getSelectedStackSize(inventory) > 0 && player.func_175151_a(posIn, facing, stack)) {
            pos = posIn.func_177972_a(facing);
            Block selectedBlock = Block.func_149634_a((Item)selectedStack.func_77973_b());
            int meta = selectedStack.func_77960_j();
            if (selectedBlock instanceof BlockStairs || selectedBlock instanceof BlockBanner) {
                IBlockState newState = selectedBlock.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, (EntityLivingBase)player);
                EnumActionResult result = DankNullUtils.placeBlock(newState, worldIn, pos);
                if (worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof TileEntityBanner) {
                    if (facing == EnumFacing.UP) {
                        int i = MathHelper.func_76128_c((double)((double)((player.field_70177_z + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
                        worldIn.func_180501_a(pos, Blocks.field_180393_cK.func_176223_P().func_177226_a((IProperty)BlockStandingSign.field_176413_a, (Comparable)Integer.valueOf(i)), 3);
                    } else {
                        worldIn.func_180501_a(pos, Blocks.field_180394_cL.func_176223_P().func_177226_a((IProperty)BlockWallSign.field_176412_a, (Comparable)facing), 3);
                    }
                    ((TileEntityBanner)worldIn.func_175625_s(pos)).func_175112_a(selectedStack, false);
                }
                if (result != EnumActionResult.FAIL) {
                    SoundType soundType = block.getSoundType(newState, worldIn, pos, (Entity)player);
                    worldIn.func_184133_a((EntityPlayer)null, player.func_180425_c(), soundType.func_185841_e(), SoundCategory.BLOCKS, 1.0f, 0.5f * ((worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.7f + 2.0f));
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    DankNullUtils.decrSelectedStackSize(inventory, 1);
                }
                if (FMLCommonHandler.instance().getSide().isServer()) {
                    // empty if block
                }
                return EnumActionResult.PASS;
            }
            if (!(selectedStack.func_77973_b() instanceof ItemBucket || selectedStack.func_77973_b() instanceof UniversalBucket || selectedStack.func_77973_b() instanceof ItemSnowball || selectedStack.func_77973_b() instanceof ItemEnderPearl || selectedStack.func_77973_b() instanceof ItemEgg)) {
                EntityPFakePlayer fakePlayer = EntityPFakePlayer.getFakePlayerForParent((EntityPlayerMP)player);
                if (fakePlayer.field_71134_c.func_73081_b() != GameType.NOT_SET) {
                    fakePlayer.field_71134_c.func_73076_a(GameType.NOT_SET);
                }
                fakePlayer.func_184611_a(hand, selectedStack.func_77946_l());
                fakePlayer.setItemInHand(selectedStack.func_77946_l());
                fakePlayer.field_70165_t = player.field_70165_t;
                fakePlayer.field_70163_u = player.field_70163_u;
                fakePlayer.field_70161_v = player.field_70161_v;
                fakePlayer.func_70034_d(player.field_70759_as);
                fakePlayer.field_70177_z = player.field_70177_z;
                fakePlayer.field_70125_A = player.field_70125_A;
                fakePlayer.eyeHeight = player.eyeHeight;
                EnumActionResult result = selectedStack.func_77946_l().func_179546_a((EntityPlayer)fakePlayer, worldIn, posIn, hand, facing, hitX, hitY, hitZ);
                if (result == EnumActionResult.PASS) {
                    selectedStack.func_77946_l().func_77973_b().func_77659_a(worldIn, (EntityPlayer)fakePlayer, hand).func_188397_a();
                } else if (result == EnumActionResult.SUCCESS && !player.field_71075_bZ.field_75098_d) {
                    DankNullUtils.decrSelectedStackSize(inventory, 1);
                }
                return EnumActionResult.PASS;
            }
        }
        return EnumActionResult.PASS;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return ModGlobals.Rarities.getRarityFromMeta(stack.func_77952_i());
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.func_77969_a(newStack) || slotChanged;
    }
}

