/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import p455w0rd.danknull.DankNull;
import p455w0rd.danknull.init.ModEvents;
import p455w0rd.danknull.init.ModItems;
import p455w0rd.danknull.init.ModLogger;
import p455w0rd.danknull.init.ModNetworking;
import p455w0rd.danknull.inventory.DankNullItemHandler;
import p455w0rd.danknull.inventory.InventoryDankNull;
import p455w0rd.danknull.items.ItemDankNull;
import p455w0rd.danknull.network.PacketSetSelectedItem;
import p455w0rd.danknull.recipes.RecipeDankNullUpgrade;
import p455w0rdslib.util.ItemUtils;

public class DankNullUtils {
    public static final String TAG_EXTRACTION_MODES = "ExtractionModes";

    @Nonnull
    public static ItemStack getDankNull(EntityPlayer player) {
        InventoryPlayer playerInv = player.field_71071_by;
        ItemStack dankNullItem = ItemStack.field_190927_a;
        if (!player.func_184614_ca().func_190926_b()) {
            if (player.func_184614_ca().func_77973_b() instanceof ItemDankNull) {
                dankNullItem = player.func_184586_b(EnumHand.MAIN_HAND);
            } else if (!player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof ItemDankNull) {
                dankNullItem = player.func_184586_b(EnumHand.OFF_HAND);
            }
        } else if (!player.func_184592_cb().func_190926_b()) {
            if (player.func_184592_cb().func_77973_b() instanceof ItemDankNull) {
                dankNullItem = player.func_184586_b(EnumHand.OFF_HAND);
            } else if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemDankNull) {
                dankNullItem = player.func_184586_b(EnumHand.MAIN_HAND);
            }
        }
        if (dankNullItem.func_190926_b()) {
            int invSize = playerInv.func_70302_i_();
            if (invSize <= 0) {
                return ItemStack.field_190927_a;
            }
            for (int i = 0; i < invSize; ++i) {
                ItemStack itemStack = playerInv.func_70301_a(i);
                if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof ItemDankNull)) continue;
                dankNullItem = itemStack;
                break;
            }
        }
        return dankNullItem;
    }

    public static List<ItemStack> getAllDankNulls(EntityPlayer player) {
        InventoryPlayer playerInv = player.field_71071_by;
        ArrayList dankNullList = Lists.newArrayList();
        for (ItemStack stack : playerInv.field_70462_a) {
            if (!DankNullUtils.isDankNull(stack)) continue;
            dankNullList.add(stack);
        }
        if (!playerInv.field_184439_c.isEmpty() && ((ItemStack)playerInv.field_184439_c.get(0)).func_77973_b() == ModItems.DANK_NULL) {
            dankNullList.add(playerInv.field_184439_c.get(0));
        }
        return dankNullList;
    }

    @Nonnull
    public static InventoryDankNull getFirstDankNullForStack(EntityPlayer player, ItemStack stack) {
        InventoryDankNull dankNullInv = null;
        List<ItemStack> dankNulls = DankNullUtils.getAllDankNulls(player);
        for (ItemStack dankNull : dankNulls) {
            InventoryDankNull tmpInv = DankNullUtils.getNewDankNullInventory(dankNull);
            if (!DankNullUtils.isFiltered(tmpInv, stack)) continue;
            dankNullInv = tmpInv;
            break;
        }
        return dankNullInv;
    }

    public static ItemStack getDankNullForStack(EntityPlayer player, ItemStack stack) {
        InventoryPlayer playerInv = player.field_71071_by;
        ItemStack dankNullItem = ItemStack.field_190927_a;
        int invSize = playerInv.func_70302_i_();
        if (invSize <= 0) {
            return ItemStack.field_190927_a;
        }
        for (int i = 0; i < invSize; ++i) {
            ItemStack itemStack = playerInv.func_70301_a(i);
            if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof ItemDankNull) || !DankNullUtils.isFiltered(DankNullUtils.getNewDankNullInventory(itemStack), stack)) continue;
            dankNullItem = itemStack;
            break;
        }
        return dankNullItem;
    }

    public static void reArrangeStacks(InventoryDankNull inventory) {
        if (inventory != null) {
            int i;
            int count = 0;
            NonNullList stackList = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                stackList.set(count, (Object)inventory.func_70301_a(i));
                ++count;
            }
            if (stackList.size() == 0) {
                DankNullUtils.setSelectedStackIndex(inventory, -1);
            } else {
                for (i = 0; i < stackList.size(); ++i) {
                    inventory.func_70299_a(i, (ItemStack)stackList.get(i));
                }
                for (i = stackList.size(); i < inventory.func_70302_i_(); ++i) {
                    inventory.func_70299_a(i, ItemStack.field_190927_a);
                }
            }
            DankNullUtils.setSelectedIndexApplicable(inventory);
        }
    }

    public static NonNullList<ItemStack> getInventoryListArray(InventoryDankNull inventory) {
        if (inventory != null) {
            return inventory.getStacks();
        }
        return NonNullList.func_191196_a();
    }

    public static int getSelectedStackIndex(InventoryDankNull inventory) {
        if (inventory != null && !inventory.getDankNull().func_190926_b()) {
            ItemStack dankNull = inventory.getDankNull();
            if (!dankNull.func_77942_o()) {
                dankNull.func_77982_d(new NBTTagCompound());
            }
            if (!dankNull.func_77978_p().func_74764_b("selectedIndex")) {
                dankNull.func_77978_p().func_74768_a("selectedIndex", 0);
            }
            return dankNull.func_77978_p().func_74762_e("selectedIndex");
        }
        return -1;
    }

    public static boolean isDankNull(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemDankNull;
    }

    public static void setSelectedStackIndex(InventoryDankNull inventory, int index) {
        if (inventory != null && !inventory.getDankNull().func_190926_b()) {
            DankNullUtils.setSelectedStackIndex(inventory, index, true);
        }
    }

    public static void setSelectedStackIndex(InventoryDankNull inventory, int index, boolean sync) {
        if (inventory != null && !inventory.getDankNull().func_190926_b()) {
            ItemStack dankNull = inventory.getDankNull();
            if (!dankNull.func_77942_o()) {
                dankNull.func_77982_d(new NBTTagCompound());
            }
            dankNull.func_77978_p().func_74768_a("selectedIndex", index);
            if (FMLCommonHandler.instance().getSide().isClient()) {
                ModNetworking.INSTANCE.sendToServer((IMessage)new PacketSetSelectedItem(index));
            }
        }
    }

    public static void setNextSelectedStack(InventoryDankNull inventory) {
        if (inventory != null && !inventory.getDankNull().func_190926_b()) {
            DankNullUtils.setNextSelectedStack(inventory, null);
        }
    }

    public static void setNextSelectedStack(InventoryDankNull inventory, EntityPlayer player) {
        int currentIndex = DankNullUtils.getSelectedStackIndex(inventory);
        int totalSize = DankNullUtils.getItemCount(inventory);
        int maxIndex = totalSize - 1;
        int newIndex = 0;
        if (totalSize > 1) {
            if (currentIndex == maxIndex) {
                newIndex = 0;
                ModNetworking.INSTANCE.sendToServer((IMessage)new PacketSetSelectedItem(newIndex));
                DankNullUtils.setSelectedStackIndex(inventory, newIndex);
            } else {
                newIndex = currentIndex + 1;
                ModNetworking.INSTANCE.sendToServer((IMessage)new PacketSetSelectedItem(newIndex));
                DankNullUtils.setSelectedStackIndex(inventory, newIndex);
            }
            if (player != null) {
                DankNullUtils.displaySelectedMessage(inventory, player, newIndex);
            }
        }
    }

    public static void displaySelectedMessage(InventoryDankNull inventory, EntityPlayer player, int index) {
        if (!DankNullUtils.getItemByIndex(inventory, index).func_190926_b()) {
            DankNullUtils.reArrangeStacks(inventory);
        }
        String message = TextFormatting.YELLOW + "" + TextFormatting.ITALIC + "" + DankNullUtils.getItemByIndex(inventory, index).func_82833_r() + " Selected";
        if (player.func_130014_f_().field_72995_K) {
            ModEvents.getInstance().setSelectedMessage(message);
        }
    }

    public static void setPreviousSelectedStack(InventoryDankNull inventory, EntityPlayer player) {
        int currentIndex = DankNullUtils.getSelectedStackIndex(inventory);
        int totalSize = DankNullUtils.getItemCount(inventory);
        int maxIndex = totalSize - 1;
        int newIndex = 0;
        if (totalSize > 1) {
            if (currentIndex == 0) {
                newIndex = maxIndex;
                ModNetworking.INSTANCE.sendToServer((IMessage)new PacketSetSelectedItem(newIndex));
                DankNullUtils.setSelectedStackIndex(inventory, newIndex);
            } else {
                newIndex = currentIndex - 1;
                ModNetworking.INSTANCE.sendToServer((IMessage)new PacketSetSelectedItem(newIndex));
                DankNullUtils.setSelectedStackIndex(inventory, newIndex);
            }
            if (player != null) {
                DankNullUtils.displaySelectedMessage(inventory, player, newIndex);
            }
        }
    }

    public static int getItemCount(InventoryDankNull inventory) {
        int count = 0;
        if (inventory != null) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (inventory.func_70301_a(i).func_190926_b()) continue;
                ++count;
            }
        }
        return count;
    }

    public static void decrSelectedStackSize(InventoryDankNull inventory, int amount) {
        if (inventory == null || inventory.getDankNull().func_190926_b()) {
            return;
        }
        DankNullUtils.getSelectedStack(inventory).func_190918_g(amount);
        DankNullUtils.reArrangeStacks(inventory);
    }

    public static int getSelectedStackSize(InventoryDankNull inventory) {
        ItemStack selectedStack;
        if (inventory != null && !inventory.getDankNull().func_190926_b() && !(selectedStack = DankNullUtils.getSelectedStack(inventory)).func_190926_b()) {
            return selectedStack.func_190916_E();
        }
        return 0;
    }

    public static InventoryDankNull getInventoryFromHeld(EntityPlayer player) {
        ItemStack dankNull = ItemStack.field_190927_a;
        if (player != null) {
            if (player.func_184614_ca().func_77973_b() == ModItems.DANK_NULL) {
                dankNull = player.func_184614_ca();
            } else if (player.func_184592_cb().func_77973_b() == ModItems.DANK_NULL) {
                dankNull = player.func_184592_cb();
            }
            if (!dankNull.func_190926_b() && DankNullUtils.isDankNull(dankNull)) {
                return DankNullUtils.getInventoryFromStack(dankNull);
            }
        }
        return null;
    }

    public static ItemStack getSelectedStack(InventoryDankNull inventory) {
        if (inventory != null && !inventory.getDankNull().func_190926_b()) {
            int selectedIndex;
            NBTTagCompound nbtTC;
            ItemStack dankNull = inventory.getDankNull();
            if (!dankNull.func_77942_o()) {
                DankNullUtils.setSelectedStackIndex(inventory, DankNullUtils.isEmpty(inventory) ? 1 : 0);
            }
            if (!(nbtTC = dankNull.func_77978_p()).func_74764_b("selectedIndex")) {
                nbtTC.func_74768_a("selectedIndex", 0);
            }
            if ((selectedIndex = nbtTC.func_74762_e("selectedIndex")) > -1) {
                return inventory.func_70301_a(selectedIndex);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isEmpty(InventoryDankNull inventory) {
        return inventory.func_191420_l();
    }

    public static boolean isFiltered(InventoryDankNull inventory, ItemStack filteredStack) {
        if (inventory != null) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (inventory.func_70301_a(i).func_190926_b() || !ItemUtils.areItemsEqual((ItemStack)inventory.func_70301_a(i), (ItemStack)filteredStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFilteredOreDict(InventoryDankNull inventory, ItemStack filteredStack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)filteredStack);
        if (inventory != null && ids.length > 0) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (inventory.func_70301_a(i).func_190926_b()) continue;
                for (int id : ids) {
                    String name = OreDictionary.getOreName((int)id);
                    NonNullList oreList = OreDictionary.getOres((String)name);
                    for (ItemStack ore : oreList) {
                        if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)inventory.func_70301_a(i), (boolean)false)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static DankNullItemHandler getHandler(ItemStack dankNull) {
        if (DankNullUtils.hasDankNullHandler(dankNull)) {
            return (DankNullItemHandler)dankNull.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        return null;
    }

    public static boolean hasDankNullHandler(ItemStack dankNull) {
        return dankNull.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    public static boolean addFilteredStackToDankNull(InventoryDankNull inventory, ItemStack filteredStack) {
        if (DankNullUtils.getIndexForStack(inventory, filteredStack) >= 0) {
            ItemStack currentStack = DankNullUtils.getFilteredStack(inventory, filteredStack);
            currentStack.func_190917_f(filteredStack.func_190916_E());
            if (currentStack.func_190916_E() > DankNullUtils.getDankNullMaxStackSize(inventory)) {
                currentStack.func_190920_e(DankNullUtils.getDankNullMaxStackSize(inventory));
            }
            inventory.func_70299_a(DankNullUtils.getIndexForStack(inventory, filteredStack), currentStack);
            return true;
        }
        return false;
    }

    public static ItemStack getFilteredStack(InventoryDankNull inventory, ItemStack stack) {
        if (DankNullUtils.isFiltered(inventory, stack)) {
            return DankNullUtils.getItemByIndex(inventory, DankNullUtils.getIndexForStack(inventory, stack));
        }
        return ItemStack.field_190927_a;
    }

    public static int getIndexForStack(InventoryDankNull inventory, ItemStack filteredStack) {
        if (DankNullUtils.isFiltered(inventory, filteredStack)) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (inventory.func_70301_a(i).func_190926_b() || !ItemUtils.areItemsEqual((ItemStack)inventory.func_70301_a(i), (ItemStack)filteredStack)) continue;
                return i;
            }
        }
        return -1;
    }

    public static ItemStack getItemByIndex(InventoryDankNull inventory, int index) {
        if (inventory != null && index >= 0) {
            return inventory.func_70301_a(index);
        }
        return ItemStack.field_190927_a;
    }

    public static void decrDankNullStackSize(@Nonnull InventoryDankNull inventory, @Nonnull ItemStack stack, int amount) {
        if (inventory == null || stack.func_190926_b()) {
            return;
        }
        if (DankNullUtils.isFiltered(inventory, stack)) {
            ItemStack currentStack = DankNullUtils.getFilteredStack(inventory, stack);
            currentStack.func_190920_e(currentStack.func_190916_E() - amount);
            if (currentStack.func_190916_E() <= 0) {
                currentStack = ItemStack.field_190927_a;
            }
            inventory.func_70296_d();
        }
    }

    public static InventoryDankNull getNewDankNullInventory(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof ItemDankNull ? new InventoryDankNull(stack) : null;
    }

    public static InventoryDankNull getInventoryFromStack(@Nonnull ItemStack stack) {
        return DankNullUtils.getNewDankNullInventory(stack);
    }

    public static int getDankNullMaxStackSize(@Nonnull ItemStack itemStackIn) {
        int level = itemStackIn.func_77952_i() + 1;
        if (level == 6) {
            return Integer.MAX_VALUE;
        }
        return level * (128 * level);
    }

    public static int getDankNullMaxStackSize(InventoryDankNull inventory) {
        if (inventory != null && !inventory.getDankNull().func_190926_b()) {
            int level = inventory.getDankNull().func_77952_i() + 1;
            if (level == 6) {
                return Integer.MAX_VALUE;
            }
            return level * (128 * level);
        }
        return 0;
    }

    public static int getColor(int damage, boolean opaque) {
        switch (damage) {
            case 0: {
                return opaque ? -1292216 : -1712568248;
            }
            case 1: {
                return opaque ? -12024340 : -1723300372;
            }
            default: {
                return opaque ? -1 : -1711276033;
            }
            case 3: {
                return opaque ? -256 : -1711276288;
            }
            case 4: {
                return opaque ? -16711681 : -1727987713;
            }
            case 5: 
        }
        return opaque ? -15204499 : -1726480531;
    }

    public static int getSlotCount(ItemStack stack) {
        return (stack.func_77952_i() + 1) * 9;
    }

    public static int getSlotCount(InventoryDankNull inventory) {
        return inventory.func_70302_i_();
    }

    public static void setSelectedIndexApplicable(InventoryDankNull inventory) {
        if (inventory != null && !inventory.getDankNull().func_190926_b()) {
            int i;
            if (DankNullUtils.getSelectedStackIndex(inventory) >= 0 && !DankNullUtils.getItemByIndex(inventory, DankNullUtils.getSelectedStackIndex(inventory)).func_190926_b()) {
                return;
            }
            boolean indexFound = false;
            for (i = DankNullUtils.getSelectedStackIndex(inventory); i > -1; --i) {
                if (DankNullUtils.getItemByIndex(inventory, i).func_190926_b()) continue;
                indexFound = true;
                DankNullUtils.setSelectedStackIndex(inventory, i);
                return;
            }
            for (i = DankNullUtils.getSlotCount(inventory) - 1; i > -1; --i) {
                if (DankNullUtils.getItemByIndex(inventory, i).func_190926_b()) continue;
                indexFound = true;
                DankNullUtils.setSelectedStackIndex(inventory, i);
                return;
            }
            if (!indexFound) {
                DankNullUtils.setSelectedStackIndex(inventory, -1);
            }
        }
    }

    public static EnumActionResult placeBlock(@Nonnull IBlockState state, World world, BlockPos pos) {
        return world.func_180501_a(pos, state, 2) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    public static IRecipe addDankNullUpgradeRecipe(String recipeName, Object ... params) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])params);
        IRecipe recipe = (IRecipe)new RecipeDankNullUpgrade((NonNullList<Ingredient>)primer.input).setRegistryName(new ResourceLocation("danknull", recipeName));
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
        return recipe;
    }

    public static Map<ItemStack, SlotExtractionMode> getExtractionModes(ItemStack dankNull) {
        HashMap modes = Maps.newHashMap();
        if (dankNull.func_77942_o() && dankNull.func_77978_p().func_150297_b(TAG_EXTRACTION_MODES, 9)) {
            NBTTagList extractionList = dankNull.func_77978_p().func_150295_c(TAG_EXTRACTION_MODES, 10);
            for (int i = 0; i < extractionList.func_74745_c(); ++i) {
                NBTTagCompound tempNBT = extractionList.func_150305_b(i);
                modes.put(new ItemStack(tempNBT.func_74775_l("Stack")), SlotExtractionMode.values()[tempNBT.func_74762_e("Mode")]);
            }
        }
        return modes;
    }

    public static void setExtractionModes(ItemStack dankNull, Map<ItemStack, SlotExtractionMode> modes) {
        if (modes.isEmpty()) {
            return;
        }
        if (!dankNull.func_77942_o()) {
            dankNull.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound dankNullNBT = dankNull.func_77978_p();
        NBTTagList extractionList = new NBTTagList();
        for (ItemStack stack : modes.keySet()) {
            NBTTagCompound tempNBT = new NBTTagCompound();
            if (stack.func_190916_E() != 1) {
                stack.func_190920_e(1);
            }
            tempNBT.func_74782_a("Stack", (NBTBase)stack.serializeNBT());
            tempNBT.func_74768_a("Mode", modes.get(stack).ordinal());
            extractionList.func_74742_a((NBTBase)tempNBT);
        }
        dankNullNBT.func_74782_a(TAG_EXTRACTION_MODES, (NBTBase)extractionList);
    }

    public static SlotExtractionMode getExtractionModeForStack(ItemStack dankNull, ItemStack stack) {
        Map<ItemStack, SlotExtractionMode> modes = DankNullUtils.getExtractionModes(dankNull);
        if (!modes.isEmpty()) {
            for (ItemStack currentStack : modes.keySet()) {
                if (!stack.func_77969_a(currentStack)) continue;
                return modes.get(currentStack);
            }
        }
        return SlotExtractionMode.KEEP_ALL;
    }

    public static void setExtractionModeForStack(ItemStack dankNull, ItemStack stack, SlotExtractionMode mode) {
        if (!dankNull.func_77942_o()) {
            dankNull.func_77982_d(new NBTTagCompound());
        }
        boolean alreadyAdded = false;
        ItemStack tempStack = stack.func_77946_l();
        tempStack.func_190920_e(1);
        Map<ItemStack, SlotExtractionMode> currentModes = DankNullUtils.getExtractionModes(dankNull);
        for (ItemStack currentStack : currentModes.keySet()) {
            if (!tempStack.func_77969_a(currentStack)) continue;
            currentModes.put(currentStack, mode);
            alreadyAdded = true;
        }
        if (!alreadyAdded) {
            currentModes.put(tempStack, mode);
        }
        DankNullUtils.setExtractionModes(dankNull, currentModes);
    }

    public static void cycleExtractionMode(ItemStack dankNull, ItemStack stack) {
        SlotExtractionMode current = DankNullUtils.getExtractionModeForStack(dankNull, stack);
        if (current.ordinal() >= SlotExtractionMode.values().length - 1) {
            DankNullUtils.setExtractionModeForStack(dankNull, stack, SlotExtractionMode.values()[0]);
        } else {
            DankNullUtils.setExtractionModeForStack(dankNull, stack, SlotExtractionMode.values()[current.ordinal() + 1]);
        }
        if (FMLCommonHandler.instance().getSide().isClient()) {
            if (DankNullUtils.getExtractionModeForStack(dankNull, stack) == null) {
                ModLogger.warn("no extraction mode found");
                return;
            }
            DankNull.PROXY.getPlayer().func_145747_a((ITextComponent)new TextComponentString(DankNullUtils.getExtractionModeForStack(dankNull, stack).getMessage()));
        }
    }

    public static enum SlotExtractionMode {
        KEEP_ALL(Integer.MAX_VALUE, "not extract"),
        KEEP_1(1, "extract all but one"),
        KEEP_16(16, "extract all but 16"),
        KEEP_64(64, "extract all but 64"),
        KEEP_NONE(0, "extract all items");

        int number = 0;
        String msg;

        private SlotExtractionMode(int numberToKeep, String message) {
            this.number = numberToKeep;
            this.msg = message;
        }

        public int getNumberToKeep() {
            return this.number;
        }

        public String getMessage() {
            return "Will " + this.msg + " from this slot";
        }

        public String getTooltip() {
            if (this.toString().equals("KEEP_ALL")) {
                return "Do " + this.msg;
            }
            return this.msg.substring(0, 1).toUpperCase() + this.msg.substring(1);
        }
    }
}

