/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item.tool;

import cofh.core.util.RayTracer;
import cofh.core.util.helpers.MathHelper;
import cofh.redstonearsenal.item.tool.ItemToolRF;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemPickaxeRF
extends ItemToolRF {
    public THashSet<Block> effectiveBlocksCharged = new THashSet();

    public ItemPickaxeRF(Item.ToolMaterial toolMaterial) {
        super(-2.8f, toolMaterial);
        this.addToolClass("pickaxe");
        this.damage = 3;
        this.energyPerUseCharged = 800;
        this.field_150914_c.addAll((Collection)ItemPickaxe.field_150915_c);
        this.effectiveBlocksCharged.addAll((Collection)ItemPickaxe.field_150915_c);
        this.effectiveBlocksCharged.addAll((Collection)ItemSpade.field_150916_c);
        this.effectiveMaterials.add((Object)Material.field_151573_f);
        this.effectiveMaterials.add((Object)Material.field_151574_g);
        this.effectiveMaterials.add((Object)Material.field_151576_e);
        this.effectiveMaterials.add((Object)Material.field_151588_w);
        this.effectiveMaterials.add((Object)Material.field_151598_x);
        this.effectiveMaterials.add((Object)Material.field_151592_s);
        this.effectiveMaterials.add((Object)Material.field_151591_t);
    }

    protected THashSet<Block> getEffectiveBlocks(ItemStack stack) {
        return this.isEmpowered(stack) ? this.effectiveBlocksCharged : super.getEffectiveBlocks(stack);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        float refStrength = state.func_185903_a(player, world, pos);
        if (refStrength != 0.0f) {
            if (this.isEmpowered(stack) && this.canHarvestBlock(state, stack)) {
                RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player);
                if (traceResult == null) {
                    return false;
                }
                if (traceResult.field_178784_b == EnumFacing.DOWN || traceResult.field_178784_b == EnumFacing.UP) {
                    int facing = MathHelper.floor((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                    if (facing % 2 == 0) {
                        BlockPos adjPos = new BlockPos(x, y, z - 1);
                        IBlockState adjState = world.func_180495_p(adjPos);
                        float strength = adjState.func_185903_a(player, world, adjPos);
                        if (strength > 0.0f && refStrength / strength <= 10.0f) {
                            this.harvestBlock(world, adjPos, player);
                        }
                        if ((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(x, y, z + 1))).func_185903_a(player, world, adjPos)) > 0.0f && refStrength / strength <= 10.0f) {
                            this.harvestBlock(world, adjPos, player);
                        }
                    } else {
                        BlockPos adjPos = new BlockPos(x - 1, y, z);
                        IBlockState adjState = world.func_180495_p(adjPos);
                        float strength = adjState.func_185903_a(player, world, adjPos);
                        if (strength > 0.0f && refStrength / strength <= 10.0f) {
                            this.harvestBlock(world, adjPos, player);
                        }
                        if ((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(x + 1, y, z))).func_185903_a(player, world, adjPos)) > 0.0f && refStrength / strength <= 10.0f) {
                            this.harvestBlock(world, adjPos, player);
                        }
                    }
                } else {
                    BlockPos adjPos = new BlockPos(x, y - 1, z);
                    IBlockState adjState = world.func_180495_p(adjPos);
                    float strength = adjState.func_185903_a(player, world, adjPos);
                    if (strength > 0.0f && refStrength / strength <= 10.0f) {
                        this.harvestBlock(world, adjPos, player);
                    }
                    if ((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(x, y + 1, z))).func_185903_a(player, world, adjPos)) > 0.0f && refStrength / strength <= 10.0f) {
                        this.harvestBlock(world, adjPos, player);
                    }
                }
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
        }
        return false;
    }
}

